/*
 * Decompiled with CFR 0.152.
 */
package com.dasburo.spring.cache.dynamo;

import com.dasburo.spring.cache.dynamo.DynamoCache;
import com.dasburo.spring.cache.dynamo.DynamoCacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractCacheManager;
import org.springframework.util.Assert;

public class DynamoCacheManager
extends AbstractCacheManager {
    private final Collection<DynamoCacheBuilder> initialCaches;

    public DynamoCacheManager(Collection<DynamoCacheBuilder> initialCaches) {
        Assert.notEmpty(initialCaches, (String)"At least one cache builder must be specified.");
        this.initialCaches = new ArrayList<DynamoCacheBuilder>(initialCaches);
    }

    protected Collection<? extends Cache> loadCaches() {
        LinkedHashSet<DynamoCache> caches = new LinkedHashSet<DynamoCache>(this.initialCaches.size());
        for (DynamoCacheBuilder cacheBuilder : this.initialCaches) {
            DynamoCache cache = cacheBuilder.build();
            caches.add(cache);
        }
        return caches;
    }
}

