/*
 * Decompiled with CFR 0.152.
 */
package com.dasburo.spring.cache.dynamo;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.dasburo.spring.cache.dynamo.DefaultDynamoCacheWriter;
import com.dasburo.spring.cache.dynamo.rootattribute.RootAttribute;
import java.time.Duration;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface DynamoCacheWriter {
    public static DynamoCacheWriter nonLockingDynamoCacheWriter(AmazonDynamoDB dynamoTemplate) {
        Assert.notNull((Object)dynamoTemplate, (String)"AmazonDynamoDB must not be null!");
        return new DefaultDynamoCacheWriter(dynamoTemplate);
    }

    public static DynamoCacheWriter lockingDynamoCacheWriter(AmazonDynamoDB dynamoTemplate) {
        Assert.notNull((Object)dynamoTemplate, (String)"AmazonDynamoDB must not be null!");
        return new DefaultDynamoCacheWriter(dynamoTemplate, Duration.ofMillis(50L));
    }

    public AmazonDynamoDB getNativeCacheWriter();

    public boolean createIfNotExists(String var1, Duration var2, Long var3, Long var4);

    public void put(String var1, String var2, byte[] var3, @Nullable Duration var4, @Nullable List<RootAttribute> var5);

    @Nullable
    public byte[] get(String var1, String var2);

    @Nullable
    public byte[] putIfAbsent(String var1, String var2, byte[] var3, @Nullable Duration var4, @Nullable List<RootAttribute> var5);

    public void remove(String var1, String var2);

    public void clear(String var1);
}

