/*
 * Decompiled with CFR 0.152.
 */
package com.dasburo.spring.cache.dynamo.autoconfigure;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.dasburo.spring.cache.dynamo.DynamoCacheBuilder;
import com.dasburo.spring.cache.dynamo.DynamoCacheManager;
import com.dasburo.spring.cache.dynamo.DynamoCacheWriter;
import com.dasburo.spring.cache.dynamo.autoconfigure.DynamoCacheProperties;
import com.dasburo.spring.cache.dynamo.autoconfigure.DynamoCachePropertiesList;
import com.dasburo.spring.cache.dynamo.serializer.StringSerializer;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={AmazonDynamoDB.class})
@ConditionalOnMissingBean(value={CacheManager.class})
@EnableConfigurationProperties(value={DynamoCachePropertiesList.class})
public class DynamoCacheAutoConfiguration {
    private final AmazonDynamoDB dynamoTemplate;
    private final DynamoCachePropertiesList properties;

    @Autowired
    public DynamoCacheAutoConfiguration(AmazonDynamoDB dynamoTemplate, DynamoCachePropertiesList properties) {
        this.dynamoTemplate = dynamoTemplate;
        this.properties = properties;
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cache.dynamo.caches[0].cacheName"})
    public CacheManager dynamoCacheManager() {
        return new DynamoCacheManager(this.dynamoCacheBuilders());
    }

    private List<DynamoCacheBuilder> dynamoCacheBuilders() {
        ArrayList<DynamoCacheBuilder> builders = new ArrayList<DynamoCacheBuilder>();
        if (this.properties.getCaches() != null) {
            for (DynamoCacheProperties dynamoCacheProperties : this.properties.getCaches()) {
                builders.add(DynamoCacheBuilder.newInstance(dynamoCacheProperties.getCacheName(), this.dynamoTemplate).withTTL(dynamoCacheProperties.getTtl()).withFlushOnBoot(dynamoCacheProperties.isFlushOnBoot()).withReadCapacityUnit(dynamoCacheProperties.getReadCapacityUnits()).withWriteCapacityUnit(dynamoCacheProperties.getWriteCapacityUnits()).withSerializer(new StringSerializer()).withRootAttributes(dynamoCacheProperties.getRootAttributes()).withWriter(DynamoCacheWriter.nonLockingDynamoCacheWriter(this.dynamoTemplate)));
            }
        }
        return builders;
    }
}

