/*
 * Decompiled with CFR 0.152.
 */
package com.dasburo.spring.cache.dynamo.serializer;

import com.dasburo.spring.cache.dynamo.serializer.DynamoSerializer;
import com.dasburo.spring.cache.dynamo.serializer.SerializationException;
import com.dasburo.spring.cache.dynamo.serializer.SerializationUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class GZipSerializer<T>
implements InitializingBean,
DynamoSerializer<T> {
    @Nullable
    private DynamoSerializer<T> parent;

    public GZipSerializer(DynamoSerializer<T> parent) {
        this.setParent(parent);
    }

    public void setParent(DynamoSerializer<T> parent) {
        Assert.notNull(parent, (String)"Parent serializer must not be null!");
        this.parent = parent;
    }

    @Override
    public byte[] serialize(@Nullable T t) throws SerializationException {
        byte[] data = this.parent.serialize(t);
        if (SerializationUtils.isEmpty(data)) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(data.length);
        try (GZIPOutputStream zipOut = new GZIPOutputStream(out);){
            zipOut.write(data);
        }
        catch (IOException e) {
            throw new SerializationException("Failed to zip value.", e);
        }
        return out.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T deserialize(@Nullable byte[] zippedBytes) throws SerializationException {
        if (SerializationUtils.isEmpty(zippedBytes)) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(zippedBytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (GZIPInputStream is = new GZIPInputStream(bais);){
            int chunkSize = 1024;
            byte[] buffer = new byte[chunkSize];
            int length = 0;
            while ((length = is.read(buffer, 0, chunkSize)) != -1) {
                baos.write(buffer, 0, length);
            }
            baos.close();
            bais.close();
            T t = this.parent.deserialize(baos.toByteArray());
            return t;
        }
        catch (IOException e) {
            throw new SerializationException("Failed to unzip value.", e);
        }
    }

    public void afterPropertiesSet() {
        Assert.notNull(this.parent, (String)"non-null parent serializer required");
    }
}

