/*
 * Decompiled with CFR 0.152.
 */
package com.dasburo.spring.cache.dynamo.serializer;

import com.dasburo.spring.cache.dynamo.serializer.DynamoSerializer;
import com.dasburo.spring.cache.dynamo.serializer.SerializationException;
import com.dasburo.spring.cache.dynamo.serializer.SerializationUtils;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Jackson2JsonSerializer<T>
implements DynamoSerializer<T> {
    private final JavaType javaType;
    private ObjectMapper objectMapper = new ObjectMapper();

    public Jackson2JsonSerializer(Class<T> type) {
        this.javaType = this.getJavaType(type);
    }

    public Jackson2JsonSerializer(JavaType javaType) {
        this.javaType = javaType;
    }

    @Override
    public T deserialize(@Nullable byte[] bytes) throws SerializationException {
        if (SerializationUtils.isEmpty(bytes)) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(bytes, 0, bytes.length, this.javaType);
        }
        catch (Exception ex) {
            throw new SerializationException("Could not read JSON: " + ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] serialize(@Nullable Object t) throws SerializationException {
        try {
            return t == null ? null : this.objectMapper.writeValueAsBytes(t);
        }
        catch (Exception ex) {
            throw new SerializationException("Could not write JSON: " + ex.getMessage(), ex);
        }
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null");
        this.objectMapper = objectMapper;
    }

    protected JavaType getJavaType(Class<?> clazz) {
        return TypeFactory.defaultInstance().constructType(clazz);
    }
}

