/*
 * Decompiled with CFR 0.152.
 */
package com.dasburo.spring.cache.dynamo.serializer;

import com.dasburo.spring.cache.dynamo.serializer.DynamoSerializer;
import com.dasburo.spring.cache.dynamo.serializer.SerializationException;
import com.dasburo.spring.cache.dynamo.serializer.SerializationUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;

public class OxmSerializer
implements InitializingBean,
DynamoSerializer<Object> {
    @Nullable
    private Marshaller marshaller;
    @Nullable
    private Unmarshaller unmarshaller;

    public OxmSerializer() {
    }

    public OxmSerializer(Marshaller marshaller, Unmarshaller unmarshaller) {
        this.setMarshaller(marshaller);
        this.setUnmarshaller(unmarshaller);
    }

    public void setMarshaller(Marshaller marshaller) {
        Assert.notNull((Object)marshaller, (String)"Marshaller must not be null!");
        this.marshaller = marshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        Assert.notNull((Object)unmarshaller, (String)"Unmarshaller must not be null!");
        this.unmarshaller = unmarshaller;
    }

    @Override
    public Object deserialize(@Nullable byte[] bytes) throws SerializationException {
        if (SerializationUtils.isEmpty(bytes)) {
            return null;
        }
        try {
            return this.unmarshaller.unmarshal((Source)new StreamSource(new ByteArrayInputStream(bytes)));
        }
        catch (Exception ex) {
            throw new SerializationException("Cannot deserialize bytes", ex);
        }
    }

    @Override
    public byte[] serialize(@Nullable Object t) throws SerializationException {
        if (t == null) {
            return null;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(stream);
        try {
            this.marshaller.marshal(t, (Result)result);
        }
        catch (Exception ex) {
            throw new SerializationException("Cannot serialize object", ex);
        }
        return stream.toByteArray();
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.marshaller, (String)"non-null marshaller required");
        Assert.notNull((Object)this.unmarshaller, (String)"non-null unmarshaller required");
    }
}

