/*
 * Decompiled with CFR 0.152.
 */
package com.dasburo.spring.cache.dynamo.serializer;

import com.dasburo.spring.cache.dynamo.serializer.DynamoSerializer;
import com.dasburo.spring.cache.dynamo.serializer.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.springframework.lang.Nullable;

public class SerializableSerializer
implements DynamoSerializer<Object> {
    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] serialize(@Nullable Object object) throws SerializationException {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream output = new ObjectOutputStream(buffer);){
                output.writeObject(object);
                byArray = buffer.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new SerializationException("Cannot serialize value.", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object deserialize(@Nullable byte[] bytes) throws SerializationException {
        if (bytes == null) {
            return null;
        }
        try (ByteArrayInputStream buffer = new ByteArrayInputStream(bytes);){
            Object object;
            try (ObjectInputStream output = new ObjectInputStream(buffer);){
                object = output.readObject();
            }
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new SerializationException("Cannot deserialize the value.", e);
        }
    }
}

