/*
 * Decompiled with CFR 0.152.
 */
package com.dashjoin.jsonata;

import com.dashjoin.jsonata.JException;
import com.dashjoin.jsonata.Utils;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tokenizer {
    static HashMap<String, Integer> operators = new HashMap<String, Integer>(){
        {
            this.put(".", 75);
            this.put("[", 80);
            this.put("]", 0);
            this.put("{", 70);
            this.put("}", 0);
            this.put("(", 80);
            this.put(")", 0);
            this.put(",", 0);
            this.put("@", 80);
            this.put("#", 80);
            this.put(";", 80);
            this.put(":", 80);
            this.put("?", 20);
            this.put("+", 50);
            this.put("-", 50);
            this.put("*", 60);
            this.put("/", 60);
            this.put("%", 60);
            this.put("|", 20);
            this.put("=", 40);
            this.put("<", 40);
            this.put(">", 40);
            this.put("^", 40);
            this.put("**", 60);
            this.put("..", 20);
            this.put(":=", 10);
            this.put("!=", 40);
            this.put("<=", 40);
            this.put(">=", 40);
            this.put("~>", 40);
            this.put("and", 30);
            this.put("or", 25);
            this.put("in", 40);
            this.put("&", 50);
            this.put("!", 0);
            this.put("~", 0);
        }
    };
    static HashMap<String, String> escapes = new HashMap<String, String>(){
        {
            this.put("\"", "\"");
            this.put("\\", "\\");
            this.put("/", "/");
            this.put("b", "\b");
            this.put("f", "\f");
            this.put("n", "\n");
            this.put("r", "\r");
            this.put("t", "\t");
        }
    };
    String path;
    int position = 0;
    int length;
    int depth;

    Tokenizer(String path) {
        this.path = path;
        this.length = path.length();
    }

    Token create(String type, Object value) {
        Token t = new Token();
        t.type = type;
        t.value = value;
        t.position = this.position;
        return t;
    }

    boolean isClosingSlash(int position) {
        if (this.path.charAt(position) == '/' && this.depth == 0) {
            int backslashCount = 0;
            while (this.path.charAt(position - (backslashCount + 1)) == '\\') {
                ++backslashCount;
            }
            if (backslashCount % 2 == 0) {
                return true;
            }
        }
        return false;
    }

    Pattern scanRegex() {
        int start = this.position;
        while (this.position < this.length) {
            char currentChar = this.path.charAt(this.position);
            if (this.isClosingSlash(this.position)) {
                String pattern = this.path.substring(start, this.position);
                if (pattern.equals("")) {
                    throw new JException("S0301", this.position);
                }
                ++this.position;
                currentChar = this.path.charAt(this.position);
                start = this.position;
                while (currentChar == 'i' || currentChar == 'm') {
                    ++this.position;
                    currentChar = this.path.charAt(this.position);
                }
                String flags = this.path.substring(start, this.position) + "g";
                int _flags = 0;
                if (flags.contains("i")) {
                    _flags |= 2;
                }
                if (flags.contains("m")) {
                    _flags |= 8;
                }
                return Pattern.compile(pattern, _flags);
            }
            if ((currentChar == '(' || currentChar == '[' || currentChar == '{') && this.path.charAt(this.position - 1) != '\\') {
                ++this.depth;
            }
            if ((currentChar == ')' || currentChar == ']' || currentChar == '}') && this.path.charAt(this.position - 1) != '\\') {
                --this.depth;
            }
            ++this.position;
        }
        throw new JException("S0302", this.position);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Token next(boolean prefix) {
        boolean haveMore;
        if (this.position >= this.length) {
            return null;
        }
        char currentChar = this.path.charAt(this.position);
        while (this.position < this.length && " \t\n\r".indexOf(currentChar) > -1) {
            ++this.position;
            if (this.position >= this.length) {
                return null;
            }
            currentChar = this.path.charAt(this.position);
        }
        if (currentChar == '/' && this.path.charAt(this.position + 1) == '*') {
            int commentStart = this.position;
            this.position += 2;
            currentChar = this.path.charAt(this.position);
            while (currentChar != '*' || this.path.charAt(this.position + 1) != '/') {
                currentChar = this.path.charAt(++this.position);
                if (this.position < this.length) continue;
                throw new JException("S0106", commentStart);
            }
            this.position += 2;
            currentChar = this.path.charAt(this.position);
            return this.next(prefix);
        }
        if (!prefix && currentChar == '/') {
            ++this.position;
            return this.create("regex", this.scanRegex());
        }
        boolean bl = haveMore = this.position < this.path.length() - 1;
        if (currentChar == '.' && haveMore && this.path.charAt(this.position + 1) == '.') {
            this.position += 2;
            return this.create("operator", "..");
        }
        if (currentChar == ':' && haveMore && this.path.charAt(this.position + 1) == '=') {
            this.position += 2;
            return this.create("operator", ":=");
        }
        if (currentChar == '!' && haveMore && this.path.charAt(this.position + 1) == '=') {
            this.position += 2;
            return this.create("operator", "!=");
        }
        if (currentChar == '>' && haveMore && this.path.charAt(this.position + 1) == '=') {
            this.position += 2;
            return this.create("operator", ">=");
        }
        if (currentChar == '<' && haveMore && this.path.charAt(this.position + 1) == '=') {
            this.position += 2;
            return this.create("operator", "<=");
        }
        if (currentChar == '*' && haveMore && this.path.charAt(this.position + 1) == '*') {
            this.position += 2;
            return this.create("operator", "**");
        }
        if (currentChar == '~' && haveMore && this.path.charAt(this.position + 1) == '>') {
            this.position += 2;
            return this.create("operator", "~>");
        }
        if (operators.get("" + currentChar) != null) {
            ++this.position;
            return this.create("operator", Character.valueOf(currentChar));
        }
        if (currentChar == '\"' || currentChar == '\'') {
            char quoteType = currentChar;
            ++this.position;
            Object qstr = "";
            while (this.position < this.length) {
                currentChar = this.path.charAt(this.position);
                if (currentChar == '\\') {
                    ++this.position;
                    currentChar = this.path.charAt(this.position);
                    if (escapes.get("" + currentChar) != null) {
                        qstr = (String)qstr + escapes.get("" + currentChar);
                    } else {
                        if (currentChar != 'u') throw new JException("S0301", this.position, Character.valueOf(currentChar));
                        String octets = this.path.substring(this.position + 1, this.position + 1 + 4);
                        if (!octets.matches("^[0-9a-fA-F]+$")) throw new JException("S0104", this.position);
                        int codepoint = Integer.parseInt(octets, 16);
                        qstr = (String)qstr + Character.toString((char)codepoint);
                        this.position += 4;
                    }
                } else {
                    if (currentChar == quoteType) {
                        ++this.position;
                        return this.create("string", qstr);
                    }
                    qstr = (String)qstr + currentChar;
                }
                ++this.position;
            }
            throw new JException("S0101", this.position);
        }
        Pattern numregex = Pattern.compile("^-?(0|([1-9][0-9]*))(\\.[0-9]+)?([Ee][-+]?[0-9]+)?");
        Matcher match = numregex.matcher(this.path.substring(this.position));
        if (match.find()) {
            double num = Double.parseDouble(match.group(0));
            if (Double.isNaN(num) || !Double.isFinite(num)) throw new JException("S0102", this.position);
            this.position += match.group(0).length();
            return this.create("number", Utils.convertNumber(num));
        }
        if (currentChar == '`') {
            ++this.position;
            int end = this.path.indexOf(96, this.position);
            if (end != -1) {
                String name = this.path.substring(this.position, end);
                this.position = end + 1;
                return this.create("name", name);
            }
            this.position = this.length;
            throw new JException("S0105", this.position);
        }
        int i = this.position;
        while (true) {
            char ch;
            char c = ch = i < this.length ? this.path.charAt(i) : (char)'\u0000';
            if (i == this.length || " \t\n\r".indexOf(ch) > -1 || operators.containsKey("" + ch)) {
                if (this.path.charAt(this.position) == '$') {
                    String _name = this.path.substring(this.position + 1, i);
                    this.position = i;
                    return this.create("variable", _name);
                }
                String _name = this.path.substring(this.position, i);
                this.position = i;
                switch (_name) {
                    case "or": 
                    case "in": 
                    case "and": {
                        return this.create("operator", _name);
                    }
                    case "true": {
                        return this.create("value", true);
                    }
                    case "false": {
                        return this.create("value", false);
                    }
                    case "null": {
                        return this.create("value", null);
                    }
                }
                if (this.position != this.length || !_name.equals("")) return this.create("name", _name);
                return null;
            }
            ++i;
        }
    }

    public static class Token {
        String type;
        Object value;
        int position;
        String id;
    }
}

