/*
 * Decompiled with CFR 0.152.
 */
package com.dashjoin.jsonata;

import com.dashjoin.jsonata.Functions;
import com.dashjoin.jsonata.JException;
import com.dashjoin.jsonata.Parser;
import com.dashjoin.jsonata.Timebox;
import com.dashjoin.jsonata.Utils;
import com.dashjoin.jsonata.utils.Signature;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Jsonata {
    static Frame staticFrame;
    public static final Object NULL_VALUE;
    static Parser.Symbol chainAST;
    static final ThreadLocal<Jsonata> current;
    static HashMap<String, String> errorCodes;
    List<Exception> errors;
    Frame environment;
    Parser.Symbol ast;
    long timestamp;
    Object input;
    boolean validateInput = true;
    static final ThreadLocal<Parser> _parser;
    final Parser parser = Jsonata.getParser();

    Object evaluate(Parser.Symbol expr, Object input, Frame environment) {
        return this.getPerThreadInstance()._evaluate(expr, input, environment);
    }

    Object _evaluate(Parser.Symbol expr, Object input, Frame environment) {
        Object exitCallback;
        Object entryCallback;
        Object result = null;
        this.input = input;
        this.environment = environment;
        if (this.parser.dbg) {
            System.out.println("eval expr=" + String.valueOf(expr) + " type=" + expr.type);
        }
        if ((entryCallback = environment.lookup("__evaluate_entry")) != null) {
            ((EntryCallback)entryCallback).callback(expr, input, environment);
        }
        if (expr.type != null) {
            switch (expr.type) {
                case "path": {
                    result = this.evaluatePath(expr, input, environment);
                    break;
                }
                case "binary": {
                    result = this.evaluateBinary(expr, input, environment);
                    break;
                }
                case "unary": {
                    result = this.evaluateUnary(expr, input, environment);
                    break;
                }
                case "name": {
                    result = this.evaluateName(expr, input, environment);
                    if (!this.parser.dbg) break;
                    System.out.println("evalName " + String.valueOf(result));
                    break;
                }
                case "string": 
                case "number": 
                case "value": {
                    result = this.evaluateLiteral(expr);
                    break;
                }
                case "wildcard": {
                    result = this.evaluateWildcard(expr, input);
                    break;
                }
                case "descendant": {
                    result = this.evaluateDescendants(expr, input);
                    break;
                }
                case "parent": {
                    result = environment.lookup(expr.slot.label);
                    break;
                }
                case "condition": {
                    result = this.evaluateCondition(expr, input, environment);
                    break;
                }
                case "block": {
                    result = this.evaluateBlock(expr, input, environment);
                    break;
                }
                case "bind": {
                    result = this.evaluateBindExpression(expr, input, environment);
                    break;
                }
                case "regex": {
                    result = this.evaluateRegex(expr);
                    break;
                }
                case "function": {
                    result = this.evaluateFunction(expr, input, environment, null);
                    break;
                }
                case "variable": {
                    result = this.evaluateVariable(expr, input, environment);
                    break;
                }
                case "lambda": {
                    result = this.evaluateLambda(expr, input, environment);
                    break;
                }
                case "partial": {
                    result = this.evaluatePartialApplication(expr, input, environment);
                    break;
                }
                case "apply": {
                    result = this.evaluateApplyExpression(expr, input, environment);
                    break;
                }
                case "transform": {
                    result = this.evaluateTransformExpression(expr, input, environment);
                }
            }
        }
        if (expr.predicate != null) {
            for (int ii = 0; ii < expr.predicate.size(); ++ii) {
                result = this.evaluateFilter(expr.predicate.get((int)ii).expr, result, environment);
            }
        }
        if (!expr.type.equals("path") && expr.group != null) {
            result = this.evaluateGroupExpression(expr.group, result, environment);
        }
        if ((exitCallback = environment.lookup("__evaluate_exit")) != null) {
            ((ExitCallback)exitCallback).callback(expr, input, environment, result);
        }
        if (result != null && Utils.isSequence(result) && !((Utils.JList)result).tupleStream) {
            Utils.JList _result = (Utils.JList)result;
            if (expr.keepArray) {
                _result.keepSingleton = true;
            }
            if (_result.isEmpty()) {
                result = null;
            } else if (_result.size() == 1) {
                result = _result.keepSingleton ? _result : _result.get(0);
            }
        }
        return result;
    }

    Object evaluatePath(Parser.Symbol expr, Object input, Frame environment) {
        int ii;
        List inputSequence = input instanceof List && !expr.steps.get((int)0).type.equals("variable") ? (List)input : Utils.createSequence(input);
        Object resultSequence = null;
        boolean isTupleStream = false;
        List tupleBindings = null;
        for (ii = 0; ii < expr.steps.size(); ++ii) {
            Parser.Symbol step = expr.steps.get(ii);
            if (step.tuple != null) {
                isTupleStream = true;
            }
            if (ii == 0 && step.consarray) {
                resultSequence = (List)this.evaluate(step, inputSequence, environment);
            } else if (isTupleStream) {
                tupleBindings = (List)this.evaluateTupleStep(step, inputSequence, tupleBindings, environment);
            } else {
                resultSequence = this.evaluateStep(step, inputSequence, environment, ii == expr.steps.size() - 1);
            }
            if (!isTupleStream && (resultSequence == null || resultSequence.size() == 0)) break;
            if (step.focus != null) continue;
            inputSequence = (List)resultSequence;
        }
        if (isTupleStream) {
            if (expr.tuple != null) {
                resultSequence = tupleBindings;
            } else {
                resultSequence = Utils.createSequence();
                for (ii = 0; ii < tupleBindings.size(); ++ii) {
                    resultSequence.add(((Map)tupleBindings.get(ii)).get("@"));
                }
            }
        }
        if (expr.keepSingletonArray) {
            if (!(resultSequence instanceof Utils.JList)) {
                resultSequence = new Utils.JList<Object>((Collection<Object>)resultSequence);
            }
            if (resultSequence instanceof Utils.JList && ((Utils.JList)resultSequence).cons && !((Utils.JList)resultSequence).sequence) {
                resultSequence = Utils.createSequence(resultSequence);
            }
            ((Utils.JList)resultSequence).keepSingleton = true;
        }
        if (expr.group != null) {
            resultSequence = this.evaluateGroupExpression(expr.group, isTupleStream ? tupleBindings : resultSequence, environment);
        }
        return resultSequence;
    }

    Frame createFrameFromTuple(Frame environment, Map<String, Object> tuple) {
        Frame frame = this.createFrame(environment);
        if (tuple != null) {
            for (String prop : tuple.keySet()) {
                frame.bind(prop, tuple.get(prop));
            }
        }
        return frame;
    }

    Object evaluateStep(Parser.Symbol expr, Object input, Frame environment, boolean lastStep) {
        if (expr.type.equals("sort")) {
            Object result = this.evaluateSortExpression(expr, input, environment);
            if (expr.stages != null) {
                result = this.evaluateStages(expr.stages, result, environment);
            }
            return result;
        }
        List<Object> result = Utils.createSequence();
        for (int ii = 0; ii < ((List)input).size(); ++ii) {
            Object res = this.evaluate(expr, ((List)input).get(ii), environment);
            if (expr.stages != null) {
                for (int ss = 0; ss < expr.stages.size(); ++ss) {
                    res = this.evaluateFilter(expr.stages.get((int)ss).expr, res, environment);
                }
            }
            if (res == null) continue;
            result.add(res);
        }
        List resultSequence = Utils.createSequence();
        if (lastStep && result.size() == 1 && result.get(0) instanceof List && !Utils.isSequence(result.get(0))) {
            resultSequence = (List)result.get(0);
        } else {
            for (Object res : result) {
                if (!(res instanceof List) || res instanceof Utils.JList && ((Utils.JList)res).cons) {
                    resultSequence.add((Object)res);
                    continue;
                }
                resultSequence.addAll((List)res);
            }
        }
        return resultSequence;
    }

    Object evaluateStages(List<Parser.Symbol> stages, Object input, Frame environment) {
        Object result = input;
        block8: for (int ss = 0; ss < stages.size(); ++ss) {
            Parser.Symbol stage = stages.get(ss);
            switch (stage.type) {
                case "filter": {
                    result = this.evaluateFilter(stage.expr, result, environment);
                    continue block8;
                }
                case "index": {
                    for (int ee = 0; ee < ((List)result).size(); ++ee) {
                        Object tuple = ((List)result).get(ee);
                        ((Map)tuple).put(String.valueOf(stage.value), ee);
                    }
                    continue block8;
                }
            }
        }
        return result;
    }

    Object evaluateTupleStep(Parser.Symbol expr, List input, List<Map> tupleBindings, Frame environment) {
        List result = null;
        if (expr.type.equals("sort")) {
            if (tupleBindings != null) {
                result = (List)this.evaluateSortExpression(expr, tupleBindings, environment);
            } else {
                List sorted = (List)this.evaluateSortExpression(expr, input, environment);
                result = Utils.createSequence();
                ((Utils.JList)result).tupleStream = true;
                for (int ss = 0; ss < sorted.size(); ++ss) {
                    Map<Object, Integer> tuple = Map.of("@", sorted.get(ss), expr.index, ss);
                    result.add(tuple);
                }
            }
            if (expr.stages != null) {
                result = (List)this.evaluateStages(expr.stages, result, environment);
            }
            return result;
        }
        result = Utils.createSequence();
        ((Utils.JList)result).tupleStream = true;
        Frame stepEnv = environment;
        if (tupleBindings == null) {
            tupleBindings = input.stream().filter(item -> item != null).map(item -> Map.of("@", item)).collect(Collectors.toList());
        }
        for (int ee = 0; ee < tupleBindings.size(); ++ee) {
            ArrayList<Object> res;
            stepEnv = this.createFrameFromTuple(environment, tupleBindings.get(ee));
            Object _res = this.evaluate(expr, tupleBindings.get(ee).get("@"), stepEnv);
            if (_res == null) continue;
            if (!(_res instanceof List)) {
                res = new ArrayList<Object>();
                res.add(_res);
            } else {
                res = (ArrayList<Object>)_res;
            }
            for (int bb = 0; bb < res.size(); ++bb) {
                LinkedHashMap<Object, Object> tuple = new LinkedHashMap<Object, Object>();
                tuple.putAll(tupleBindings.get(ee));
                if (res instanceof Utils.JList && ((Utils.JList)res).tupleStream) {
                    tuple.putAll((Map)res.get(bb));
                } else {
                    if (expr.focus != null) {
                        tuple.put(expr.focus, res.get(bb));
                        tuple.put("@", tupleBindings.get(ee).get("@"));
                    } else {
                        tuple.put("@", res.get(bb));
                    }
                    if (expr.index != null) {
                        tuple.put(expr.index, bb);
                    }
                    if (expr.ancestor != null) {
                        tuple.put(expr.ancestor.label, tupleBindings.get(ee).get("@"));
                    }
                }
                result.add(tuple);
            }
        }
        if (expr.stages != null) {
            result = (List)this.evaluateStages(expr.stages, result, environment);
        }
        return result;
    }

    Object evaluateFilter(Object _predicate, Object input, Frame environment) {
        Parser.Symbol predicate = (Parser.Symbol)_predicate;
        List results = Utils.createSequence();
        if (input instanceof Utils.JList && ((Utils.JList)input).tupleStream) {
            ((Utils.JList)results).tupleStream = true;
        }
        if (!(input instanceof List)) {
            input = Utils.createSequence(input);
        }
        if (predicate.type.equals("number")) {
            Object item;
            int index = ((Number)predicate.value).intValue();
            if (index < 0) {
                index = input.size() + index;
            }
            Object object = item = index < input.size() ? input.get(index) : null;
            if (item != null) {
                if (item instanceof List) {
                    results = (List)item;
                } else {
                    results.add(item);
                }
            }
        } else {
            for (int index = 0; index < input.size(); ++index) {
                List<Object> res;
                Object item;
                Object context = item = input.get(index);
                Frame env = environment;
                if (input instanceof Utils.JList && ((Utils.JList)input).tupleStream) {
                    context = ((Map)item).get("@");
                    env = this.createFrameFromTuple(environment, (Map)item);
                }
                if (Utils.isNumeric(res = this.evaluate(predicate, context, env))) {
                    res = Utils.createSequence(res);
                }
                if (Utils.isArrayOfNumbers(res)) {
                    for (Object ires : res) {
                        int ii = ((Number)ires).intValue();
                        if (ii < 0) {
                            ii = input.size() + ii;
                        }
                        if (ii != index) continue;
                        results.add(item);
                    }
                    continue;
                }
                if (!Jsonata.boolize(res)) continue;
                results.add(item);
            }
        }
        return results;
    }

    Object evaluateBinary(Parser.Symbol _expr, final Object input, final Frame environment) {
        final Parser.Infix expr = (Parser.Infix)_expr;
        Object result = null;
        Object lhs = this.evaluate(expr.lhs, input, environment);
        String op = String.valueOf(expr.value);
        if (op.equals("and") || op.equals("or")) {
            Callable evalrhs = new Callable(){

                public Object call() throws Exception {
                    return Jsonata.this.evaluate(expr.rhs, input, environment);
                }
            };
            try {
                return this.evaluateBooleanExpression(lhs, evalrhs, op);
            }
            catch (Exception err) {
                if (!(err instanceof JException)) {
                    throw new JException("Unexpected", expr.position);
                }
                throw (JException)err;
            }
        }
        Object rhs = this.evaluate(expr.rhs, input, environment);
        switch (op) {
            case "+": 
            case "-": 
            case "*": 
            case "/": 
            case "%": {
                result = this.evaluateNumericExpression(lhs, rhs, op);
                break;
            }
            case "=": 
            case "!=": {
                result = this.evaluateEqualityExpression(lhs, rhs, op);
                break;
            }
            case "<": 
            case "<=": 
            case ">": 
            case ">=": {
                result = this.evaluateComparisonExpression(lhs, rhs, op);
                break;
            }
            case "&": {
                result = this.evaluateStringConcat(lhs, rhs);
                break;
            }
            case "..": {
                result = this.evaluateRangeExpression(lhs, rhs);
                break;
            }
            case "in": {
                result = this.evaluateIncludesExpression(lhs, rhs);
                break;
            }
            default: {
                throw new JException("Unexpected operator " + op, expr.position);
            }
        }
        return result;
    }

    Object evaluateUnary(Parser.Symbol expr, Object input, Frame environment) {
        Object result = null;
        switch (String.valueOf(expr.value)) {
            case "-": {
                result = this.evaluate(expr.expression, input, environment);
                if (result == null) {
                    result = null;
                    break;
                }
                if (Utils.isNumeric(result)) {
                    result = Utils.convertNumber(-((Number)result).doubleValue());
                    break;
                }
                throw new JException("D1002", expr.position, expr.value, result);
            }
            case "[": {
                result = new Utils.JList();
                int idx = 0;
                for (Parser.Symbol item : expr.expressions) {
                    environment.isParallelCall = idx > 0;
                    Object value = this.evaluate(item, input, environment);
                    if (value != null) {
                        if (String.valueOf(item.value).equals("[")) {
                            ((List)result).add(value);
                        } else {
                            result = Functions.append(result, value);
                        }
                    }
                    ++idx;
                }
                if (!expr.consarray) break;
                if (!(result instanceof Utils.JList)) {
                    result = new Utils.JList((List)result);
                }
                ((Utils.JList)result).cons = true;
                break;
            }
            case "{": {
                result = this.evaluateGroupExpression(expr, input, environment);
            }
        }
        return result;
    }

    Object evaluateName(Parser.Symbol expr, Object input, Frame environment) {
        return Functions.lookup(input, (String)expr.value);
    }

    Object evaluateLiteral(Parser.Symbol expr) {
        return expr.value != null ? expr.value : NULL_VALUE;
    }

    Object evaluateWildcard(Parser.Symbol expr, Object input) {
        List results;
        block7: {
            block6: {
                results = Utils.createSequence();
                if (input instanceof Utils.JList && ((Utils.JList)input).outerWrapper && ((Utils.JList)input).size() > 0) {
                    input = ((Utils.JList)input).get(0);
                }
                if (input == null || !(input instanceof Map)) break block6;
                for (Object key : ((Map)input).keySet()) {
                    Object value = ((Map)input).get(key);
                    if (value instanceof List) {
                        value = this.flatten(value, null);
                        results = (List)Functions.append(results, value);
                        continue;
                    }
                    results.add(value);
                }
                break block7;
            }
            if (!(input instanceof List)) break block7;
            for (Object value : (List)input) {
                if (value instanceof List) {
                    value = this.flatten(value, null);
                    results = (List)Functions.append(results, value);
                    continue;
                }
                if (value instanceof Map) {
                    results.addAll((List)this.evaluateWildcard(expr, value));
                    continue;
                }
                results.add(value);
            }
        }
        return results;
    }

    Object flatten(Object arg, List flattened) {
        if (flattened == null) {
            flattened = new ArrayList<Object>();
        }
        if (arg instanceof List) {
            for (Object item : (List)arg) {
                this.flatten(item, flattened);
            }
        } else {
            flattened.add(arg);
        }
        return flattened;
    }

    Object evaluateDescendants(Parser.Symbol expr, Object input) {
        Object result = null;
        List<Object> resultSequence = Utils.createSequence();
        if (input != null) {
            this.recurseDescendants(input, resultSequence);
            result = resultSequence.size() == 1 ? resultSequence.get(0) : resultSequence;
        }
        return result;
    }

    void recurseDescendants(Object input, List results) {
        block4: {
            block3: {
                if (!(input instanceof List)) {
                    results.add(input);
                }
                if (!(input instanceof List)) break block3;
                for (Object member : (List)input) {
                    this.recurseDescendants(member, results);
                }
                break block4;
            }
            if (input == null || !(input instanceof Map)) break block4;
            for (Object key : ((Map)input).keySet()) {
                this.recurseDescendants(((Map)input).get(key), results);
            }
        }
    }

    Object evaluateNumericExpression(Object _lhs, Object _rhs, String op) {
        double result = 0.0;
        if (_lhs != null && !Utils.isNumeric(_lhs)) {
            throw new JException("T2001", -1, op, _lhs);
        }
        if (_rhs != null && !Utils.isNumeric(_rhs)) {
            throw new JException("T2002", -1, op, _rhs);
        }
        if (_lhs == null || _rhs == null) {
            return null;
        }
        double lhs = ((Number)_lhs).doubleValue();
        double rhs = ((Number)_rhs).doubleValue();
        switch (op) {
            case "+": {
                result = lhs + rhs;
                break;
            }
            case "-": {
                result = lhs - rhs;
                break;
            }
            case "*": {
                result = lhs * rhs;
                break;
            }
            case "/": {
                result = lhs / rhs;
                break;
            }
            case "%": {
                result = lhs % rhs;
            }
        }
        return Utils.convertNumber(result);
    }

    Object evaluateEqualityExpression(Object lhs, Object rhs, String op) {
        String rtype;
        Boolean result = null;
        String ltype = lhs != null ? lhs.getClass().getSimpleName() : null;
        String string = rtype = rhs != null ? rhs.getClass().getSimpleName() : null;
        if (ltype == null || rtype == null) {
            return false;
        }
        if (lhs instanceof Number) {
            lhs = ((Number)lhs).doubleValue();
        }
        if (rhs instanceof Number) {
            rhs = ((Number)rhs).doubleValue();
        }
        switch (op) {
            case "=": {
                result = lhs.equals(rhs);
                break;
            }
            case "!=": {
                result = !lhs.equals(rhs);
            }
        }
        return result;
    }

    Object evaluateComparisonExpression(Object lhs, Object rhs, String op) {
        boolean rcomparable;
        Boolean result = null;
        boolean lcomparable = lhs == null || lhs instanceof String || lhs instanceof Number;
        boolean bl = rcomparable = rhs == null || rhs instanceof String || rhs instanceof Number;
        if (!lcomparable || !rcomparable) {
            throw new JException("T2010", 0, op, lhs != null ? lhs : rhs);
        }
        if (lhs == null || rhs == null) {
            return null;
        }
        if (!lhs.getClass().equals(rhs.getClass())) {
            if (lhs instanceof Number && rhs instanceof Number) {
                lhs = ((Number)lhs).doubleValue();
                rhs = ((Number)rhs).doubleValue();
            } else {
                throw new JException("T2009", 0, lhs, rhs);
            }
        }
        Comparable _lhs = (Comparable)lhs;
        switch (op) {
            case "<": {
                result = _lhs.compareTo(rhs) < 0;
                break;
            }
            case "<=": {
                result = _lhs.compareTo(rhs) <= 0;
                break;
            }
            case ">": {
                result = _lhs.compareTo(rhs) > 0;
                break;
            }
            case ">=": {
                result = _lhs.compareTo(rhs) >= 0;
            }
        }
        return result;
    }

    Object evaluateIncludesExpression(Object lhs, Object rhs) {
        boolean result = false;
        if (lhs == null || rhs == null) {
            return false;
        }
        if (!(rhs instanceof List)) {
            ArrayList _rhs = new ArrayList();
            _rhs.add(rhs);
            rhs = _rhs;
        }
        for (int i = 0; i < ((List)rhs).size(); ++i) {
            if (!((List)rhs).get(i).equals(lhs)) continue;
            result = true;
            break;
        }
        return result;
    }

    Object evaluateBooleanExpression(Object lhs, Callable evalrhs, String op) throws Exception {
        Boolean result = null;
        boolean lBool = Jsonata.boolize(lhs);
        switch (op) {
            case "and": {
                result = lBool && Jsonata.boolize(evalrhs.call());
                break;
            }
            case "or": {
                result = lBool || Jsonata.boolize(evalrhs.call());
            }
        }
        return result;
    }

    public static boolean boolize(Object value) {
        Boolean booledValue = Functions.toBoolean(value);
        return booledValue == null ? false : booledValue;
    }

    Object evaluateStringConcat(Object lhs, Object rhs) {
        String lstr = "";
        String rstr = "";
        if (lhs != null) {
            lstr = Functions.string(lhs, null);
        }
        if (rhs != null) {
            rstr = Functions.string(rhs, null);
        }
        String result = lstr + rstr;
        return result;
    }

    Object evaluateGroupExpression(Parser.Symbol expr, Object _input, Frame environment) {
        List input;
        boolean reduce;
        LinkedHashMap result = new LinkedHashMap();
        LinkedHashMap<Object, GroupEntry> groups = new LinkedHashMap<Object, GroupEntry>();
        boolean bl = reduce = _input instanceof Utils.JList && ((Utils.JList)_input).tupleStream;
        if (!(_input instanceof List)) {
            _input = Utils.createSequence(_input);
        }
        if ((input = (List)_input).isEmpty()) {
            input.add(null);
        }
        for (int itemIndex = 0; itemIndex < input.size(); ++itemIndex) {
            Object item = input.get(itemIndex);
            Frame env = reduce ? this.createFrameFromTuple(environment, (Map)item) : environment;
            for (int pairIndex = 0; pairIndex < expr.lhsObject.size(); ++pairIndex) {
                Parser.Symbol[] pair = expr.lhsObject.get(pairIndex);
                Object key = this.evaluate(pair[0], reduce ? ((Map)item).get("@") : item, env);
                if (key != null && !(key instanceof String)) {
                    throw new JException("T1003", expr.position, key);
                }
                if (key == null) continue;
                GroupEntry entry = new GroupEntry();
                entry.data = item;
                entry.exprIndex = pairIndex;
                if (groups.get(key) != null) {
                    if (((GroupEntry)groups.get((Object)key)).exprIndex != pairIndex) {
                        throw new JException("D1009", expr.position, key);
                    }
                    ((GroupEntry)groups.get((Object)key)).data = Functions.append(((GroupEntry)groups.get((Object)key)).data, item);
                    continue;
                }
                groups.put(key, entry);
            }
        }
        int idx = 0;
        for (Map.Entry e : groups.entrySet()) {
            GroupEntry entry = (GroupEntry)e.getValue();
            Object context = entry.data;
            Frame env = environment;
            if (reduce) {
                Object tuple = this.reduceTupleStream(entry.data);
                context = ((Map)tuple).get("@");
                ((Map)tuple).remove("@");
                env = this.createFrameFromTuple(environment, (Map)tuple);
            }
            env.isParallelCall = idx > 0;
            Object res = this.evaluate(expr.lhsObject.get(entry.exprIndex)[1], context, env);
            if (res != null) {
                result.put(e.getKey(), res);
            }
            ++idx;
        }
        return result;
    }

    Object reduceTupleStream(Object _tupleStream) {
        if (!(_tupleStream instanceof List)) {
            return _tupleStream;
        }
        List tupleStream = (List)_tupleStream;
        LinkedHashMap result = new LinkedHashMap();
        result.putAll((Map)tupleStream.get(0));
        for (int ii = 1; ii < tupleStream.size(); ++ii) {
            Map el = (Map)tupleStream.get(ii);
            for (Object prop : el.keySet()) {
                result.put(prop, Functions.append(result.get(prop), el.get(prop)));
            }
        }
        return result;
    }

    Object evaluateRangeExpression(Object lhs, Object rhs) {
        long _rhs;
        Object result = null;
        if (lhs != null && !(lhs instanceof Long) && !(lhs instanceof Integer)) {
            throw new JException("T2003", -1, lhs);
        }
        if (rhs != null && !(rhs instanceof Long) && !(rhs instanceof Integer)) {
            throw new JException("T2004", -1, rhs);
        }
        if (rhs == null || lhs == null) {
            return result;
        }
        long _lhs = ((Number)lhs).longValue();
        if (_lhs > (_rhs = ((Number)rhs).longValue())) {
            return result;
        }
        long size = _rhs - _lhs + 1L;
        if ((double)size > 1.0E7) {
            throw new JException("D2014", -1, size);
        }
        return new Utils.RangeList(_lhs, _rhs);
    }

    Object evaluateBindExpression(Parser.Symbol expr, Object input, Frame environment) {
        Object value = this.evaluate(expr.rhs, input, environment);
        environment.bind(String.valueOf(expr.lhs.value), value);
        return value;
    }

    Object evaluateCondition(Parser.Symbol expr, Object input, Frame environment) {
        Object result = null;
        Object condition = this.evaluate(expr.condition, input, environment);
        if (Jsonata.boolize(condition)) {
            result = this.evaluate(expr.then, input, environment);
        } else if (expr._else != null) {
            result = this.evaluate(expr._else, input, environment);
        }
        return result;
    }

    Object evaluateBlock(Parser.Symbol expr, Object input, Frame environment) {
        Object result = null;
        Frame frame = this.createFrame(environment);
        for (Parser.Symbol ex : expr.expressions) {
            result = this.evaluate(ex, input, frame);
        }
        return result;
    }

    Object evaluateRegex(Parser.Symbol expr) {
        return expr.value;
    }

    Object evaluateVariable(Parser.Symbol expr, Object input, Frame environment) {
        Object result = null;
        if (expr.value.equals("")) {
            result = input instanceof Utils.JList && ((Utils.JList)input).outerWrapper ? ((Utils.JList)input).get(0) : input;
        } else {
            result = environment.lookup((String)expr.value);
            if (this.parser.dbg) {
                System.out.println("variable name=" + String.valueOf(expr.value) + " val=" + String.valueOf(result));
            }
        }
        return result;
    }

    Object evaluateSortExpression(final Parser.Symbol expr, Object input, final Frame environment) {
        List lhs = (List)input;
        final boolean isTupleSort = input instanceof Utils.JList && ((Utils.JList)input).tupleStream;
        Comparator comparator = new Comparator(){

            public int compare(Object a, Object b) {
                int comp = 0;
                for (int index = 0; comp == 0 && index < expr.terms.size(); ++index) {
                    Parser.Symbol term = expr.terms.get(index);
                    Object context = a;
                    Frame env = environment;
                    if (isTupleSort) {
                        context = ((Map)a).get("@");
                        env = Jsonata.this.createFrameFromTuple(environment, (Map)a);
                    }
                    Object aa = Jsonata.this.evaluate(term.expression, context, env);
                    context = b;
                    env = environment;
                    if (isTupleSort) {
                        context = ((Map)b).get("@");
                        env = Jsonata.this.createFrameFromTuple(environment, (Map)b);
                    }
                    Object bb = Jsonata.this.evaluate(term.expression, context, env);
                    if (aa == null) {
                        comp = bb == null ? 0 : 1;
                        continue;
                    }
                    if (bb == null) {
                        comp = -1;
                        continue;
                    }
                    if (!(aa instanceof Number) && !(aa instanceof String) || !(bb instanceof Number) && !(bb instanceof String)) {
                        throw new JException("T2008", expr.position, aa, bb);
                    }
                    boolean sameType = false;
                    if (aa instanceof Number && bb instanceof Number) {
                        sameType = true;
                    } else if (aa.getClass().isAssignableFrom(bb.getClass()) || bb.getClass().isAssignableFrom(aa.getClass())) {
                        sameType = true;
                    }
                    if (!sameType) {
                        throw new JException("T2007", expr.position, aa, bb);
                    }
                    if (aa.equals(bb)) continue;
                    comp = ((Comparable)aa).compareTo(bb) < 0 ? -1 : 1;
                    if (!term.descending) continue;
                    comp = -comp;
                }
                return comp;
            }
        };
        List result = Functions.sort(lhs, comparator);
        return result;
    }

    Object evaluateTransformExpression(Parser.Symbol expr, Object input, Frame environment) {
        JFunctionCallable transformer = (_input, args) -> {
            Object obj = args.get(0);
            if (obj == null) {
                return null;
            }
            Object result = Functions.functionClone(obj);
            ArrayList<Object> _matches = this.evaluate(expr.pattern, result, environment);
            if (_matches != null) {
                if (!(_matches instanceof List)) {
                    _matches = new ArrayList<Object>(List.of(_matches));
                }
                List matches = _matches;
                for (int ii = 0; ii < matches.size(); ++ii) {
                    ArrayList<Object> deletions;
                    Object match = matches.get(ii);
                    Object update = this.evaluate(expr.update, match, environment);
                    if (update != null) {
                        if (!(update instanceof Map)) {
                            throw new JException("T2011", expr.update.position, update);
                        }
                        for (Object prop : ((Map)update).keySet()) {
                            ((Map)match).put(prop, ((Map)update).get(prop));
                        }
                    }
                    if (expr.delete == null || (deletions = this.evaluate(expr.delete, match, environment)) == null) continue;
                    ArrayList<Object> val = deletions;
                    if (!(deletions instanceof List)) {
                        deletions = new ArrayList<Object>(List.of(deletions));
                    }
                    if (!Utils.isArrayOfStrings(deletions)) {
                        throw new JException("T2012", expr.delete.position, val);
                    }
                    List _deletions = deletions;
                    for (int jj = 0; jj < _deletions.size(); ++jj) {
                        if (!(match instanceof Map)) continue;
                        ((Map)match).remove(_deletions.get(jj));
                    }
                }
            }
            return result;
        };
        return new JFunction(transformer, "<(oa):o>");
    }

    static Parser.Symbol chainAST() {
        if (chainAST == null) {
            chainAST = new Parser().parse("function($f, $g) { function($x){ $g($f($x)) } }");
        }
        return chainAST;
    }

    Object evaluateApplyExpression(Parser.Symbol expr, Object input, Frame environment) {
        Object result = null;
        Object lhs = this.evaluate(expr.lhs, input, environment);
        if (lhs == null) {
            lhs = NULL_VALUE;
        }
        if (expr.rhs.type.equals("function")) {
            result = this.evaluateFunction(expr.rhs, input, environment, lhs);
        } else {
            Object func = this.evaluate(expr.rhs, input, environment);
            if (!this.isFunctionLike(func) && !this.isFunctionLike(lhs)) {
                throw new JException("T2006", expr.position, func);
            }
            if (this.isFunctionLike(lhs)) {
                Object chain = this.evaluate(Jsonata.chainAST(), null, environment);
                ArrayList<Object> args = new ArrayList<Object>();
                args.add(lhs);
                args.add(func);
                result = this.apply(chain, args, null, environment);
            } else {
                ArrayList<Object> args = new ArrayList<Object>();
                args.add(lhs);
                result = this.apply(func, args, null, environment);
            }
        }
        return result;
    }

    boolean isFunctionLike(Object o) {
        return Utils.isFunction(o) || Functions.isLambda(o) || o instanceof Pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Jsonata getPerThreadInstance() {
        Jsonata threadInst = current.get();
        if (threadInst != null) {
            return threadInst;
        }
        Jsonata jsonata = this;
        synchronized (jsonata) {
            threadInst = current.get();
            if (threadInst == null) {
                threadInst = new Jsonata(this);
                current.set(threadInst);
            }
            return threadInst;
        }
    }

    Object evaluateFunction(Parser.Symbol expr, Object input, Frame environment, Object applytoContext) {
        Object procName;
        Object result = null;
        Object proc = this.evaluate(expr.procedure, input, environment);
        if (proc == null && expr.procedure.type == "path" && environment.lookup((String)expr.procedure.steps.get((int)0).value) != null) {
            throw new JException("T1005", expr.position, expr.procedure.steps.get((int)0).value);
        }
        ArrayList<Object> evaluatedArgs = new ArrayList<Object>();
        if (applytoContext != null) {
            evaluatedArgs.add(applytoContext);
        }
        for (int jj = 0; jj < expr.arguments.size(); ++jj) {
            Object arg = this.evaluate(expr.arguments.get(jj), input, environment);
            if (Utils.isFunction(arg) || Functions.isLambda(arg)) {
                evaluatedArgs.add(arg);
                continue;
            }
            evaluatedArgs.add(arg);
        }
        Object object = procName = expr.procedure.type == "path" ? expr.procedure.steps.get((int)0).value : expr.procedure.value;
        if (proc == null) {
            throw new JException("T1006", expr.position, procName);
        }
        try {
            if (proc instanceof Parser.Symbol) {
                ((Parser.Symbol)proc).token = procName;
                ((Parser.Symbol)proc).position = expr.position;
            }
            result = this.apply(proc, evaluatedArgs, input, environment);
        }
        catch (JException jex) {
            if (jex.location < 0) {
                jex.location = expr.position;
            }
            if (jex.current == null) {
                jex.current = expr.token;
            }
            throw jex;
        }
        catch (Exception err) {
            if (!(err instanceof RuntimeException)) {
                throw new RuntimeException(err);
            }
            throw err;
        }
        return result;
    }

    Object apply(Object proc, Object args, Object input, Object environment) {
        Object result = this.applyInner(proc, args, input, environment);
        while (Functions.isLambda(result) && ((Parser.Symbol)result).thunk) {
            Object next = this.evaluate(((Parser.Symbol)result).body.procedure, ((Parser.Symbol)result).input, ((Parser.Symbol)result).environment);
            if (((Parser.Symbol)result).body.procedure.type == "variable" && next instanceof Parser.Symbol) {
                ((Parser.Symbol)next).token = ((Parser.Symbol)result).body.procedure.value;
            }
            if (next instanceof Parser.Symbol) {
                ((Parser.Symbol)next).position = ((Parser.Symbol)result).body.procedure.position;
            }
            ArrayList<Object> evaluatedArgs = new ArrayList<Object>();
            for (int ii = 0; ii < ((Parser.Symbol)result).body.arguments.size(); ++ii) {
                evaluatedArgs.add(this.evaluate(((Parser.Symbol)result).body.arguments.get(ii), ((Parser.Symbol)result).input, ((Parser.Symbol)result).environment));
            }
            result = this.applyInner(next, evaluatedArgs, input, environment);
        }
        return result;
    }

    Object applyInner(Object proc, Object args, Object input, Object environment) {
        ArrayList<String> result;
        block14: {
            result = null;
            Object validatedArgs = args;
            if (proc != null) {
                validatedArgs = this.validateArguments(proc, args, input);
            }
            if (Functions.isLambda(proc)) {
                result = this.applyProcedure(proc, validatedArgs);
                break block14;
            }
            if (proc instanceof JFunction) {
                if (!(validatedArgs instanceof List) || ((List)validatedArgs).size() != 1 || ((List)validatedArgs).get(0) == null) {
                    // empty if block
                }
                result = ((JFunction)proc).call(input, (List)validatedArgs);
                break block14;
            }
            if (proc instanceof JLambda) {
                List _args = (List)validatedArgs;
                if (proc instanceof Fn0) {
                    result = ((Fn0)proc).get();
                } else if (proc instanceof Fn1) {
                    result = ((Fn1)proc).apply(_args.size() <= 0 ? null : (Object)_args.get(0));
                } else if (proc instanceof Fn2) {
                    result = ((Fn2)proc).apply(_args.size() <= 0 ? null : (Object)_args.get(0), _args.size() <= 1 ? null : (Object)_args.get(1));
                }
                break block14;
            }
            if (proc instanceof Pattern) {
                ArrayList<String> _res = new ArrayList<String>();
                for (String s : (List)validatedArgs) {
                    if (!((Pattern)proc).matcher(s).find()) continue;
                    _res.add(s);
                }
                result = _res;
                break block14;
            }
            System.out.println("Proc not found " + String.valueOf(proc));
            throw new JException("T1006", 0);
        }
        return result;
    }

    Object evaluateLambda(Parser.Symbol expr, Object input, Frame environment) {
        Parser.Symbol procedure = new Parser.Symbol(this.parser);
        procedure._jsonata_lambda = true;
        procedure.input = input;
        procedure.environment = environment;
        procedure.arguments = expr.arguments;
        procedure.signature = expr.signature;
        procedure.body = expr.body;
        if (expr.thunk) {
            procedure.thunk = true;
        }
        return procedure;
    }

    Object evaluatePartialApplication(Parser.Symbol expr, Object input, Frame environment) {
        Object result = null;
        ArrayList<Parser.Symbol> evaluatedArgs = new ArrayList<Parser.Symbol>();
        for (int ii = 0; ii < expr.arguments.size(); ++ii) {
            Parser.Symbol arg = expr.arguments.get(ii);
            if (arg.type.equals("operator") && arg.value.equals("?")) {
                evaluatedArgs.add(arg);
                continue;
            }
            evaluatedArgs.add((Parser.Symbol)this.evaluate(arg, input, environment));
        }
        Object proc = this.evaluate(expr.procedure, input, environment);
        if (proc != null && expr.procedure.type.equals("path") && environment.lookup((String)expr.procedure.steps.get((int)0).value) != null) {
            throw new JException("T1007", expr.position, expr.procedure.steps.get((int)0).value);
        }
        if (Functions.isLambda(proc)) {
            result = this.partialApplyProcedure((Parser.Symbol)proc, evaluatedArgs);
        } else if (Utils.isFunction(proc)) {
            result = this.partialApplyNativeFunction((JFunction)proc, evaluatedArgs);
        } else {
            throw new JException("T1008", expr.position, expr.procedure.type.equals("path") ? expr.procedure.steps.get((int)0).value : expr.procedure.value);
        }
        return result;
    }

    Object validateArguments(Object signature, Object args, Object context) {
        Signature sig;
        Object validatedArgs = args;
        if (Utils.isFunction(signature)) {
            validatedArgs = ((JFunction)signature).validate(args, context);
        } else if (Functions.isLambda(signature) && (sig = (Signature)((Parser.Symbol)signature).signature) != null) {
            validatedArgs = sig.validate(args, context);
        }
        return validatedArgs;
    }

    Object applyProcedure(Object _proc, Object _args) {
        List args = (List)_args;
        Parser.Symbol proc = (Parser.Symbol)_proc;
        Object result = null;
        Frame env = this.createFrame(proc.environment);
        for (int i = 0; i < proc.arguments.size() && i < args.size(); ++i) {
            env.bind(String.valueOf(proc.arguments.get((int)i).value), args.get(i));
        }
        if (!(proc.body instanceof Parser.Symbol)) {
            throw new Error("Cannot execute procedure: " + String.valueOf(proc) + " " + String.valueOf(proc.body));
        }
        result = this.evaluate(proc.body, proc.input, env);
        return result;
    }

    Object partialApplyProcedure(Parser.Symbol proc, List<Parser.Symbol> args) {
        Frame env = this.createFrame(proc.environment != null ? proc.environment : this.environment);
        ArrayList<Parser.Symbol> unboundArgs = new ArrayList<Parser.Symbol>();
        int index = 0;
        for (Parser.Symbol param : proc.arguments) {
            Parser.Symbol arg;
            Parser.Symbol symbol = arg = index < args.size() ? args.get(index) : null;
            if (arg == null || arg instanceof Parser.Symbol && "operator".equals(arg.type) && "?".equals(arg.value)) {
                unboundArgs.add(param);
            } else {
                env.bind((String)param.value, arg);
            }
            ++index;
        }
        Parser.Symbol procedure = new Parser.Symbol(this.parser);
        procedure._jsonata_lambda = true;
        procedure.input = proc.input;
        procedure.environment = env;
        procedure.arguments = unboundArgs;
        procedure.body = proc.body;
        return procedure;
    }

    Object partialApplyNativeFunction(JFunction _native, List args) {
        ArrayList<CallSite> sigArgs = new ArrayList<CallSite>();
        ArrayList<CallSite> partArgs = new ArrayList<CallSite>();
        for (int i = 0; i < _native.getNumberOfArgs(); ++i) {
            String argName = "$" + (char)(97 + i);
            sigArgs.add((CallSite)((Object)argName));
            if (i >= args.size() || args.get(i) == null) {
                partArgs.add((CallSite)((Object)argName));
                continue;
            }
            partArgs.add((CallSite)args.get(i));
        }
        String body = "function(" + String.join((CharSequence)", ", sigArgs) + "){";
        body = body + "$" + _native.functionName + "(" + String.join((CharSequence)", ", sigArgs) + ") }";
        if (this.parser.dbg) {
            System.out.println("partial trampoline = " + body);
        }
        Parser.Symbol bodyAST = this.parser.parse(body);
        Object partial = this.partialApplyProcedure(bodyAST, args);
        return partial;
    }

    Object applyNativeFunction(JFunction proc, Frame env) {
        return null;
    }

    List getNativeFunctionArguments(JFunction func) {
        return null;
    }

    static JFunction defineFunction(String func, String signature) {
        return Jsonata.defineFunction(func, signature, func);
    }

    static JFunction defineFunction(String func, String signature, String funcImplMethod) {
        JFunction fn = new JFunction(func, signature, Functions.class, null, funcImplMethod);
        staticFrame.bind(func, fn);
        return fn;
    }

    public static JFunction function(String name, String signature, Class clazz, Object instance, String methodName) {
        return new JFunction(name, signature, clazz, instance, methodName);
    }

    public static <A, B, R> JFunction function(String name, FnVarArgs<R> func, String signature) {
        return new JFunction(func.getJFunctionCallable(), signature);
    }

    public static <A, R> JFunction function(String name, Fn0<R> func, String signature) {
        return new JFunction(func.getJFunctionCallable(), signature);
    }

    public static <A, B, R> JFunction function(String name, Fn1<A, R> func, String signature) {
        return new JFunction(func.getJFunctionCallable(), signature);
    }

    public static <A, B, R> JFunction function(String name, Fn2<A, B, R> func, String signature) {
        return new JFunction(func.getJFunctionCallable(), signature);
    }

    public static <A, B, C, R> JFunction function(String name, Fn3<A, B, C, R> func, String signature) {
        return new JFunction(func.getJFunctionCallable(), signature);
    }

    public static <A, B, C, D, R> JFunction function(String name, Fn4<A, B, C, D, R> func, String signature) {
        return new JFunction(func.getJFunctionCallable(), signature);
    }

    public static <A, B, C, D, E, R> JFunction function(String name, Fn5<A, B, C, D, E, R> func, String signature) {
        return new JFunction(func.getJFunctionCallable(), signature);
    }

    public static <A, B, C, D, E, F, R> JFunction function(String name, Fn6<A, B, C, D, E, F, R> func, String signature) {
        return new JFunction(func.getJFunctionCallable(), signature);
    }

    public static <A, B, C, D, E, F, G, R> JFunction function(String name, Fn7<A, B, C, D, E, F, G, R> func, String signature) {
        return new JFunction(func.getJFunctionCallable(), signature);
    }

    public static <A, B, C, D, E, F, G, H, R> JFunction function(String name, Fn8<A, B, C, D, E, F, G, H, R> func, String signature) {
        return new JFunction(func.getJFunctionCallable(), signature);
    }

    public Frame createFrame() {
        return this.createFrame(null);
    }

    public Frame createFrame(Frame enclosingEnvironment) {
        return new Frame(enclosingEnvironment);
    }

    static void registerFunctions() {
        Jsonata.defineFunction("sum", "<a<n>:n>");
        Jsonata.defineFunction("count", "<a:n>");
        Jsonata.defineFunction("max", "<a<n>:n>");
        Jsonata.defineFunction("min", "<a<n>:n>");
        Jsonata.defineFunction("average", "<a<n>:n>");
        Jsonata.defineFunction("string", "<x-b?:s>");
        Jsonata.defineFunction("substring", "<s-nn?:s>");
        Jsonata.defineFunction("substringBefore", "<s-s:s>");
        Jsonata.defineFunction("substringAfter", "<s-s:s>");
        Jsonata.defineFunction("lowercase", "<s-:s>");
        Jsonata.defineFunction("uppercase", "<s-:s>");
        Jsonata.defineFunction("length", "<s-:n>");
        Jsonata.defineFunction("trim", "<s-:s>");
        Jsonata.defineFunction("pad", "<s-ns?:s>");
        Jsonata.defineFunction("match", "<s-f<s:o>n?:a<o>>");
        Jsonata.defineFunction("contains", "<s-(sf):b>");
        Jsonata.defineFunction("replace", "<s-(sf)(sf)n?:s>");
        Jsonata.defineFunction("split", "<s-(sf)n?:a<s>>");
        Jsonata.defineFunction("join", "<a<s>s?:s>");
        Jsonata.defineFunction("formatNumber", "<n-so?:s>");
        Jsonata.defineFunction("formatBase", "<n-n?:s>");
        Jsonata.defineFunction("formatInteger", "<n-s:s>");
        Jsonata.defineFunction("parseInteger", "<s-s:n>");
        Jsonata.defineFunction("number", "<(nsb)-:n>");
        Jsonata.defineFunction("floor", "<n-:n>");
        Jsonata.defineFunction("ceil", "<n-:n>");
        Jsonata.defineFunction("round", "<n-n?:n>");
        Jsonata.defineFunction("abs", "<n-:n>");
        Jsonata.defineFunction("sqrt", "<n-:n>");
        Jsonata.defineFunction("power", "<n-n:n>");
        Jsonata.defineFunction("random", "<:n>");
        Jsonata.defineFunction("boolean", "<x-:b>", "toBoolean");
        Jsonata.defineFunction("not", "<x-:b>");
        Jsonata.defineFunction("map", "<af>");
        Jsonata.defineFunction("zip", "<a+>");
        Jsonata.defineFunction("filter", "<af>");
        Jsonata.defineFunction("single", "<af?>");
        Jsonata.defineFunction("reduce", "<afj?:j>", "foldLeft");
        Jsonata.defineFunction("sift", "<o-f?:o>");
        Jsonata.defineFunction("keys", "<x-:a<s>>");
        Jsonata.defineFunction("lookup", "<x-s:x>");
        Jsonata.defineFunction("append", "<xx:a>");
        Jsonata.defineFunction("exists", "<x:b>");
        Jsonata.defineFunction("spread", "<x-:a<o>>");
        Jsonata.defineFunction("merge", "<a<o>:o>");
        Jsonata.defineFunction("reverse", "<a:a>");
        Jsonata.defineFunction("each", "<o-f:a>");
        Jsonata.defineFunction("error", "<s?:x>");
        Jsonata.defineFunction("assert", "<bs?:x>", "assertFn");
        Jsonata.defineFunction("type", "<x:s>");
        Jsonata.defineFunction("sort", "<af?:a>");
        Jsonata.defineFunction("shuffle", "<a:a>");
        Jsonata.defineFunction("distinct", "<x:x>");
        Jsonata.defineFunction("base64encode", "<s-:s>");
        Jsonata.defineFunction("base64decode", "<s-:s>");
        Jsonata.defineFunction("encodeUrlComponent", "<s-:s>");
        Jsonata.defineFunction("encodeUrl", "<s-:s>");
        Jsonata.defineFunction("decodeUrlComponent", "<s-:s>");
        Jsonata.defineFunction("decodeUrl", "<s-:s>");
        Jsonata.defineFunction("eval", "<sx?:x>", "functionEval");
        Jsonata.defineFunction("toMillis", "<s-s?:n>", "dateTimeToMillis");
        Jsonata.defineFunction("fromMillis", "<n-s?s?:s>", "dateTimeFromMillis");
        Jsonata.defineFunction("clone", "<(oa)-:o>", "functionClone");
        Jsonata.defineFunction("now", "<s?s?:s>");
        Jsonata.defineFunction("millis", "<:n>");
    }

    Exception populateMessage(Exception err) {
        return err;
    }

    public static Jsonata jsonata(String expression) {
        return new Jsonata(expression);
    }

    Jsonata(String expr) {
        this.ast = this.parser.parse(expr);
        this.errors = this.ast.errors;
        this.ast.errors = null;
        this.environment = this.createFrame(staticFrame);
        this.timestamp = System.currentTimeMillis();
        current.set(this);
    }

    Jsonata(Jsonata other) {
        this.ast = other.ast;
        this.environment = other.environment;
        this.timestamp = other.timestamp;
    }

    public boolean isValidateInput() {
        return this.validateInput;
    }

    public void setValidateInput(boolean validateInput) {
        this.validateInput = validateInput;
    }

    public Object evaluate(Object input) {
        return this.evaluate(input, null);
    }

    public Object evaluate(Object input, Frame bindings) {
        Frame exec_env;
        if (this.errors != null) {
            throw new JException("S0500", 0);
        }
        if (bindings != null) {
            exec_env = this.createFrame(this.environment);
            for (String v : bindings.bindings.keySet()) {
                exec_env.bind(v, bindings.lookup(v));
            }
        } else {
            exec_env = this.environment;
        }
        exec_env.bind("$", input);
        this.timestamp = System.currentTimeMillis();
        if (input instanceof List && !Utils.isSequence(input)) {
            input = Utils.createSequence(input);
            ((Utils.JList)input).outerWrapper = true;
        }
        if (this.validateInput) {
            Functions.validateInput(input);
        }
        try {
            Object it = this.evaluate(this.ast, input, exec_env);
            it = Utils.convertNulls(it);
            return it;
        }
        catch (Exception err) {
            this.populateMessage(err);
            throw err;
        }
    }

    public void assign(String name, Object value) {
        this.environment.bind(name, value);
    }

    public void registerFunction(String name, JFunction implementation) {
        this.environment.bind(name, implementation);
    }

    public <R> void registerFunction(String name, Fn0<R> implementation) {
        this.environment.bind(name, implementation);
    }

    public <A, R> void registerFunction(String name, Fn1<A, R> implementation) {
        this.environment.bind(name, implementation);
    }

    public <A, B, R> void registerFunction(String name, Fn2<A, B, R> implementation) {
        this.environment.bind(name, implementation);
    }

    public List<Exception> getErrors() {
        return this.errors;
    }

    static final synchronized Parser getParser() {
        Parser p = _parser.get();
        if (p != null) {
            return p;
        }
        p = new Parser();
        _parser.set(p);
        return p;
    }

    static {
        NULL_VALUE = new Object(){

            public String toString() {
                return "null";
            }
        };
        current = new ThreadLocal();
        errorCodes = new HashMap<String, String>(){
            {
                this.put("S0101", "String literal must be terminated by a matching quote");
                this.put("S0102", "Number out of range: {{token}}");
                this.put("S0103", "Unsupported escape sequence: \\{{token}}");
                this.put("S0104", "The escape sequence \\u must be followed by 4 hex digits");
                this.put("S0105", "Quoted property name must be terminated with a backquote (`)");
                this.put("S0106", "Comment has no closing tag");
                this.put("S0201", "Syntax error: {{token}}");
                this.put("S0202", "Expected {{value}}, got {{token}}");
                this.put("S0203", "Expected {{value}} before end of expression");
                this.put("S0204", "Unknown operator: {{token}}");
                this.put("S0205", "Unexpected token: {{token}}");
                this.put("S0206", "Unknown expression type: {{token}}");
                this.put("S0207", "Unexpected end of expression");
                this.put("S0208", "Parameter {{value}} of Object definition must be a variable name (start with $)");
                this.put("S0209", "A predicate cannot follow a grouping expression in a step");
                this.put("S0210", "Each step can only have one grouping expression");
                this.put("S0211", "The symbol {{token}} cannot be used as a unary operator");
                this.put("S0212", "The left side of := must be a variable name (start with $)");
                this.put("S0213", "The literal value {{value}} cannot be used as a step within a path expression");
                this.put("S0214", "The right side of {{token}} must be a variable name (start with $)");
                this.put("S0215", "A context variable binding must precede any predicates on a step");
                this.put("S0216", "A context variable binding must precede the \"order-by\" clause on a step");
                this.put("S0217", "The object representing the \"parent\" cannot be derived from this expression");
                this.put("S0301", "Empty regular expressions are not allowed");
                this.put("S0302", "No terminating / in regular expression");
                this.put("S0402", "Choice groups containing parameterized types are not supported");
                this.put("S0401", "Type parameters can only be applied to functions and arrays");
                this.put("S0500", "Attempted to evaluate an expression containing syntax error(s)");
                this.put("T0410", "Argument {{index}} of Object {{token}} does not match Object signature");
                this.put("T0411", "Context value is not a compatible type with argument {{index}} of Object {{token}}");
                this.put("T0412", "Argument {{index}} of Object {{token}} must be an array of {{type}}");
                this.put("D1001", "Number out of range: {{value}}");
                this.put("D1002", "Cannot negate a non-numeric value: {{value}}");
                this.put("T1003", "Key in object structure must evaluate to a string; got: {{value}}");
                this.put("D1004", "Regular expression matches zero length string");
                this.put("T1005", "Attempted to invoke a non-function. Did you mean ${{{token}}}?");
                this.put("T1006", "Attempted to invoke a non-function");
                this.put("T1007", "Attempted to partially apply a non-function. Did you mean ${{{token}}}?");
                this.put("T1008", "Attempted to partially apply a non-function");
                this.put("D1009", "Multiple key definitions evaluate to same key: {{value}}");
                this.put("T1010", "The matcher Object argument passed to Object {{token}} does not return the correct object structure");
                this.put("T2001", "The left side of the {{token}} operator must evaluate to a number");
                this.put("T2002", "The right side of the {{token}} operator must evaluate to a number");
                this.put("T2003", "The left side of the range operator (..) must evaluate to an integer");
                this.put("T2004", "The right side of the range operator (..) must evaluate to an integer");
                this.put("D2005", "The left side of := must be a variable name (start with $)");
                this.put("T2006", "The right side of the Object application operator ~> must be a function");
                this.put("T2007", "Type mismatch when comparing values {{value}} and {{value2}} in order-by clause");
                this.put("T2008", "The expressions within an order-by clause must evaluate to numeric or string values");
                this.put("T2009", "The values {{value}} and {{value2}} either side of operator {{token}} must be of the same data type");
                this.put("T2010", "The expressions either side of operator {{token}} must evaluate to numeric or string values");
                this.put("T2011", "The insert/update clause of the transform expression must evaluate to an object: {{value}}");
                this.put("T2012", "The delete clause of the transform expression must evaluate to a string or array of strings: {{value}}");
                this.put("T2013", "The transform expression clones the input object using the $clone() function.  This has been overridden in the current scope by a non-function.");
                this.put("D2014", "The size of the sequence allocated by the range operator (..) must not exceed 1e6.  Attempted to allocate {{value}}.");
                this.put("D3001", "Attempting to invoke string Object on Infinity or NaN");
                this.put("D3010", "Second argument of replace Object cannot be an empty string");
                this.put("D3011", "Fourth argument of replace Object must evaluate to a positive number");
                this.put("D3012", "Attempted to replace a matched string with a non-string value");
                this.put("D3020", "Third argument of split Object must evaluate to a positive number");
                this.put("D3030", "Unable to cast value to a number: {{value}}");
                this.put("D3040", "Third argument of match Object must evaluate to a positive number");
                this.put("D3050", "The second argument of reduce Object must be a Object with at least two arguments");
                this.put("D3060", "The sqrt Object cannot be applied to a negative number: {{value}}");
                this.put("D3061", "The power Object has resulted in a value that cannot be represented as a JSON number: base={{value}}, exponent={{exp}}");
                this.put("D3070", "The single argument form of the sort Object can only be applied to an array of strings or an array of numbers.  Use the second argument to specify a comparison function");
                this.put("D3080", "The picture string must only contain a maximum of two sub-pictures");
                this.put("D3081", "The sub-picture must not contain more than one instance of the \"decimal-separator\" character");
                this.put("D3082", "The sub-picture must not contain more than one instance of the \"percent\" character");
                this.put("D3083", "The sub-picture must not contain more than one instance of the \"per-mille\" character");
                this.put("D3084", "The sub-picture must not contain both a \"percent\" and a \"per-mille\" character");
                this.put("D3085", "The mantissa part of a sub-picture must contain at least one character that is either an \"optional digit character\" or a member of the \"decimal digit family\"");
                this.put("D3086", "The sub-picture must not contain a passive character that is preceded by an active character and that is followed by another active character");
                this.put("D3087", "The sub-picture must not contain a \"grouping-separator\" character that appears adjacent to a \"decimal-separator\" character");
                this.put("D3088", "The sub-picture must not contain a \"grouping-separator\" at the end of the integer part");
                this.put("D3089", "The sub-picture must not contain two adjacent instances of the \"grouping-separator\" character");
                this.put("D3090", "The integer part of the sub-picture must not contain a member of the \"decimal digit family\" that is followed by an instance of the \"optional digit character\"");
                this.put("D3091", "The fractional part of the sub-picture must not contain an instance of the \"optional digit character\" that is followed by a member of the \"decimal digit family\"");
                this.put("D3092", "A sub-picture that contains a \"percent\" or \"per-mille\" character must not contain a character treated as an \"exponent-separator\"");
                this.put("D3093", "The exponent part of the sub-picture must comprise only of one or more characters that are members of the \"decimal digit family\"");
                this.put("D3100", "The radix of the formatBase Object must be between 2 and 36.  It was given {{value}}");
                this.put("D3110", "The argument of the toMillis Object must be an ISO 8601 formatted timestamp. Given {{value}}");
                this.put("D3120", "Syntax error in expression passed to Object eval: {{value}}");
                this.put("D3121", "Dynamic error evaluating the expression passed to Object eval: {{value}}");
                this.put("D3130", "Formatting or parsing an integer as a sequence starting with {{value}} is not supported by this implementation");
                this.put("D3131", "In a decimal digit pattern, all digits must be from the same decimal group");
                this.put("D3132", "Unknown component specifier {{value}} in date/time picture string");
                this.put("D3133", "The \"name\" modifier can only be applied to months and days in the date/time picture string, not {{value}}");
                this.put("D3134", "The timezone integer format specifier cannot have more than four digits");
                this.put("D3135", "No matching closing bracket \"]\" in date/time picture string");
                this.put("D3136", "The date/time picture string is missing specifiers required to parse the timestamp");
                this.put("D3137", "{{{message}}}");
                this.put("D3138", "The $single() Object expected exactly 1 matching result.  Instead it matched more.");
                this.put("D3139", "The $single() Object expected exactly 1 matching result.  Instead it matched 0.");
                this.put("D3140", "Malformed URL passed to ${{{functionName}}}(): {{value}}");
                this.put("D3141", "{{{message}}}");
            }
        };
        staticFrame = new Frame(null);
        Jsonata.registerFunctions();
        _parser = new ThreadLocal();
    }

    public static class Frame {
        final Map<String, Object> bindings = new LinkedHashMap<String, Object>();
        final Frame parent;
        public boolean isParallelCall;

        public Frame(Frame enclosingEnvironment) {
            this.parent = enclosingEnvironment;
        }

        public void bind(String name, Object val) {
            this.bindings.put(name, val);
        }

        public void bind(String name, JFunction function) {
            this.bind(name, (Object)function);
            if (function.signature != null) {
                function.signature.setFunctionName(name);
            }
        }

        public <R> void bind(String name, Fn0<R> lambda) {
            this.bind(name, (Object)lambda);
        }

        public <A, R> void bind(String name, Fn1<A, R> lambda) {
            this.bind(name, (Object)lambda);
        }

        public <A, B, R> void bind(String name, Fn2<A, B, R> lambda) {
            this.bind(name, (Object)lambda);
        }

        public Object lookup(String name) {
            if (this.bindings.containsKey(name)) {
                return this.bindings.get(name);
            }
            if (this.parent != null) {
                return this.parent.lookup(name);
            }
            return null;
        }

        public void setRuntimeBounds(long timeout, int maxRecursionDepth) {
            new Timebox(this, timeout, maxRecursionDepth);
        }

        public void setEvaluateEntryCallback(EntryCallback cb) {
            this.bind("__evaluate_entry", cb);
        }

        public void setEvaluateExitCallback(ExitCallback cb) {
            this.bind("__evaluate_exit", cb);
        }
    }

    public static interface EntryCallback {
        public void callback(Parser.Symbol var1, Object var2, Frame var3);
    }

    public static interface ExitCallback {
        public void callback(Parser.Symbol var1, Object var2, Frame var3, Object var4);
    }

    static class GroupEntry {
        Object data;
        int exprIndex;

        GroupEntry() {
        }
    }

    public static interface JFunctionCallable {
        public Object call(Object var1, List var2) throws Throwable;
    }

    public static class JFunction
    implements JFunctionCallable,
    JFunctionSignatureValidation {
        JFunctionCallable function;
        String functionName;
        Signature signature;
        Method method;
        Object methodInstance;

        public JFunction(JFunctionCallable function, String signature) {
            this.function = function;
            if (signature != null) {
                this.signature = new Signature(signature, function.getClass().getName());
            }
        }

        public JFunction(String functionName, String signature, Class clz, Object instance, String implMethodName) {
            this.functionName = functionName;
            this.signature = new Signature(signature, functionName);
            this.method = Functions.getFunction(clz, implMethodName);
            this.methodInstance = instance;
            if (this.method == null) {
                System.err.println("Function not implemented: " + functionName + " impl=" + implMethodName);
            }
        }

        @Override
        public Object call(Object input, List args) {
            try {
                if (this.function != null) {
                    return this.function.call(input, args);
                }
                return Functions.call(this.methodInstance, this.method, args);
            }
            catch (JException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getTargetException());
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object validate(Object args, Object context) {
            if (this.signature != null) {
                return this.signature.validate(args, context);
            }
            return args;
        }

        public int getNumberOfArgs() {
            return this.method != null ? this.method.getParameterTypes().length : 0;
        }
    }

    public static interface JLambda {
    }

    public static interface Fn0<R>
    extends JLambda,
    Supplier<R> {
        default public JFunctionCallable getJFunctionCallable() {
            return (input, args) -> this.get();
        }
    }

    public static interface Fn1<A, R>
    extends JLambda,
    Function<A, R> {
        default public JFunctionCallable getJFunctionCallable() {
            return (input, args) -> this.apply(args.get(0));
        }
    }

    public static interface Fn2<A, B, R>
    extends JLambda,
    BiFunction<A, B, R> {
        default public JFunctionCallable getJFunctionCallable() {
            return (input, args) -> this.apply(args.get(0), args.get(1));
        }
    }

    public static interface FnVarArgs<R>
    extends JLambda,
    Function<List<?>, R> {
        default public JFunctionCallable getJFunctionCallable() {
            return (input, args) -> this.apply(args);
        }
    }

    public static interface Fn3<A, B, C, R>
    extends JLambda {
        public R apply(A var1, B var2, C var3);

        default public JFunctionCallable getJFunctionCallable() {
            return (input, args) -> this.apply(args.get(0), args.get(1), args.get(2));
        }
    }

    public static interface Fn4<A, B, C, D, R>
    extends JLambda {
        public R apply(A var1, B var2, C var3, D var4);

        default public JFunctionCallable getJFunctionCallable() {
            return (input, args) -> this.apply(args.get(0), args.get(1), args.get(2), args.get(3));
        }
    }

    public static interface Fn5<A, B, C, D, E, R>
    extends JLambda {
        public R apply(A var1, B var2, C var3, D var4, E var5);

        default public JFunctionCallable getJFunctionCallable() {
            return (input, args) -> this.apply(args.get(0), args.get(1), args.get(2), args.get(3), args.get(4));
        }
    }

    public static interface Fn6<A, B, C, D, E, F, R>
    extends JLambda {
        public R apply(A var1, B var2, C var3, D var4, E var5, F var6);

        default public JFunctionCallable getJFunctionCallable() {
            return (input, args) -> this.apply(args.get(0), args.get(1), args.get(2), args.get(3), args.get(4), args.get(5));
        }
    }

    public static interface Fn7<A, B, C, D, E, F, G, R>
    extends JLambda {
        public R apply(A var1, B var2, C var3, D var4, E var5, F var6, G var7);

        default public JFunctionCallable getJFunctionCallable() {
            return (input, args) -> this.apply(args.get(0), args.get(1), args.get(2), args.get(3), args.get(4), args.get(5), args.get(6));
        }
    }

    public static interface Fn8<A, B, C, D, E, F, G, H, R>
    extends JLambda {
        public R apply(A var1, B var2, C var3, D var4, E var5, F var6, G var7, H var8);

        default public JFunctionCallable getJFunctionCallable() {
            return (input, args) -> this.apply(args.get(0), args.get(1), args.get(2), args.get(3), args.get(4), args.get(5), args.get(6), args.get(7));
        }
    }

    public static interface JFunctionSignatureValidation {
        public Object validate(Object var1, Object var2);
    }
}

