/*
 * Decompiled with CFR 0.152.
 */
package com.dashjoin.jsonata;

import com.dashjoin.jsonata.JException;
import com.dashjoin.jsonata.Jsonata;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class Utils {
    static Object NONE = new Object();

    public static boolean isNumeric(Object v) {
        if (v instanceof Long) {
            return true;
        }
        boolean isNum = false;
        if (v instanceof Number) {
            double d = ((Number)v).doubleValue();
            boolean bl = isNum = !Double.isNaN(d);
            if (isNum && !Double.isFinite(d)) {
                throw new JException("D1001", 0, v);
            }
        }
        return isNum;
    }

    public static boolean isArrayOfStrings(Object v) {
        boolean result = false;
        if (v instanceof Collection) {
            for (Object o : (Collection)v) {
                if (o instanceof String) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isArrayOfNumbers(Object v) {
        boolean result = false;
        if (v instanceof Collection) {
            for (Object o : (Collection)v) {
                if (Utils.isNumeric(o)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isFunction(Object o) {
        return o instanceof Jsonata.JFunction || o instanceof Jsonata.JFunctionCallable;
    }

    public static List<Object> createSequence() {
        return Utils.createSequence(NONE);
    }

    public static List<Object> createSequence(Object el) {
        JList<Object> sequence = new JList<Object>();
        sequence.sequence = true;
        if (el != NONE) {
            if (el instanceof List && ((List)el).size() == 1) {
                sequence.add(((List)el).get(0));
            } else {
                sequence.add(el);
            }
        }
        return sequence;
    }

    public static boolean isSequence(Object result) {
        return result instanceof JList && ((JList)result).sequence;
    }

    public static Number convertNumber(Number n) {
        if (!Utils.isNumeric(n)) {
            return null;
        }
        if ((double)n.longValue() == n.doubleValue()) {
            long l = n.longValue();
            if ((long)((int)l) == l) {
                return (int)l;
            }
            return l;
        }
        return n.doubleValue();
    }

    public static void checkUrl(String str) {
        boolean isHigh = false;
        for (int i = 0; i < str.length(); ++i) {
            boolean wasHigh = isHigh;
            isHigh = Character.isHighSurrogate(str.charAt(i));
            if (!wasHigh || !isHigh) continue;
            throw new JException("Malformed URL", i);
        }
        if (isHigh) {
            throw new JException("Malformed URL", 0);
        }
    }

    static Object convertValue(Object val) {
        return val != Jsonata.NULL_VALUE ? val : null;
    }

    static void convertNulls(Map<String, Object> res) {
        for (Map.Entry<String, Object> e : res.entrySet()) {
            Object val = e.getValue();
            Object l = Utils.convertValue(val);
            if (l != val) {
                e.setValue(l);
            }
            Utils.recurse(val);
        }
    }

    static void convertNulls(List<Object> res) {
        for (int i = 0; i < res.size(); ++i) {
            Object val = res.get(i);
            Object l = Utils.convertValue(val);
            if (l != val) {
                res.set(i, l);
            }
            Utils.recurse(val);
        }
    }

    static void recurse(Object val) {
        if (val instanceof Map) {
            Utils.convertNulls((Map)val);
        }
        if (val instanceof List) {
            Utils.convertNulls((List)val);
        }
    }

    public static Object convertNulls(Object res) {
        Utils.recurse(res);
        return Utils.convertValue(res);
    }

    public static void quote(String string, StringBuilder w) {
        char c = '\u0000';
        int len = string.length();
        block8: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    w.append('\\');
                    w.append(c);
                    continue block8;
                }
                case '\b': {
                    w.append("\\b");
                    continue block8;
                }
                case '\t': {
                    w.append("\\t");
                    continue block8;
                }
                case '\n': {
                    w.append("\\n");
                    continue block8;
                }
                case '\f': {
                    w.append("\\f");
                    continue block8;
                }
                case '\r': {
                    w.append("\\r");
                    continue block8;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        w.append("\\u");
                        String hhhh = Integer.toHexString(c);
                        w.append("0000", 0, 4 - hhhh.length());
                        w.append(hhhh);
                        continue block8;
                    }
                    w.append(c);
                }
            }
        }
    }

    public static class JList<E>
    extends ArrayList<E> {
        public boolean sequence;
        public boolean outerWrapper;
        public boolean tupleStream;
        public boolean keepSingleton;
        public boolean cons;

        public JList() {
        }

        public JList(int capacity) {
            super(capacity);
        }

        public JList(Collection<? extends E> c) {
            super(c);
        }
    }

    public static class RangeList
    extends AbstractList<Number> {
        final long a;
        final long b;
        final int size;

        public RangeList(long left, long right) {
            assert (left <= right);
            assert (right - left < Integer.MAX_VALUE);
            this.a = left;
            this.b = right;
            this.size = (int)(this.b - this.a + 1L);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean addAll(Collection<? extends Number> c) {
            throw new UnsupportedOperationException("RangeList does not support 'addAll'");
        }

        @Override
        public Number get(int index) {
            if (index < this.size) {
                try {
                    return Utils.convertNumber(this.a + (long)index);
                }
                catch (JException e) {
                    e.printStackTrace();
                }
            }
            throw new IndexOutOfBoundsException(index);
        }
    }
}

