/*
 * Decompiled with CFR 0.152.
 */
package akka.camel.internal;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Props$;
import akka.camel.Camel;
import akka.camel.CamelSettings;
import akka.camel.internal.ActivationProtocol;
import akka.camel.internal.AwaitActivation;
import akka.camel.internal.AwaitDeActivation;
import akka.camel.internal.CamelSupervisor;
import akka.camel.internal.component.ActorComponent;
import akka.camel.internal.component.DurationTypeConverter$;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.pattern.AskableActorRef$;
import akka.pattern.package$;
import akka.util.Timeout;
import org.apache.camel.Component;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.DefaultCamelContext;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da!B\u0001\u0003\u0001\u0011A!\u0001\u0004#fM\u0006,H\u000e^\"b[\u0016d'BA\u0002\u0005\u0003!Ig\u000e^3s]\u0006d'BA\u0003\u0007\u0003\u0015\u0019\u0017-\\3m\u0015\u00059\u0011\u0001B1lW\u0006\u001c2\u0001A\u0005\u0010!\tQQ\"D\u0001\f\u0015\u0005a\u0011!B:dC2\f\u0017B\u0001\b\f\u0005\u0019\te.\u001f*fMB\u0011\u0001#E\u0007\u0002\t%\u0011!\u0003\u0002\u0002\u0006\u0007\u0006lW\r\u001c\u0005\t)\u0001\u0011)\u0019!C\u0001-\u000511/_:uK6\u001c\u0001!F\u0001\u0018!\tA2$D\u0001\u001a\u0015\tQb!A\u0003bGR|'/\u0003\u0002\u001d3\t\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[\"Aa\u0004\u0001B\u0001B\u0003%q#A\u0004tsN$X-\u001c\u0011\t\u000b\u0001\u0002A\u0011A\u0011\u0002\rqJg.\u001b;?)\t\u0011C\u0005\u0005\u0002$\u00015\t!\u0001C\u0003\u0015?\u0001\u0007q\u0003C\u0004'\u0001\t\u0007I\u0011A\u0014\u0002\u0015M,\b/\u001a:wSN|'/F\u0001)!\tA\u0012&\u0003\u0002+3\tA\u0011i\u0019;peJ+g\r\u0003\u0004-\u0001\u0001\u0006I\u0001K\u0001\fgV\u0004XM\u001d<jg>\u0014\b\u0005\u0003\u0005/\u0001\t\u0007I1\u0001\u00030\u0003\rawnZ\u000b\u0002aA\u0011\u0011\u0007N\u0007\u0002e)\u00111GB\u0001\u0006KZ,g\u000e^\u0005\u0003kI\u0012a\u0002T8hO&tw-\u00113baR,'\u000f\u0003\u00048\u0001\u0001\u0006I\u0001M\u0001\u0005Y><\u0007\u0005\u0003\u0005:\u0001!\u0015\r\u0011\"\u0001;\u0003\u001d\u0019wN\u001c;fqR,\u0012a\u000f\t\u0003y\u0011k\u0011!\u0010\u0006\u0003}}\nA![7qY*\u0011Q\u0001\u0011\u0006\u0003\u0003\n\u000ba!\u00199bG\",'\"A\"\u0002\u0007=\u0014x-\u0003\u0002F{\t\u0019B)\u001a4bk2$8)Y7fY\u000e{g\u000e^3yi\"Aq\t\u0001E\u0001B\u0003&1(\u0001\u0005d_:$X\r\u001f;!\u0011\u001dI\u0005A1A\u0005\u0002)\u000b\u0001b]3ui&twm]\u000b\u0002\u0017B\u0011\u0001\u0003T\u0005\u0003\u001b\u0012\u0011QbQ1nK2\u001cV\r\u001e;j]\u001e\u001c\bBB(\u0001A\u0003%1*A\u0005tKR$\u0018N\\4tA!A\u0011\u000b\u0001EC\u0002\u0013\u0005!+\u0001\u0005uK6\u0004H.\u0019;f+\u0005\u0019\u0006C\u0001+V\u001b\u0005y\u0014B\u0001,@\u0005A\u0001&o\u001c3vG\u0016\u0014H+Z7qY\u0006$X\r\u0003\u0005Y\u0001!\u0005\t\u0015)\u0003T\u0003%!X-\u001c9mCR,\u0007\u0005C\u0003[\u0001\u0011\u00051,A\u0003ti\u0006\u0014H\u000fF\u0001]\u001b\u0005\u0001\u0001\"\u00020\u0001\t\u0003y\u0016\u0001C:ikR$wn\u001e8\u0015\u0003\u0001\u0004\"AC1\n\u0005\t\\!\u0001B+oSRDQ\u0001\u001a\u0001\u0005\u0002\u0015\f1#Y2uSZ\fG/[8o\rV$XO]3G_J$\"A\u001a>\u0015\u0007\u001dlW\u000fE\u0002iW\"j\u0011!\u001b\u0006\u0003U.\t!bY8oGV\u0014(/\u001a8u\u0013\ta\u0017N\u0001\u0004GkR,(/\u001a\u0005\u0006]\u000e\u0004\u001da\\\u0001\bi&lWm\\;u!\t\u00018/D\u0001r\u0015\t\u0011h!\u0001\u0003vi&d\u0017B\u0001;r\u0005\u001d!\u0016.\\3pkRDQA^2A\u0004]\f\u0001\"\u001a=fGV$xN\u001d\t\u0003QbL!!_5\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\b\"B>d\u0001\u0004A\u0013\u0001C3oIB|\u0017N\u001c;\t\u000bu\u0004A\u0011\u0001@\u0002+\u0011,\u0017m\u0019;jm\u0006$\u0018n\u001c8GkR,(/\u001a$peR\u0019q0!\u0002\u0015\u000b\u001d\f\t!a\u0001\t\u000b9d\b9A8\t\u000bYd\b9A<\t\u000bmd\b\u0019\u0001\u0015")
public class DefaultCamel
implements Camel {
    private final ExtendedActorSystem system;
    private final ActorRef supervisor;
    private final LoggingAdapter log;
    private DefaultCamelContext context;
    private final CamelSettings settings;
    private ProducerTemplate template;
    private volatile byte bitmap$0;

    /*
     * WARNING - void declaration
     */
    private DefaultCamelContext context$lzycompute() {
        DefaultCamel defaultCamel = this;
        synchronized (defaultCamel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                DefaultCamelContext ctx = this.settings().ContextProvider().getContext(this.system());
                if (!this.settings().JmxStatistics()) {
                    ctx.disableJMX();
                }
                ctx.setName(this.system().name());
                ctx.setStreamCaching(Predef$.MODULE$.boolean2Boolean(this.settings().StreamingCache()));
                ctx.addComponent("akka", (Component)new ActorComponent(this, (ActorSystem)this.system()));
                ctx.getTypeConverterRegistry().addTypeConverter(FiniteDuration.class, String.class, (TypeConverter)DurationTypeConverter$.MODULE$);
                this.context = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.context;
        }
    }

    private ProducerTemplate template$lzycompute() {
        DefaultCamel defaultCamel = this;
        synchronized (defaultCamel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.template = this.context().createProducerTemplate();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.template;
        }
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    @Override
    public ActorRef supervisor() {
        return this.supervisor;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    @Override
    public DefaultCamelContext context() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.context$lzycompute() : this.context;
    }

    @Override
    public CamelSettings settings() {
        return this.settings;
    }

    @Override
    public ProducerTemplate template() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.template$lzycompute() : this.template;
    }

    public DefaultCamel start() {
        this.context().start();
        try {
            this.template().start();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.context().stop();
            throw e;
        }
        this.log().debug("Started CamelContext[{}] for ActorSystem[{}]", (Object)this.context().getName(), (Object)this.system().name());
        return this;
    }

    public void shutdown() {
        try {
            this.context().stop();
        }
        finally {
            try {
                this.template().stop();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.log().debug("Swallowing non-fatal exception [{}] on stopping Camel producer template", (Object)e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        this.log().debug("Stopped CamelContext[{}] for ActorSystem[{}]", (Object)this.context().getName(), (Object)this.system().name());
    }

    @Override
    public Future<ActorRef> activationFutureFor(ActorRef endpoint, Timeout timeout, ExecutionContext executor) {
        return AskableActorRef$.MODULE$.ask$extension(package$.MODULE$.ask(this.supervisor()), (Object)new AwaitActivation(endpoint), timeout).map((Function1)new Serializable(this, endpoint){
            public static final long serialVersionUID = 0L;
            private final ActorRef endpoint$1;

            public final ActorRef apply(Object x0$1) {
                Object object = x0$1;
                if (object instanceof ActivationProtocol.EndpointActivated) {
                    ActivationProtocol.EndpointActivated endpointActivated = (ActivationProtocol.EndpointActivated)object;
                    ActorRef actorRef = endpointActivated.actorRef();
                    ActorRef actorRef2 = this.endpoint$1;
                    ActorRef actorRef3 = actorRef;
                    if (!(actorRef2 != null ? !actorRef2.equals(actorRef3) : actorRef3 != null)) {
                        ActorRef actorRef4 = this.endpoint$1;
                        return actorRef4;
                    }
                }
                if (object instanceof ActivationProtocol.EndpointFailedToActivate) {
                    ActivationProtocol.EndpointFailedToActivate endpointFailedToActivate = (ActivationProtocol.EndpointFailedToActivate)object;
                    ActorRef actorRef = endpointFailedToActivate.actorRef();
                    Throwable cause = endpointFailedToActivate.cause();
                    ActorRef actorRef5 = this.endpoint$1;
                    ActorRef actorRef6 = actorRef;
                    if (!(actorRef5 != null ? !actorRef5.equals(actorRef6) : actorRef6 != null)) {
                        throw cause;
                    }
                }
                throw new MatchError(object);
            }
            {
                this.endpoint$1 = endpoint$1;
            }
        }, executor);
    }

    @Override
    public Future<ActorRef> deactivationFutureFor(ActorRef endpoint, Timeout timeout, ExecutionContext executor) {
        return AskableActorRef$.MODULE$.ask$extension(package$.MODULE$.ask(this.supervisor()), (Object)new AwaitDeActivation(endpoint), timeout).map((Function1)new Serializable(this, endpoint){
            public static final long serialVersionUID = 0L;
            private final ActorRef endpoint$2;

            public final ActorRef apply(Object x0$2) {
                Object object = x0$2;
                if (object instanceof ActivationProtocol.EndpointDeActivated) {
                    ActivationProtocol.EndpointDeActivated endpointDeActivated = (ActivationProtocol.EndpointDeActivated)object;
                    ActorRef actorRef = endpointDeActivated.actorRef();
                    ActorRef actorRef2 = this.endpoint$2;
                    ActorRef actorRef3 = actorRef;
                    if (!(actorRef2 != null ? !actorRef2.equals(actorRef3) : actorRef3 != null)) {
                        ActorRef actorRef4 = this.endpoint$2;
                        return actorRef4;
                    }
                }
                if (object instanceof ActivationProtocol.EndpointFailedToDeActivate) {
                    ActivationProtocol.EndpointFailedToDeActivate endpointFailedToDeActivate = (ActivationProtocol.EndpointFailedToDeActivate)object;
                    ActorRef actorRef = endpointFailedToDeActivate.actorRef();
                    Throwable cause = endpointFailedToDeActivate.cause();
                    ActorRef actorRef5 = this.endpoint$2;
                    ActorRef actorRef6 = actorRef;
                    if (!(actorRef5 != null ? !actorRef5.equals(actorRef6) : actorRef6 != null)) {
                        throw cause;
                    }
                }
                throw new MatchError(object);
            }
            {
                this.endpoint$2 = endpoint$2;
            }
        }, executor);
    }

    public DefaultCamel(ExtendedActorSystem system) {
        this.system = system;
        this.supervisor = system.actorOf(Props$.MODULE$.apply(ClassTag$.MODULE$.apply(CamelSupervisor.class)), "camel-supervisor");
        this.log = Logging$.MODULE$.apply((ActorSystem)system, (Object)"Camel", LogSource$.MODULE$.fromString());
        this.settings = new CamelSettings(system.settings().config(), system.dynamicAccess());
    }
}

