/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.common.fork;

import java.util.Iterator;
import java.util.Set;
import org.apache.poi.common.fork.EmptyExecutionGraph;
import org.apache.poi.common.fork.IExecutionGraphBuilder;
import org.apache.poi.common.fork.IExecutionGraphVertex;
import org.apache.poi.ss.formula.ArrayEval;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.formula.TwoDEval;
import org.apache.poi.ss.formula.eval.BlankEval;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.RefEval;
import org.apache.poi.ss.formula.eval.RefEvalBase;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.StringValueEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.ptg.AbstractFunctionPtg;
import org.apache.poi.ss.formula.ptg.AddPtg;
import org.apache.poi.ss.formula.ptg.Area3DPtg;
import org.apache.poi.ss.formula.ptg.Area3DPxg;
import org.apache.poi.ss.formula.ptg.AreaPtg;
import org.apache.poi.ss.formula.ptg.ConcatPtg;
import org.apache.poi.ss.formula.ptg.DividePtg;
import org.apache.poi.ss.formula.ptg.EqualPtg;
import org.apache.poi.ss.formula.ptg.GreaterThanPtg;
import org.apache.poi.ss.formula.ptg.LessThanPtg;
import org.apache.poi.ss.formula.ptg.MultiplyPtg;
import org.apache.poi.ss.formula.ptg.NamePtg;
import org.apache.poi.ss.formula.ptg.NameXPxg;
import org.apache.poi.ss.formula.ptg.NotEqualPtg;
import org.apache.poi.ss.formula.ptg.OperationPtg;
import org.apache.poi.ss.formula.ptg.PercentPtg;
import org.apache.poi.ss.formula.ptg.PowerPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.ptg.Ref3DPtg;
import org.apache.poi.ss.formula.ptg.Ref3DPxg;
import org.apache.poi.ss.formula.ptg.RefPtg;
import org.apache.poi.ss.formula.ptg.ScalarConstantPtg;
import org.apache.poi.ss.formula.ptg.SubtractPtg;
import org.apache.poi.ss.formula.ptg.UnaryMinusPtg;
import org.apache.poi.ss.formula.ptg.UnaryPlusPtg;
import org.apache.poi.ss.formula.ptg.UnionPtg;
import org.apache.poi.ss.formula.ptg.ValueOperatorPtg;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;

public abstract class ExecutionGraphBuilderUtils {
    public static String fastDouble(Double d) {
        double val = d;
        StringBuilder sb = new StringBuilder();
        if (val < 0.0) {
            sb.append('-');
            val = -val;
        }
        long exp = 1000000000000000L;
        long lval = (long)(val * (double)exp + 0.5);
        sb.append(lval / exp).append('.');
        long fval = lval % exp;
        sb.append(ExecutionGraphBuilderUtils.removeZeros(Long.toString(fval)));
        return sb.toString();
    }

    public static String removeZeros(String str) {
        char zero = '0';
        char[] chars = str.toCharArray();
        int pos = chars.length;
        for (int i = chars.length - 1; i > 0 && chars[i] == zero; --i) {
            --pos;
        }
        return new String(chars, 0, pos);
    }

    public static void handleRefEval(ValueEval arg, ValueEval result) {
        ExecutionGraphBuilderUtils.handleRefEval(arg, (Object)result);
    }

    public static void handleRefEval(ValueEval arg, Object result) {
        if (arg instanceof RefEvalBase) {
            RefEvalBase iarg = (RefEvalBase)arg;
            IExecutionGraphBuilder _graphBuilder = iarg.getExecutionGraphBuilder() == null ? EmptyExecutionGraph.DoNothingExecutionGraphBuilder.get() : iarg.getExecutionGraphBuilder();
            IExecutionGraphVertex vertex = (IExecutionGraphVertex)ExecutionGraphBuilderUtils.getAny(_graphBuilder.getVerticesFromCache(iarg.getRow(), iarg.getColumn()));
            _graphBuilder.getVertexProperties(vertex).setValue(ExecutionGraphBuilderUtils.coerceValueTo(result));
        }
    }

    public static Object coerceValueTo(Object value) {
        try {
            if (value instanceof NumberEval) {
                return OperandResolver.coerceValueToDouble((NumberEval)value);
            }
            if (value instanceof StringValueEval) {
                return OperandResolver.coerceValueToString((StringValueEval)value);
            }
            if (value instanceof BoolEval) {
                return OperandResolver.coerceValueToBoolean((BoolEval)value, true);
            }
            if (value instanceof ErrorEval) {
                return ((ErrorEval)value).getErrorString();
            }
            if (value instanceof RefEval) {
                try {
                    RefEval rval = (RefEval)value;
                    return ExecutionGraphBuilderUtils.coerceValueTo(OperandResolver.getSingleValue(rval, rval.getRow(), rval.getColumn()));
                }
                catch (EvaluationException e) {
                    return e.getErrorEval().getErrorString();
                }
                catch (FormulaParseException e) {
                    return ErrorEval.REF_INVALID;
                }
            }
            if (value instanceof ArrayEval) {
                return ((ArrayEval)value).getArrayValues();
            }
            if (value instanceof BlankEval) {
                return "";
            }
        }
        catch (EvaluationException e) {
            throw new RuntimeException(e);
        }
        return value;
    }

    public static void populateCellValue(Cell cell, ValueEval value) {
        block8: {
            if (cell == null) {
                return;
            }
            try {
                if (value instanceof NumberEval) {
                    cell.setCellValue(OperandResolver.coerceValueToDouble(value));
                    break block8;
                }
                if (value instanceof StringValueEval) {
                    cell.setCellValue(OperandResolver.coerceValueToString(value));
                    break block8;
                }
                if (value instanceof BoolEval) {
                    cell.setCellValue(OperandResolver.coerceValueToBoolean(value, true));
                    break block8;
                }
                if (value instanceof ErrorEval) {
                    cell.setCellErrorValue((byte)((ErrorEval)value).getErrorCode());
                    break block8;
                }
                if (value instanceof BlankEval) {
                    cell.setCellValue("");
                    cell.setCellType(3);
                    break block8;
                }
                throw new IllegalArgumentException("ValueEval of type " + value.getClass().getName() + " is not supported by Cell");
            }
            catch (EvaluationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static ValueEval valueToValueEval(Object value) {
        if (value instanceof Double) {
            return new NumberEval((Double)value);
        }
        if (value instanceof Integer) {
            return new NumberEval(((Integer)value).intValue());
        }
        if (value instanceof Boolean) {
            return BoolEval.valueOf((Boolean)value);
        }
        if (value instanceof String) {
            return new StringEval((String)value);
        }
        return BlankEval.instance;
    }

    public static CellValue coerceValueEvalToCellValue(ValueEval eval) {
        if (eval instanceof NumberEval) {
            NumberEval ne = (NumberEval)eval;
            return new CellValue(ne.getNumberValue());
        }
        if (eval instanceof BoolEval) {
            BoolEval be = (BoolEval)eval;
            return CellValue.valueOf(be.getBooleanValue());
        }
        if (eval instanceof StringEval) {
            StringEval se = (StringEval)eval;
            return new CellValue(se.getStringValue());
        }
        if (eval instanceof ErrorEval) {
            return CellValue.getError(((ErrorEval)eval).getErrorCode());
        }
        if (eval instanceof BlankEval) {
            return new CellValue("");
        }
        if (eval instanceof TwoDEval) {
            ValueEval eval2 = ((TwoDEval)eval).getValue(0, 0);
            return ExecutionGraphBuilderUtils.coerceValueEvalToCellValue(eval2);
        }
        if (eval instanceof RefEval) {
            try {
                RefEval rval = (RefEval)eval;
                return ExecutionGraphBuilderUtils.coerceValueEvalToCellValue(OperandResolver.getSingleValue(rval, rval.getRow(), rval.getColumn()));
            }
            catch (EvaluationException e) {
                return ExecutionGraphBuilderUtils.coerceValueEvalToCellValue(e.getErrorEval());
            }
            catch (FormulaParseException e) {
                return ExecutionGraphBuilderUtils.coerceValueEvalToCellValue(ErrorEval.REF_INVALID);
            }
        }
        throw new RuntimeException("Unexpected eval class (" + eval.getClass().getName() + ")");
    }

    public static Object cellValueToObject(Cell cell) {
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case 0: {
                return cell.getNumericCellValue();
            }
            case 1: {
                return cell.getStringCellValue();
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
            case 5: {
                return cell.getErrorCellValue();
            }
            case 3: {
                return "";
            }
        }
        return "";
    }

    public static <T> T getAny(Set<T> set) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        Iterator<T> iterator = set.iterator();
        if (iterator.hasNext()) {
            T t = iterator.next();
            return t;
        }
        return null;
    }

    public static String removeSheetFromNameRef(String nameRef) {
        return nameRef.contains("!") ? nameRef.split("!")[1].replace("$", "") : nameRef.replace("$", "");
    }

    public static String createPoiNameRef(String nameRef, String sheetName) {
        return sheetName + "!" + nameRef;
    }

    public static IExecutionGraphVertex.Type ptgToVertexType(Ptg ptg) {
        if (ptg instanceof AbstractFunctionPtg) {
            return IExecutionGraphVertex.Type.FUNCTION;
        }
        if (ptg instanceof ValueOperatorPtg || ptg instanceof OperationPtg) {
            return IExecutionGraphVertex.Type.OPERATOR;
        }
        if (ptg instanceof RefPtg || ptg instanceof Ref3DPtg || ptg instanceof Ref3DPxg || ptg instanceof NameXPxg) {
            return IExecutionGraphVertex.Type.CELL_WITH_VALUE;
        }
        if (ptg instanceof ScalarConstantPtg || ptg instanceof NamePtg) {
            return IExecutionGraphVertex.Type.CONSTANT_VALUE;
        }
        if (ptg instanceof AreaPtg || ptg instanceof Area3DPtg || ptg instanceof Area3DPxg) {
            return IExecutionGraphVertex.Type.RANGE;
        }
        throw new RuntimeException("Unsupported Ptg class: " + ptg.getClass());
    }

    public static String ptgToString(Ptg ptg) {
        Class<OperationPtg> ptgCls = ptg.getClass();
        if (ptgCls.isAssignableFrom(AddPtg.class)) {
            return "+";
        }
        if (ptgCls.isAssignableFrom(SubtractPtg.class)) {
            return "-";
        }
        if (ptgCls.isAssignableFrom(DividePtg.class)) {
            return "/";
        }
        if (ptgCls.isAssignableFrom(MultiplyPtg.class)) {
            return "*";
        }
        if (ptgCls.isAssignableFrom(EqualPtg.class)) {
            return "=";
        }
        if (ptgCls.isAssignableFrom(GreaterThanPtg.class)) {
            return ">";
        }
        if (ptgCls.isAssignableFrom(LessThanPtg.class)) {
            return "<";
        }
        if (ptgCls.isAssignableFrom(NotEqualPtg.class)) {
            return "<>";
        }
        if (ptgCls.isAssignableFrom(UnaryPlusPtg.class)) {
            return "+";
        }
        if (ptgCls.isAssignableFrom(UnaryMinusPtg.class)) {
            return "-";
        }
        if (ptgCls.isAssignableFrom(ConcatPtg.class)) {
            return "&";
        }
        if (ptgCls.isAssignableFrom(PowerPtg.class)) {
            return "^";
        }
        if (ptgCls.isAssignableFrom(PercentPtg.class)) {
            return "%";
        }
        if (ptgCls.isAssignableFrom(UnionPtg.class)) {
            return ",";
        }
        try {
            return ptg.toFormulaString();
        }
        catch (Exception e) {
            return ptg.getClass().getSimpleName();
        }
    }
}

