/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.eventfilesystem;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderRegistry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.OPOIFSDocument;
import org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import org.apache.poi.poifs.property.DirectoryProperty;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.property.PropertyTable;
import org.apache.poi.poifs.storage.BlockAllocationTableReader;
import org.apache.poi.poifs.storage.BlockList;
import org.apache.poi.poifs.storage.HeaderBlock;
import org.apache.poi.poifs.storage.RawDataBlockList;
import org.apache.poi.poifs.storage.SmallBlockTableReader;

public class POIFSReader {
    private POIFSReaderRegistry registry = new POIFSReaderRegistry();
    private boolean registryClosed = false;

    public void read(InputStream stream) throws IOException {
        this.registryClosed = true;
        HeaderBlock header_block = new HeaderBlock(stream);
        RawDataBlockList data_blocks = new RawDataBlockList(stream, header_block.getBigBlockSize());
        new BlockAllocationTableReader(header_block.getBigBlockSize(), header_block.getBATCount(), header_block.getBATArray(), header_block.getXBATCount(), header_block.getXBATIndex(), data_blocks);
        PropertyTable properties = new PropertyTable(header_block, data_blocks);
        this.processProperties(SmallBlockTableReader.getSmallDocumentBlocks(header_block.getBigBlockSize(), data_blocks, properties.getRoot(), header_block.getSBATStart()), data_blocks, properties.getRoot().getChildren(), new POIFSDocumentPath());
    }

    public void registerListener(POIFSReaderListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.registryClosed) {
            throw new IllegalStateException();
        }
        this.registry.registerListener(listener);
    }

    public void registerListener(POIFSReaderListener listener, String name) {
        this.registerListener(listener, null, name);
    }

    public void registerListener(POIFSReaderListener listener, POIFSDocumentPath path, String name) {
        if (listener == null || name == null || name.length() == 0) {
            throw new NullPointerException();
        }
        if (this.registryClosed) {
            throw new IllegalStateException();
        }
        this.registry.registerListener(listener, path == null ? new POIFSDocumentPath() : path, name);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("at least one argument required: input filename(s)");
            System.exit(1);
        }
        for (int j = 0; j < args.length; ++j) {
            POIFSReader reader = new POIFSReader();
            SampleListener listener = new SampleListener();
            reader.registerListener(listener);
            System.out.println("reading " + args[j]);
            FileInputStream istream = new FileInputStream(args[j]);
            reader.read(istream);
            istream.close();
        }
    }

    private void processProperties(BlockList small_blocks, BlockList big_blocks, Iterator properties, POIFSDocumentPath path) throws IOException {
        while (properties.hasNext()) {
            Property property = (Property)properties.next();
            String name = property.getName();
            if (property.isDirectory()) {
                POIFSDocumentPath new_path = new POIFSDocumentPath(path, new String[]{name});
                this.processProperties(small_blocks, big_blocks, ((DirectoryProperty)property).getChildren(), new_path);
                continue;
            }
            int startBlock = property.getStartBlock();
            Iterator listeners = this.registry.getListeners(path, name);
            if (listeners.hasNext()) {
                int size = property.getSize();
                OPOIFSDocument document = null;
                document = property.shouldUseSmallBlocks() ? new OPOIFSDocument(name, small_blocks.fetchBlocks(startBlock, -1), size) : new OPOIFSDocument(name, big_blocks.fetchBlocks(startBlock, -1), size);
                while (listeners.hasNext()) {
                    POIFSReaderListener listener = (POIFSReaderListener)listeners.next();
                    listener.processPOIFSReaderEvent(new POIFSReaderEvent(new DocumentInputStream(document), path, name));
                }
                continue;
            }
            if (property.shouldUseSmallBlocks()) {
                small_blocks.fetchBlocks(startBlock, -1);
                continue;
            }
            big_blocks.fetchBlocks(startBlock, -1);
        }
    }

    private static class SampleListener
    implements POIFSReaderListener {
        SampleListener() {
        }

        @Override
        public void processPOIFSReaderEvent(POIFSReaderEvent event) {
            DocumentInputStream istream = event.getStream();
            POIFSDocumentPath path = event.getPath();
            String name = event.getName();
            try {
                byte[] data = new byte[istream.available()];
                istream.read(data);
                int pathLength = path.length();
                for (int k = 0; k < pathLength; ++k) {
                    System.out.print("/" + path.getComponent(k));
                }
                System.out.println("/" + name + ": " + data.length + " bytes read");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

