/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw;

import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.text.AttributedString;
import org.apache.poi.sl.draw.DrawBackground;
import org.apache.poi.sl.draw.DrawConnectorShape;
import org.apache.poi.sl.draw.DrawFreeformShape;
import org.apache.poi.sl.draw.DrawGroupShape;
import org.apache.poi.sl.draw.DrawMasterSheet;
import org.apache.poi.sl.draw.DrawNotImplemented;
import org.apache.poi.sl.draw.DrawNothing;
import org.apache.poi.sl.draw.DrawPaint;
import org.apache.poi.sl.draw.DrawPictureShape;
import org.apache.poi.sl.draw.DrawSheet;
import org.apache.poi.sl.draw.DrawSlide;
import org.apache.poi.sl.draw.DrawTableShape;
import org.apache.poi.sl.draw.DrawTextBox;
import org.apache.poi.sl.draw.DrawTextFragment;
import org.apache.poi.sl.draw.DrawTextParagraph;
import org.apache.poi.sl.draw.DrawTextShape;
import org.apache.poi.sl.draw.Drawable;
import org.apache.poi.sl.usermodel.Background;
import org.apache.poi.sl.usermodel.ConnectorShape;
import org.apache.poi.sl.usermodel.FreeformShape;
import org.apache.poi.sl.usermodel.GroupShape;
import org.apache.poi.sl.usermodel.MasterSheet;
import org.apache.poi.sl.usermodel.Notes;
import org.apache.poi.sl.usermodel.PictureShape;
import org.apache.poi.sl.usermodel.PlaceableShape;
import org.apache.poi.sl.usermodel.Shape;
import org.apache.poi.sl.usermodel.Sheet;
import org.apache.poi.sl.usermodel.Slide;
import org.apache.poi.sl.usermodel.SlideShow;
import org.apache.poi.sl.usermodel.TableShape;
import org.apache.poi.sl.usermodel.TextBox;
import org.apache.poi.sl.usermodel.TextParagraph;
import org.apache.poi.sl.usermodel.TextRun;
import org.apache.poi.sl.usermodel.TextShape;

public class DrawFactory {
    protected static ThreadLocal<DrawFactory> defaultFactory = new ThreadLocal();

    public static void setDefaultFactory(DrawFactory factory) {
        defaultFactory.set(factory);
    }

    public static DrawFactory getInstance(Graphics2D graphics) {
        DrawFactory factory = null;
        boolean isHint = false;
        if (graphics != null) {
            factory = (DrawFactory)graphics.getRenderingHint(Drawable.DRAW_FACTORY);
            boolean bl = isHint = factory != null;
        }
        if (factory == null) {
            factory = defaultFactory.get();
        }
        if (factory == null) {
            factory = new DrawFactory();
        }
        if (graphics != null && !isHint) {
            graphics.setRenderingHint(Drawable.DRAW_FACTORY, factory);
        }
        return factory;
    }

    public Drawable getDrawable(Shape shape) {
        if (shape instanceof TextBox) {
            return this.getDrawable((TextBox)shape);
        }
        if (shape instanceof FreeformShape) {
            return this.getDrawable((FreeformShape)shape);
        }
        if (shape instanceof TextShape) {
            return this.getDrawable((TextShape)shape);
        }
        if (shape instanceof GroupShape) {
            return this.getDrawable((GroupShape)shape);
        }
        if (shape instanceof PictureShape) {
            return this.getDrawable((PictureShape)shape);
        }
        if (shape instanceof Background) {
            return this.getDrawable((Background)shape);
        }
        if (shape instanceof ConnectorShape) {
            return this.getDrawable((ConnectorShape)shape);
        }
        if (shape instanceof TableShape) {
            return this.getDrawable((TableShape)shape);
        }
        if (shape instanceof Slide) {
            return this.getDrawable((Slide)((Object)shape));
        }
        if (shape instanceof MasterSheet) {
            return this.getDrawable((MasterSheet)((Object)shape));
        }
        if (shape instanceof Sheet) {
            return this.getDrawable((Sheet)((Object)shape));
        }
        if (shape.getClass().isAnnotationPresent(DrawNotImplemented.class)) {
            return new DrawNothing<Shape>(shape);
        }
        throw new IllegalArgumentException("Unsupported shape type: " + shape.getClass());
    }

    public <T extends Slide<? extends Shape, ? extends SlideShow, ? extends Notes<?, ?>>> DrawSlide<T> getDrawable(T sheet) {
        return new DrawSlide<T>(sheet);
    }

    public <T extends Sheet<? extends Shape, ? extends SlideShow>> DrawSheet<T> getDrawable(T sheet) {
        return new DrawSheet<T>(sheet);
    }

    public <T extends MasterSheet<? extends Shape, ? extends SlideShow>> DrawMasterSheet<T> getDrawable(T sheet) {
        return new DrawMasterSheet<T>(sheet);
    }

    public <T extends TextBox<? extends TextParagraph<?>>> DrawTextBox<T> getDrawable(T shape) {
        return new DrawTextBox<T>(shape);
    }

    public <T extends FreeformShape<? extends TextParagraph<? extends TextRun>>> DrawFreeformShape<T> getDrawable(T shape) {
        return new DrawFreeformShape<T>(shape);
    }

    public <T extends ConnectorShape> DrawConnectorShape<T> getDrawable(T shape) {
        return new DrawConnectorShape<T>(shape);
    }

    public <T extends TableShape> DrawTableShape<T> getDrawable(T shape) {
        return new DrawTableShape<T>(shape);
    }

    public <T extends TextShape<? extends TextParagraph<? extends TextRun>>> DrawTextShape<T> getDrawable(T shape) {
        return new DrawTextShape<T>(shape);
    }

    public <T extends GroupShape<? extends Shape>> DrawGroupShape<T> getDrawable(T shape) {
        return new DrawGroupShape<T>(shape);
    }

    public <T extends PictureShape> DrawPictureShape<T> getDrawable(T shape) {
        return new DrawPictureShape<T>(shape);
    }

    public <T extends TextRun> DrawTextParagraph<T> getDrawable(TextParagraph<T> paragraph) {
        return new DrawTextParagraph<T>(paragraph);
    }

    public <T extends Background> DrawBackground<T> getDrawable(T shape) {
        return new DrawBackground<T>(shape);
    }

    public DrawTextFragment getTextFragment(TextLayout layout, AttributedString str) {
        return new DrawTextFragment(layout, str);
    }

    public DrawPaint getPaint(PlaceableShape shape) {
        return new DrawPaint(shape);
    }
}

