/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.sl.draw.DrawShape;
import org.apache.poi.sl.draw.Drawable;
import org.apache.poi.sl.draw.ImageRenderer;
import org.apache.poi.sl.draw.PathGradientPaint;
import org.apache.poi.sl.usermodel.ColorStyle;
import org.apache.poi.sl.usermodel.PaintStyle;
import org.apache.poi.sl.usermodel.PlaceableShape;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class DrawPaint {
    private static final POILogger LOG = POILogFactory.getLogger(DrawPaint.class);
    protected PlaceableShape shape;

    public DrawPaint(PlaceableShape shape) {
        this.shape = shape;
    }

    public static PaintStyle.SolidPaint createSolidPaint(final Color color) {
        return new PaintStyle.SolidPaint(){

            @Override
            public ColorStyle getSolidColor() {
                return new ColorStyle(){

                    @Override
                    public Color getColor() {
                        return color;
                    }

                    @Override
                    public int getAlpha() {
                        return -1;
                    }

                    @Override
                    public int getLumOff() {
                        return -1;
                    }

                    @Override
                    public int getLumMod() {
                        return -1;
                    }

                    @Override
                    public int getShade() {
                        return -1;
                    }

                    @Override
                    public int getTint() {
                        return -1;
                    }
                };
            }
        };
    }

    public Paint getPaint(Graphics2D graphics, PaintStyle paint) {
        if (paint instanceof PaintStyle.SolidPaint) {
            return this.getSolidPaint((PaintStyle.SolidPaint)paint, graphics);
        }
        if (paint instanceof PaintStyle.GradientPaint) {
            return this.getGradientPaint((PaintStyle.GradientPaint)paint, graphics);
        }
        if (paint instanceof PaintStyle.TexturePaint) {
            return this.getTexturePaint((PaintStyle.TexturePaint)paint, graphics);
        }
        return null;
    }

    protected Paint getSolidPaint(PaintStyle.SolidPaint fill, Graphics2D graphics) {
        return DrawPaint.applyColorTransform(fill.getSolidColor());
    }

    protected Paint getGradientPaint(PaintStyle.GradientPaint fill, Graphics2D graphics) {
        switch (fill.getGradientType()) {
            case linear: {
                return this.createLinearGradientPaint(fill, graphics);
            }
            case circular: {
                return this.createRadialGradientPaint(fill, graphics);
            }
            case shape: {
                return this.createPathGradientPaint(fill, graphics);
            }
        }
        throw new UnsupportedOperationException("gradient fill of type " + fill + " not supported.");
    }

    protected Paint getTexturePaint(PaintStyle.TexturePaint fill, Graphics2D graphics) {
        InputStream is = fill.getImageData();
        if (is == null) {
            return PaintStyle.TRANSPARENT_PAINT.getSolidColor().getColor();
        }
        assert (graphics != null);
        ImageRenderer renderer = (ImageRenderer)graphics.getRenderingHint(Drawable.IMAGE_RENDERER);
        if (renderer == null) {
            renderer = new ImageRenderer();
        }
        try {
            renderer.loadImage(fill.getImageData(), fill.getContentType());
        }
        catch (IOException e) {
            LOG.log(7, new Object[]{"Can't load image data - using transparent color", e});
            return PaintStyle.TRANSPARENT_PAINT.getSolidColor().getColor();
        }
        int alpha = fill.getAlpha();
        if (alpha != -1) {
            renderer.setAlpha((float)alpha / 100000.0f);
        }
        Dimension dim = renderer.getDimension();
        Rectangle2D.Double textAnchor = new Rectangle2D.Double(0.0, 0.0, dim.getWidth(), dim.getHeight());
        TexturePaint paint = new TexturePaint(renderer.getImage(), textAnchor);
        return paint;
    }

    public static Color applyColorTransform(ColorStyle color) {
        Color result = color.getColor();
        if (result == null || color.getAlpha() == 100) {
            return PaintStyle.TRANSPARENT_PAINT.getSolidColor().getColor();
        }
        result = DrawPaint.applyAlpha(result, color);
        result = DrawPaint.applyLuminance(result, color);
        result = DrawPaint.applyShade(result, color);
        result = DrawPaint.applyTint(result, color);
        return result;
    }

    protected static Color applyAlpha(Color c, ColorStyle fc) {
        int alpha = c.getAlpha();
        return alpha == 255 ? c : new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    protected static Color applyLuminance(Color c, ColorStyle fc) {
        int lumOff;
        int lumMod = fc.getLumMod();
        if (lumMod == -1) {
            lumMod = 100000;
        }
        if ((lumOff = fc.getLumOff()) == -1) {
            lumOff = 0;
        }
        if (lumMod == 100000 && lumOff == 0) {
            return c;
        }
        double fLumOff = (double)lumOff / 100000.0;
        double fLumMod = (double)lumMod / 100000.0;
        double[] hsl = DrawPaint.RGB2HSL(c);
        hsl[2] = hsl[2] * fLumMod + fLumOff;
        Color c2 = DrawPaint.HSL2RGB(hsl[0], hsl[1], hsl[2], (double)c.getAlpha() / 255.0);
        return c2;
    }

    protected static Color applyShade(Color c, ColorStyle fc) {
        int shade = fc.getShade();
        if (shade == -1) {
            return c;
        }
        float fshade = (float)shade / 100000.0f;
        float red = (float)c.getRed() * fshade;
        float green = (float)c.getGreen() * fshade;
        float blue = (float)c.getGreen() * fshade;
        return new Color(Math.round(red), Math.round(green), Math.round(blue), c.getAlpha());
    }

    protected static Color applyTint(Color c, ColorStyle fc) {
        int tint = fc.getTint();
        if (tint == -1) {
            return c;
        }
        float ftint = (float)tint / 100000.0f;
        float red = ftint * (float)c.getRed() + (1.0f - ftint) * 255.0f;
        float green = ftint * (float)c.getGreen() + (1.0f - ftint) * 255.0f;
        float blue = ftint * (float)c.getBlue() + (1.0f - ftint) * 255.0f;
        return new Color(Math.round(red), Math.round(green), Math.round(blue), c.getAlpha());
    }

    protected Paint createLinearGradientPaint(PaintStyle.GradientPaint fill, Graphics2D graphics) {
        double rotation;
        double angle = fill.getGradientAngle();
        Rectangle2D anchor = DrawShape.getAnchor(graphics, this.shape);
        AffineTransform at = AffineTransform.getRotateInstance(Math.toRadians(angle), anchor.getX() + anchor.getWidth() / 2.0, anchor.getY() + anchor.getHeight() / 2.0);
        double diagonal = Math.sqrt(anchor.getHeight() * anchor.getHeight() + anchor.getWidth() * anchor.getWidth());
        Point2D p1 = new Point2D.Double(anchor.getX() + anchor.getWidth() / 2.0 - diagonal / 2.0, anchor.getY() + anchor.getHeight() / 2.0);
        p1 = at.transform(p1, null);
        Point2D p2 = new Point2D.Double(anchor.getX() + anchor.getWidth(), anchor.getY() + anchor.getHeight() / 2.0);
        p2 = at.transform(p2, null);
        this.snapToAnchor(p1, anchor);
        this.snapToAnchor(p2, anchor);
        float[] fractions = fill.getGradientFractions();
        Color[] colors = new Color[fractions.length];
        int i = 0;
        for (ColorStyle fc : fill.getGradientColors()) {
            colors[i++] = DrawPaint.applyColorTransform(fc);
        }
        AffineTransform grAt = new AffineTransform();
        if (fill.isRotatedWithShape() && (rotation = this.shape.getRotation()) != 0.0) {
            double centerX = anchor.getX() + anchor.getWidth() / 2.0;
            double centerY = anchor.getY() + anchor.getHeight() / 2.0;
            grAt.translate(centerX, centerY);
            grAt.rotate(Math.toRadians(-rotation));
            grAt.translate(-centerX, -centerY);
        }
        return new LinearGradientPaint(p1, p2, fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, grAt);
    }

    protected Paint createRadialGradientPaint(PaintStyle.GradientPaint fill, Graphics2D graphics) {
        Rectangle2D anchor = DrawShape.getAnchor(graphics, this.shape);
        Point2D.Double pCenter = new Point2D.Double(anchor.getX() + anchor.getWidth() / 2.0, anchor.getY() + anchor.getHeight() / 2.0);
        float radius = (float)Math.max(anchor.getWidth(), anchor.getHeight());
        float[] fractions = fill.getGradientFractions();
        Color[] colors = new Color[fractions.length];
        int i = 0;
        for (ColorStyle fc : fill.getGradientColors()) {
            colors[i++] = DrawPaint.applyColorTransform(fc);
        }
        return new RadialGradientPaint(pCenter, radius, fractions, colors);
    }

    protected Paint createPathGradientPaint(PaintStyle.GradientPaint fill, Graphics2D graphics) {
        float[] fractions = fill.getGradientFractions();
        Color[] colors = new Color[fractions.length];
        int i = 0;
        for (ColorStyle fc : fill.getGradientColors()) {
            colors[i++] = DrawPaint.applyColorTransform(fc);
        }
        return new PathGradientPaint(colors, fractions);
    }

    protected void snapToAnchor(Point2D p, Rectangle2D anchor) {
        if (p.getX() < anchor.getX()) {
            p.setLocation(anchor.getX(), p.getY());
        } else if (p.getX() > anchor.getX() + anchor.getWidth()) {
            p.setLocation(anchor.getX() + anchor.getWidth(), p.getY());
        }
        if (p.getY() < anchor.getY()) {
            p.setLocation(p.getX(), anchor.getY());
        } else if (p.getY() > anchor.getY() + anchor.getHeight()) {
            p.setLocation(p.getX(), anchor.getY() + anchor.getHeight());
        }
    }

    private static Color HSL2RGB(double h, double s, double l, double alpha) {
        if (s < 0.0 || s > 100.0) {
            String message = "Color parameter outside of expected range - Saturation";
            throw new IllegalArgumentException(message);
        }
        if (l < 0.0 || l > 100.0) {
            String message = "Color parameter outside of expected range - Luminance";
            throw new IllegalArgumentException(message);
        }
        if (alpha < 0.0 || alpha > 1.0) {
            String message = "Color parameter outside of expected range - Alpha";
            throw new IllegalArgumentException(message);
        }
        h %= 360.0;
        double q = (l /= 100.0) < 0.5 ? l * (1.0 + s) : l + (s /= 100.0) - s * l;
        double p = 2.0 * l - q;
        double r = Math.max(0.0, DrawPaint.HUE2RGB(p, q, (h /= 360.0) + 0.3333333333333333));
        double g = Math.max(0.0, DrawPaint.HUE2RGB(p, q, h));
        double b = Math.max(0.0, DrawPaint.HUE2RGB(p, q, h - 0.3333333333333333));
        r = Math.min(r, 1.0);
        g = Math.min(g, 1.0);
        b = Math.min(b, 1.0);
        return new Color((float)r, (float)g, (float)b, (float)alpha);
    }

    private static double HUE2RGB(double p, double q, double h) {
        if (h < 0.0) {
            h += 1.0;
        }
        if (h > 1.0) {
            h -= 1.0;
        }
        if (6.0 * h < 1.0) {
            return p + (q - p) * 6.0 * h;
        }
        if (2.0 * h < 1.0) {
            return q;
        }
        if (3.0 * h < 2.0) {
            return p + (q - p) * 6.0 * (0.6666666666666666 - h);
        }
        return p;
    }

    private static double[] RGB2HSL(Color color) {
        float[] rgb = color.getRGBColorComponents(null);
        double r = rgb[0];
        double g = rgb[1];
        double b = rgb[2];
        double min = Math.min(r, Math.min(g, b));
        double max = Math.max(r, Math.max(g, b));
        double h = 0.0;
        if (max == min) {
            h = 0.0;
        } else if (max == r) {
            h = (60.0 * (g - b) / (max - min) + 360.0) % 360.0;
        } else if (max == g) {
            h = 60.0 * (b - r) / (max - min) + 120.0;
        } else if (max == b) {
            h = 60.0 * (r - g) / (max - min) + 240.0;
        }
        double l = (max + min) / 2.0;
        double s = 0.0;
        s = max == min ? 0.0 : (l <= 0.5 ? (max - min) / (max + min) : (max - min) / (2.0 - max - min));
        return new double[]{h, s * 100.0, l * 100.0};
    }
}

