/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.poi.sl.draw.DrawSimpleShape;
import org.apache.poi.sl.draw.Drawable;
import org.apache.poi.sl.draw.ImageRenderer;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.sl.usermodel.PictureShape;
import org.apache.poi.sl.usermodel.PlaceableShape;

public class DrawPictureShape<T extends PictureShape>
extends DrawSimpleShape<T> {
    public DrawPictureShape(T shape) {
        super(shape);
    }

    @Override
    public void drawContent(Graphics2D graphics) {
        PictureData data = ((PictureShape)this.shape).getPictureData();
        if (data == null) {
            return;
        }
        ImageRenderer renderer = (ImageRenderer)graphics.getRenderingHint(Drawable.IMAGE_RENDERER);
        if (renderer == null) {
            renderer = new ImageRenderer();
        }
        Rectangle2D anchor = DrawPictureShape.getAnchor(graphics, (PlaceableShape)((Object)this.shape));
        Insets insets = ((PictureShape)this.shape).getClipping();
        try {
            renderer.loadImage(data.getData(), data.getContentType());
            renderer.drawImage(graphics, anchor, insets);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

