/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.poi.sl.draw.DrawFactory;
import org.apache.poi.sl.draw.DrawPaint;
import org.apache.poi.sl.draw.DrawShape;
import org.apache.poi.sl.draw.Drawable;
import org.apache.poi.sl.draw.binding.CTCustomGeometry2D;
import org.apache.poi.sl.draw.geom.Context;
import org.apache.poi.sl.draw.geom.CustomGeometry;
import org.apache.poi.sl.draw.geom.IAdjustableShape;
import org.apache.poi.sl.draw.geom.Outline;
import org.apache.poi.sl.draw.geom.Path;
import org.apache.poi.sl.usermodel.LineDecoration;
import org.apache.poi.sl.usermodel.PaintStyle;
import org.apache.poi.sl.usermodel.PlaceableShape;
import org.apache.poi.sl.usermodel.Shadow;
import org.apache.poi.sl.usermodel.SimpleShape;
import org.apache.poi.sl.usermodel.StrokeStyle;

public class DrawSimpleShape<T extends SimpleShape>
extends DrawShape<T> {
    public DrawSimpleShape(T shape) {
        super(shape);
    }

    @Override
    public void draw(Graphics2D graphics) {
        Shape s;
        DrawPaint drawPaint = DrawFactory.getInstance(graphics).getPaint((PlaceableShape)((Object)this.shape));
        Paint fill = drawPaint.getPaint(graphics, ((SimpleShape)this.shape).getFillStyle().getPaint());
        Paint line = drawPaint.getPaint(graphics, ((SimpleShape)this.shape).getStrokeStyle().getPaint());
        BasicStroke stroke = this.getStroke();
        graphics.setStroke(stroke);
        Collection<Outline> elems = this.computeOutlines(graphics);
        this.drawShadow(graphics, elems, fill, line);
        if (fill != null) {
            graphics.setPaint(fill);
            for (Outline o : elems) {
                if (!o.getPath().isFilled()) continue;
                s = o.getOutline();
                graphics.setRenderingHint(Drawable.GRADIENT_SHAPE, s);
                graphics.fill(s);
            }
        }
        this.drawContent(graphics);
        if (line != null) {
            graphics.setPaint(line);
            for (Outline o : elems) {
                if (!o.getPath().isStroked()) continue;
                s = o.getOutline();
                graphics.setRenderingHint(Drawable.GRADIENT_SHAPE, s);
                graphics.draw(s);
            }
        }
        this.drawDecoration(graphics, line, stroke);
    }

    protected void drawDecoration(Graphics2D graphics, Paint line, BasicStroke stroke) {
        Outline tail;
        if (line == null) {
            return;
        }
        graphics.setPaint(line);
        ArrayList<Outline> lst = new ArrayList<Outline>();
        LineDecoration deco = ((SimpleShape)this.shape).getLineDecoration();
        Outline head = this.getHeadDecoration(graphics, deco, stroke);
        if (head != null) {
            lst.add(head);
        }
        if ((tail = this.getTailDecoration(graphics, deco, stroke)) != null) {
            lst.add(tail);
        }
        for (Outline o : lst) {
            Shape s = o.getOutline();
            Path p = o.getPath();
            graphics.setRenderingHint(Drawable.GRADIENT_SHAPE, s);
            if (p.isFilled()) {
                graphics.fill(s);
            }
            if (!p.isStroked()) continue;
            graphics.draw(s);
        }
    }

    protected Outline getTailDecoration(Graphics2D graphics, LineDecoration deco, BasicStroke stroke) {
        LineDecoration.DecorationSize tailLength = deco.getTailLength();
        LineDecoration.DecorationSize tailWidth = deco.getTailWidth();
        double lineWidth = Math.max(2.5, (double)stroke.getLineWidth());
        Rectangle2D anchor = DrawSimpleShape.getAnchor(graphics, (PlaceableShape)((Object)this.shape));
        double x2 = anchor.getX() + anchor.getWidth();
        double y2 = anchor.getY() + anchor.getHeight();
        double alpha = Math.atan(anchor.getHeight() / anchor.getWidth());
        AffineTransform at = new AffineTransform();
        Shape shape = null;
        Path p = null;
        double scaleY = Math.pow(2.0, tailWidth.ordinal() + 1);
        double scaleX = Math.pow(2.0, tailLength.ordinal() + 1);
        switch (deco.getTailShape()) {
            case OVAL: {
                p = new Path();
                shape = new Ellipse2D.Double(0.0, 0.0, lineWidth * scaleX, lineWidth * scaleY);
                Rectangle2D bounds = shape.getBounds2D();
                at.translate(x2 - bounds.getWidth() / 2.0, y2 - bounds.getHeight() / 2.0);
                at.rotate(alpha, bounds.getX() + bounds.getWidth() / 2.0, bounds.getY() + bounds.getHeight() / 2.0);
                break;
            }
            case STEALTH: 
            case ARROW: {
                p = new Path(false, true);
                GeneralPath arrow = new GeneralPath();
                arrow.moveTo((float)(-lineWidth * scaleX), (float)(-lineWidth * scaleY / 2.0));
                arrow.lineTo(0.0f, 0.0f);
                arrow.lineTo((float)(-lineWidth * scaleX), (float)(lineWidth * scaleY / 2.0));
                shape = arrow;
                at.translate(x2, y2);
                at.rotate(alpha);
                break;
            }
            case TRIANGLE: {
                p = new Path();
                GeneralPath triangle = new GeneralPath();
                triangle.moveTo((float)(-lineWidth * scaleX), (float)(-lineWidth * scaleY / 2.0));
                triangle.lineTo(0.0f, 0.0f);
                triangle.lineTo((float)(-lineWidth * scaleX), (float)(lineWidth * scaleY / 2.0));
                triangle.closePath();
                shape = triangle;
                at.translate(x2, y2);
                at.rotate(alpha);
                break;
            }
        }
        if (shape != null) {
            shape = at.createTransformedShape(shape);
        }
        return shape == null ? null : new Outline(shape, p);
    }

    protected Outline getHeadDecoration(Graphics2D graphics, LineDecoration deco, BasicStroke stroke) {
        LineDecoration.DecorationSize headLength = deco.getHeadLength();
        LineDecoration.DecorationSize headWidth = deco.getHeadWidth();
        double lineWidth = Math.max(2.5, (double)stroke.getLineWidth());
        Rectangle2D anchor = DrawSimpleShape.getAnchor(graphics, (PlaceableShape)((Object)this.shape));
        double x1 = anchor.getX();
        double y1 = anchor.getY();
        double alpha = Math.atan(anchor.getHeight() / anchor.getWidth());
        AffineTransform at = new AffineTransform();
        Shape shape = null;
        Path p = null;
        double scaleY = Math.pow(2.0, headWidth.ordinal() + 1);
        double scaleX = Math.pow(2.0, headLength.ordinal() + 1);
        switch (deco.getHeadShape()) {
            case OVAL: {
                p = new Path();
                shape = new Ellipse2D.Double(0.0, 0.0, lineWidth * scaleX, lineWidth * scaleY);
                Rectangle2D bounds = shape.getBounds2D();
                at.translate(x1 - bounds.getWidth() / 2.0, y1 - bounds.getHeight() / 2.0);
                at.rotate(alpha, bounds.getX() + bounds.getWidth() / 2.0, bounds.getY() + bounds.getHeight() / 2.0);
                break;
            }
            case STEALTH: 
            case ARROW: {
                p = new Path(false, true);
                GeneralPath arrow = new GeneralPath();
                arrow.moveTo((float)(lineWidth * scaleX), (float)(-lineWidth * scaleY / 2.0));
                arrow.lineTo(0.0f, 0.0f);
                arrow.lineTo((float)(lineWidth * scaleX), (float)(lineWidth * scaleY / 2.0));
                shape = arrow;
                at.translate(x1, y1);
                at.rotate(alpha);
                break;
            }
            case TRIANGLE: {
                p = new Path();
                GeneralPath triangle = new GeneralPath();
                triangle.moveTo((float)(lineWidth * scaleX), (float)(-lineWidth * scaleY / 2.0));
                triangle.lineTo(0.0f, 0.0f);
                triangle.lineTo((float)(lineWidth * scaleX), (float)(lineWidth * scaleY / 2.0));
                triangle.closePath();
                shape = triangle;
                at.translate(x1, y1);
                at.rotate(alpha);
                break;
            }
        }
        if (shape != null) {
            shape = at.createTransformedShape(shape);
        }
        return shape == null ? null : new Outline(shape, p);
    }

    public BasicStroke getStroke() {
        int lineCap;
        StrokeStyle.LineCap lineCapE;
        StrokeStyle.LineDash lineDash;
        StrokeStyle strokeStyle = ((SimpleShape)this.shape).getStrokeStyle();
        float lineWidth = (float)strokeStyle.getLineWidth();
        if (lineWidth == 0.0f) {
            lineWidth = 0.25f;
        }
        if ((lineDash = strokeStyle.getLineDash()) == null) {
            lineDash = StrokeStyle.LineDash.SOLID;
        }
        int[] dashPatI = lineDash.pattern;
        float dash_phase = 0.0f;
        float[] dashPatF = null;
        if (dashPatI != null) {
            dashPatF = new float[dashPatI.length];
            for (int i = 0; i < dashPatI.length; ++i) {
                dashPatF[i] = (float)dashPatI[i] * Math.max(1.0f, lineWidth);
            }
        }
        if ((lineCapE = strokeStyle.getLineCap()) == null) {
            lineCapE = StrokeStyle.LineCap.FLAT;
        }
        switch (lineCapE) {
            case ROUND: {
                lineCap = 1;
                break;
            }
            case SQUARE: {
                lineCap = 2;
                break;
            }
            default: {
                lineCap = 0;
            }
        }
        int lineJoin = 1;
        return new BasicStroke(lineWidth, lineCap, lineJoin, lineWidth, dashPatF, 0.0f);
    }

    protected void drawShadow(Graphics2D graphics, Collection<Outline> outlines, Paint fill, Paint line) {
        Shadow shadow = ((SimpleShape)this.shape).getShadow();
        if (shadow == null || fill == null && line == null) {
            return;
        }
        PaintStyle.SolidPaint shadowPaint = shadow.getFillStyle();
        Color shadowColor = DrawPaint.applyColorTransform(shadowPaint.getSolidColor());
        double shapeRotation = ((SimpleShape)this.shape).getRotation();
        if (((SimpleShape)this.shape).getFlipVertical()) {
            shapeRotation += 180.0;
        }
        double angle = shadow.getAngle() - shapeRotation;
        double dist = shadow.getDistance();
        double dx = dist * Math.cos(Math.toRadians(angle));
        double dy = dist * Math.sin(Math.toRadians(angle));
        graphics.translate(dx, dy);
        for (Outline o : outlines) {
            Shape s = o.getOutline();
            Path p = o.getPath();
            graphics.setRenderingHint(Drawable.GRADIENT_SHAPE, s);
            graphics.setPaint(shadowColor);
            if (fill != null && p.isFilled()) {
                graphics.fill(s);
                continue;
            }
            if (line == null || !p.isStroked()) continue;
            graphics.draw(s);
        }
        graphics.translate(-dx, -dy);
    }

    protected static CustomGeometry getCustomGeometry(String name) {
        return DrawSimpleShape.getCustomGeometry(name, null);
    }

    protected static CustomGeometry getCustomGeometry(String name, Graphics2D graphics) {
        HashMap<String, CustomGeometry> presets;
        HashMap<String, CustomGeometry> hashMap = presets = graphics == null ? null : (HashMap<String, CustomGeometry>)graphics.getRenderingHint(Drawable.PRESET_GEOMETRY_CACHE);
        if (presets == null) {
            presets = new HashMap<String, CustomGeometry>();
            if (graphics != null) {
                graphics.setRenderingHint(Drawable.PRESET_GEOMETRY_CACHE, presets);
            }
            String packageName = "org.apache.poi.sl.draw.binding";
            InputStream presetIS = Drawable.class.getResourceAsStream("presetShapeDefinitions.xml");
            InputStreamReader xml = new InputStreamReader(presetIS, Charset.forName("UTF-8"));
            EventFilter startElementFilter = new EventFilter(){

                @Override
                public boolean accept(XMLEvent event) {
                    return event.isStartElement();
                }
            };
            try {
                XMLInputFactory staxFactory = XMLInputFactory.newInstance();
                XMLEventReader staxReader = staxFactory.createXMLEventReader(xml);
                XMLEventReader staxFiltRd = staxFactory.createFilteredReader(staxReader, startElementFilter);
                staxFiltRd.nextEvent();
                JAXBContext jaxbContext = JAXBContext.newInstance((String)packageName);
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                while (staxFiltRd.peek() != null) {
                    StartElement evRoot = (StartElement)staxFiltRd.peek();
                    String cusName = evRoot.getName().getLocalPart();
                    JAXBElement el = unmarshaller.unmarshal(staxReader, CTCustomGeometry2D.class);
                    CTCustomGeometry2D cusGeom = (CTCustomGeometry2D)el.getValue();
                    presets.put(cusName, new CustomGeometry(cusGeom));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load preset geometries.", e);
            }
        }
        return (CustomGeometry)presets.get(name);
    }

    protected Collection<Outline> computeOutlines(Graphics2D graphics) {
        ArrayList<Outline> lst = new ArrayList<Outline>();
        CustomGeometry geom = ((SimpleShape)this.shape).getGeometry();
        if (geom == null) {
            return lst;
        }
        Rectangle2D anchor = DrawSimpleShape.getAnchor(graphics, (PlaceableShape)((Object)this.shape));
        for (Path p : geom) {
            double w = p.getW() == -1L ? anchor.getWidth() * 12700.0 : (double)p.getW();
            double h = p.getH() == -1L ? anchor.getHeight() * 12700.0 : (double)p.getH();
            Rectangle2D.Double pathAnchor = new Rectangle2D.Double(0.0, 0.0, w, h);
            Context ctx = new Context(geom, pathAnchor, (IAdjustableShape)((Object)this.shape));
            GeneralPath gp = p.getPath(ctx);
            AffineTransform at = new AffineTransform();
            at.translate(anchor.getX(), anchor.getY());
            double scaleX = p.getW() != -1L ? anchor.getWidth() / (double)p.getW() : 7.874015748031496E-5;
            double scaleY = p.getH() != -1L ? anchor.getHeight() / (double)p.getH() : 7.874015748031496E-5;
            at.scale(scaleX, scaleY);
            Shape canvasShape = at.createTransformedShape(gp);
            lst.add(new Outline(canvasShape, p));
        }
        return lst;
    }
}

