/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.sl.draw.DrawFactory;
import org.apache.poi.sl.draw.DrawFontManager;
import org.apache.poi.sl.draw.DrawShape;
import org.apache.poi.sl.draw.DrawTextFragment;
import org.apache.poi.sl.draw.Drawable;
import org.apache.poi.sl.usermodel.AutoNumberingScheme;
import org.apache.poi.sl.usermodel.Insets2D;
import org.apache.poi.sl.usermodel.TextParagraph;
import org.apache.poi.sl.usermodel.TextRun;
import org.apache.poi.sl.usermodel.TextShape;
import org.apache.poi.util.Units;

public class DrawTextParagraph<T extends TextRun>
implements Drawable {
    protected TextParagraph<T> paragraph;
    double x;
    double y;
    protected List<DrawTextFragment> lines = new ArrayList<DrawTextFragment>();
    protected String rawText;
    protected DrawTextFragment bullet;
    protected int autoNbrIdx = 0;
    protected double maxLineHeight;

    public DrawTextParagraph(TextParagraph<T> paragraph) {
        this.paragraph = paragraph;
    }

    public void setPosition(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getY() {
        return this.y;
    }

    public void setAutoNumberingIdx(int index) {
        this.autoNbrIdx = index;
    }

    @Override
    public void draw(Graphics2D graphics) {
        Double spacing;
        Double rightMargin;
        Double indent;
        if (this.lines.isEmpty()) {
            return;
        }
        Insets2D insets = this.paragraph.getParentShape().getInsets();
        double leftInset = insets.left;
        double rightInset = insets.right;
        double penY = this.y;
        boolean firstLine = true;
        int indentLevel = this.paragraph.getIndentLevel();
        Double leftMargin = this.paragraph.getLeftMargin();
        if (leftMargin == null) {
            leftMargin = Units.toPoints(347663 * (indentLevel + 1));
        }
        if ((indent = this.paragraph.getIndent()) == null) {
            indent = Units.toPoints(347663 * indentLevel);
        }
        if ((rightMargin = this.paragraph.getRightMargin()) == null) {
            rightMargin = 0.0;
        }
        if ((spacing = this.paragraph.getLineSpacing()) == null) {
            spacing = 100.0;
        }
        for (DrawTextFragment line : this.lines) {
            double penX;
            if (firstLine) {
                if (!this.isEmptyParagraph()) {
                    this.bullet = this.getBullet(graphics, line.getAttributedString().getIterator());
                }
                if (this.bullet != null) {
                    this.bullet.setPosition(this.x + indent, penY);
                    this.bullet.draw(graphics);
                    double bulletWidth = this.bullet.getLayout().getAdvance() + 1.0f;
                    penX = this.x + Math.max(leftMargin, indent + bulletWidth);
                } else {
                    penX = this.x + indent;
                }
            } else {
                penX = this.x + leftMargin;
            }
            Rectangle2D anchor = DrawShape.getAnchor(graphics, this.paragraph.getParentShape());
            TextParagraph.TextAlign ta = this.paragraph.getTextAlign();
            if (ta == null) {
                ta = TextParagraph.TextAlign.LEFT;
            }
            switch (ta) {
                case CENTER: {
                    penX += (anchor.getWidth() - leftMargin - (double)line.getWidth() - leftInset - rightInset) / 2.0;
                    break;
                }
                case RIGHT: {
                    penX += anchor.getWidth() - (double)line.getWidth() - leftInset - rightInset;
                    break;
                }
            }
            line.setPosition(penX, penY);
            line.draw(graphics);
            penY = spacing > 0.0 ? (penY += spacing * 0.01 * (double)line.getHeight()) : (penY += -spacing.doubleValue());
            firstLine = false;
        }
        this.y = penY - this.y;
    }

    public float getFirstLineHeight() {
        return this.lines.isEmpty() ? 0.0f : this.lines.get(0).getHeight();
    }

    public float getLastLineHeight() {
        return this.lines.isEmpty() ? 0.0f : this.lines.get(this.lines.size() - 1).getHeight();
    }

    public boolean isEmptyParagraph() {
        return this.lines.isEmpty() || this.rawText.trim().isEmpty();
    }

    @Override
    public void applyTransform(Graphics2D graphics) {
    }

    @Override
    public void drawContent(Graphics2D graphics) {
    }

    protected void breakText(Graphics2D graphics) {
        int endIndex;
        this.lines.clear();
        DrawFactory fact = DrawFactory.getInstance(graphics);
        StringBuilder text = new StringBuilder();
        AttributedString at = this.getAttributedString(graphics, text);
        boolean emptyParagraph = "".equals(text.toString().trim());
        AttributedCharacterIterator it = at.getIterator();
        LineBreakMeasurer measurer = new LineBreakMeasurer(it, graphics.getFontRenderContext());
        do {
            TextParagraph.TextAlign hAlign;
            TextLayout layout;
            int nextBreak;
            int startIndex = measurer.getPosition();
            double wrappingWidth = this.getWrappingWidth(this.lines.size() == 0, graphics) + 1.0;
            if (wrappingWidth < 0.0) {
                wrappingWidth = 1.0;
            }
            if ((nextBreak = text.indexOf("\n", startIndex + 1)) == -1) {
                nextBreak = it.getEndIndex();
            }
            if ((layout = measurer.nextLayout((float)wrappingWidth, nextBreak, true)) == null) {
                layout = measurer.nextLayout((float)wrappingWidth, nextBreak, false);
            }
            if (layout == null) break;
            endIndex = measurer.getPosition();
            if (endIndex < it.getEndIndex() && text.charAt(endIndex) == '\n') {
                measurer.setPosition(endIndex + 1);
            }
            if ((hAlign = this.paragraph.getTextAlign()) == TextParagraph.TextAlign.JUSTIFY || hAlign == TextParagraph.TextAlign.JUSTIFY_LOW) {
                layout = layout.getJustifiedLayout((float)wrappingWidth);
            }
            AttributedString str = emptyParagraph ? null : new AttributedString(it, startIndex, endIndex);
            DrawTextFragment line = fact.getTextFragment(layout, str);
            this.lines.add(line);
            this.maxLineHeight = Math.max(this.maxLineHeight, (double)line.getHeight());
        } while (endIndex != it.getEndIndex());
        this.rawText = text.toString();
    }

    protected DrawTextFragment getBullet(Graphics2D graphics, AttributedCharacterIterator firstLineAttr) {
        TextParagraph.BulletStyle bulletStyle = this.paragraph.getBulletStyle();
        if (bulletStyle == null) {
            return null;
        }
        AutoNumberingScheme ans = bulletStyle.getAutoNumberingScheme();
        String buCharacter = ans != null ? ans.format(this.autoNbrIdx) : bulletStyle.getBulletCharacter();
        if (buCharacter == null) {
            return null;
        }
        String buFont = bulletStyle.getBulletFont();
        if (buFont == null) {
            buFont = this.paragraph.getDefaultFontFamily();
        }
        assert (buFont != null);
        Color buColor = bulletStyle.getBulletFontColor();
        if (buColor == null) {
            buColor = (Color)firstLineAttr.getAttribute(TextAttribute.FOREGROUND);
        }
        float fontSize = ((Float)firstLineAttr.getAttribute(TextAttribute.SIZE)).floatValue();
        Double buSz = bulletStyle.getBulletFontSize();
        if (buSz == null) {
            buSz = 100.0;
        }
        fontSize = buSz > 0.0 ? (float)((double)fontSize * (buSz * 0.01)) : (float)(-buSz.doubleValue());
        AttributedString str = new AttributedString(buCharacter);
        str.addAttribute(TextAttribute.FOREGROUND, buColor);
        str.addAttribute(TextAttribute.FAMILY, buFont);
        str.addAttribute(TextAttribute.SIZE, Float.valueOf(fontSize));
        TextLayout layout = new TextLayout(str.getIterator(), graphics.getFontRenderContext());
        DrawFactory fact = DrawFactory.getInstance(graphics);
        return fact.getTextFragment(layout, str);
    }

    protected String getRenderableText(TextRun tr) {
        StringBuilder buf = new StringBuilder();
        TextRun.TextCap cap = tr.getTextCap();
        String tabs = null;
        for (char c : tr.getRawText().toCharArray()) {
            if (c == '\t') {
                if (tabs == null) {
                    tabs = this.tab2space(tr);
                }
                buf.append(tabs);
                continue;
            }
            switch (cap) {
                case ALL: {
                    c = Character.toUpperCase(c);
                    break;
                }
                case SMALL: {
                    c = Character.toLowerCase(c);
                    break;
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }

    private String tab2space(TextRun tr) {
        AttributedString string = new AttributedString(" ");
        String typeFace = tr.getFontFamily();
        if (typeFace == null) {
            typeFace = "Lucida Sans";
        }
        string.addAttribute(TextAttribute.FAMILY, typeFace);
        Double fs = tr.getFontSize();
        if (fs == null) {
            fs = 12.0;
        }
        string.addAttribute(TextAttribute.SIZE, Float.valueOf(fs.floatValue()));
        TextLayout l = new TextLayout(string.getIterator(), new FontRenderContext(null, true, true));
        double wspace = l.getAdvance();
        Double tabSz = this.paragraph.getDefaultTabSize();
        if (tabSz == null) {
            tabSz = wspace * 4.0;
        }
        int numSpaces = (int)Math.ceil(tabSz / wspace);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < numSpaces; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    protected double getWrappingWidth(boolean firstLine, Graphics2D graphics) {
        double width;
        TextShape<TextParagraph<T>> ts;
        Double rightMargin;
        Double indent;
        Insets2D insets = this.paragraph.getParentShape().getInsets();
        double leftInset = insets.left;
        double rightInset = insets.right;
        Rectangle2D anchor = DrawShape.getAnchor(graphics, this.paragraph.getParentShape());
        int indentLevel = this.paragraph.getIndentLevel();
        Double leftMargin = this.paragraph.getLeftMargin();
        if (leftMargin == null) {
            leftMargin = Units.toPoints(347663 * (indentLevel + 1));
        }
        if ((indent = this.paragraph.getIndent()) == null) {
            indent = Units.toPoints(347663 * indentLevel);
        }
        if ((rightMargin = this.paragraph.getRightMargin()) == null) {
            rightMargin = 0.0;
        }
        if (!(ts = this.paragraph.getParentShape()).getWordWrap()) {
            width = ts.getSheet().getSlideShow().getPageSize().getWidth() - anchor.getX();
        } else {
            width = anchor.getWidth() - leftInset - rightInset - leftMargin - rightMargin;
            if (firstLine) {
                if (this.bullet != null) {
                    if (indent > 0.0) {
                        width -= indent.doubleValue();
                    }
                } else if (indent > 0.0) {
                    width -= indent.doubleValue();
                } else if (indent < 0.0) {
                    width += leftMargin.doubleValue();
                }
            }
        }
        return width;
    }

    protected AttributedString getAttributedString(Graphics2D graphics, StringBuilder text) {
        ArrayList<AttributedStringData> attList = new ArrayList<AttributedStringData>();
        if (text == null) {
            text = new StringBuilder();
        }
        DrawFontManager fontHandler = (DrawFontManager)graphics.getRenderingHint(Drawable.FONT_HANDLER);
        for (TextRun run : this.paragraph) {
            String runText = this.getRenderableText(run);
            if (runText.isEmpty()) continue;
            int beginIndex = text.length();
            text.append(runText);
            int endIndex = text.length();
            Color fgColor = run.getFontColor();
            if (fgColor == null) {
                fgColor = Color.BLACK;
            }
            attList.add(new AttributedStringData(TextAttribute.FOREGROUND, fgColor, beginIndex, endIndex));
            String fontFamily = run.getFontFamily();
            Map fontMap = (Map)graphics.getRenderingHint(Drawable.FONT_MAP);
            if (fontMap != null && fontMap.containsKey(fontFamily)) {
                fontFamily = (String)fontMap.get(fontFamily);
            }
            if (fontHandler != null) {
                fontFamily = fontHandler.getRendererableFont(fontFamily, run.getPitchAndFamily());
            }
            if (fontFamily == null) {
                fontFamily = this.paragraph.getDefaultFontFamily();
            }
            attList.add(new AttributedStringData(TextAttribute.FAMILY, fontFamily, beginIndex, endIndex));
            Double fontSz = run.getFontSize();
            if (fontSz == null) {
                fontSz = this.paragraph.getDefaultFontSize();
            }
            attList.add(new AttributedStringData(TextAttribute.SIZE, Float.valueOf(fontSz.floatValue()), beginIndex, endIndex));
            if (run.isBold()) {
                attList.add(new AttributedStringData(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, beginIndex, endIndex));
            }
            if (run.isItalic()) {
                attList.add(new AttributedStringData(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, beginIndex, endIndex));
            }
            if (run.isUnderlined()) {
                attList.add(new AttributedStringData(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, beginIndex, endIndex));
                attList.add(new AttributedStringData(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_TWO_PIXEL, beginIndex, endIndex));
            }
            if (run.isStrikethrough()) {
                attList.add(new AttributedStringData(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON, beginIndex, endIndex));
            }
            if (run.isSubscript()) {
                attList.add(new AttributedStringData(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB, beginIndex, endIndex));
            }
            if (!run.isSuperscript()) continue;
            attList.add(new AttributedStringData(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, beginIndex, endIndex));
        }
        if (text.length() == 0) {
            Double fontSz = this.paragraph.getDefaultFontSize();
            text.append(" ");
            attList.add(new AttributedStringData(TextAttribute.SIZE, Float.valueOf(fontSz.floatValue()), 0, 1));
        }
        AttributedString string = new AttributedString(text.toString());
        for (AttributedStringData asd : attList) {
            string.addAttribute(asd.attribute, asd.value, asd.beginIndex, asd.endIndex);
        }
        return string;
    }

    private static class AttributedStringData {
        AttributedCharacterIterator.Attribute attribute;
        Object value;
        int beginIndex;
        int endIndex;

        AttributedStringData(AttributedCharacterIterator.Attribute attribute, Object value, int beginIndex, int endIndex) {
            this.attribute = attribute;
            this.value = value;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }
    }
}

