/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.poi.sl.draw.DrawFactory;
import org.apache.poi.sl.draw.DrawShape;
import org.apache.poi.sl.draw.DrawSimpleShape;
import org.apache.poi.sl.draw.DrawTextParagraph;
import org.apache.poi.sl.draw.Drawable;
import org.apache.poi.sl.usermodel.Insets2D;
import org.apache.poi.sl.usermodel.PlaceableShape;
import org.apache.poi.sl.usermodel.TextParagraph;
import org.apache.poi.sl.usermodel.TextRun;
import org.apache.poi.sl.usermodel.TextShape;
import org.apache.poi.util.JvmBugs;

public class DrawTextShape<T extends TextShape<? extends TextParagraph<? extends TextRun>>>
extends DrawSimpleShape<T> {
    public DrawTextShape(T shape) {
        super(shape);
    }

    @Override
    public void drawContent(Graphics2D graphics) {
        DrawTextShape.fixFonts(graphics);
        Rectangle2D anchor = DrawShape.getAnchor(graphics, (PlaceableShape)((Object)this.shape));
        Insets2D insets = ((TextShape)this.shape).getInsets();
        double x = anchor.getX() + insets.left;
        double y = anchor.getY();
        AffineTransform tx = graphics.getTransform();
        if (((TextShape)this.shape).getFlipVertical()) {
            graphics.translate(anchor.getX(), anchor.getY() + anchor.getHeight());
            graphics.scale(1.0, -1.0);
            graphics.translate(-anchor.getX(), -anchor.getY());
            double centerX = anchor.getX() + anchor.getWidth() / 2.0;
            double centerY = anchor.getY() + anchor.getHeight() / 2.0;
            graphics.translate(centerX, centerY);
            graphics.rotate(Math.toRadians(180.0));
            graphics.translate(-centerX, -centerY);
        }
        if (((TextShape)this.shape).getFlipHorizontal()) {
            graphics.translate(anchor.getX() + anchor.getWidth(), anchor.getY());
            graphics.scale(-1.0, 1.0);
            graphics.translate(-anchor.getX(), -anchor.getY());
        }
        double textHeight = ((TextShape)this.shape).getTextHeight();
        switch (((TextShape)this.shape).getVerticalAlignment()) {
            case TOP: {
                y += insets.top;
                break;
            }
            case BOTTOM: {
                y += anchor.getHeight() - textHeight - insets.bottom;
                break;
            }
            default: {
                double delta = anchor.getHeight() - textHeight - insets.top - insets.bottom;
                y += insets.top + delta / 2.0;
            }
        }
        this.drawParagraphs(graphics, x, y);
        graphics.setTransform(tx);
    }

    public double drawParagraphs(Graphics2D graphics, double x, double y) {
        DrawFactory fact = DrawFactory.getInstance(graphics);
        Insets2D shapePadding = ((TextShape)this.shape).getInsets();
        double y0 = y;
        Iterator paragraphs = ((TextShape)this.shape).iterator();
        boolean isFirstLine = true;
        int autoNbrIdx = 0;
        while (paragraphs.hasNext()) {
            TextParagraph p = (TextParagraph)paragraphs.next();
            DrawTextParagraph dp = fact.getDrawable(p);
            TextParagraph.BulletStyle bs = p.getBulletStyle();
            if (bs == null || bs.getAutoNumberingScheme() == null) {
                autoNbrIdx = -1;
            } else {
                Integer startAt = bs.getAutoNumberingStartAt();
                if (startAt == null) {
                    startAt = 1;
                }
                if (startAt > autoNbrIdx) {
                    autoNbrIdx = startAt;
                }
            }
            dp.setAutoNumberingIdx(autoNbrIdx);
            dp.breakText(graphics);
            if (!isFirstLine) {
                Double spaceBefore = p.getSpaceBefore();
                if (spaceBefore == null) {
                    spaceBefore = 0.0;
                }
                y = spaceBefore > 0.0 ? (y += spaceBefore * 0.01 * (double)dp.getFirstLineHeight()) : (y += -spaceBefore.doubleValue());
            }
            isFirstLine = false;
            dp.setPosition(x, y);
            dp.draw(graphics);
            y += dp.getY();
            if (paragraphs.hasNext()) {
                Double spaceAfter = p.getSpaceAfter();
                if (spaceAfter == null) {
                    spaceAfter = 0.0;
                }
                y = spaceAfter > 0.0 ? (y += spaceAfter * 0.01 * (double)dp.getLastLineHeight()) : (y += -spaceAfter.doubleValue());
            }
            ++autoNbrIdx;
        }
        return y - y0;
    }

    public double getTextHeight() {
        BufferedImage img = new BufferedImage(1, 1, 1);
        Graphics2D graphics = img.createGraphics();
        DrawTextShape.fixFonts(graphics);
        return this.drawParagraphs(graphics, 0.0, 0.0);
    }

    private static void fixFonts(Graphics2D graphics) {
        if (!JvmBugs.hasLineBreakMeasurerBug()) {
            return;
        }
        HashMap<String, String> fontMap = (HashMap<String, String>)graphics.getRenderingHint(Drawable.FONT_MAP);
        if (fontMap == null) {
            fontMap = new HashMap<String, String>();
            graphics.setRenderingHint(Drawable.FONT_MAP, fontMap);
        }
        if (!fontMap.containsKey("Calibri")) {
            fontMap.put("Calibri", "Lucida Sans");
        }
        if (!fontMap.containsKey("Cambria")) {
            fontMap.put("Cambria", "Lucida Bright");
        }
    }
}

