/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.common.fork.ExecutionGraphBuilderUtils;
import org.apache.poi.ss.formula.TwoDEval;
import org.apache.poi.ss.formula.eval.ValueEval;

public final class ArrayEval
implements TwoDEval {
    private List<ValueEval> values = new LinkedList<ValueEval>();

    @Override
    public ValueEval getValue(int rowIndex, int columnIndex) {
        return this.values.get(rowIndex);
    }

    @Override
    public int getWidth() {
        return this.values.size();
    }

    @Override
    public int getHeight() {
        return 1;
    }

    @Override
    public boolean isRow() {
        return true;
    }

    @Override
    public boolean isColumn() {
        return false;
    }

    @Override
    public TwoDEval getRow(int rowIndex) {
        final ValueEval v = this.values.get(rowIndex);
        return new TwoDEval(){

            @Override
            public boolean isSubTotal(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public boolean isRow() {
                return true;
            }

            @Override
            public boolean isColumn() {
                return false;
            }

            @Override
            public int getWidth() {
                return 1;
            }

            @Override
            public ValueEval getValue(int rowIndex, int columnIndex) {
                return v;
            }

            @Override
            public int getHeight() {
                return 1;
            }

            @Override
            public TwoDEval getRow(int rowIndex) {
                return null;
            }

            @Override
            public TwoDEval getColumn(int columnIndex) {
                return null;
            }
        };
    }

    @Override
    public TwoDEval getColumn(int columnIndex) {
        return this.getRow(columnIndex);
    }

    @Override
    public boolean isSubTotal(int rowIndex, int columnIndex) {
        return false;
    }

    public void setValues(List<ValueEval> values) {
        this.values = values;
    }

    public List<Object> getArrayValues() {
        ArrayList<Object> result = new ArrayList<Object>(this.values.size());
        for (ValueEval value : this.values) {
            result.add(ExecutionGraphBuilderUtils.coerceValueTo(value));
        }
        return result;
    }

    public String toString() {
        return "ArrayEval [values=" + this.getArrayValues() + "]";
    }
}

