/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.common.fork.ExecutionGraphBuilderUtils;
import org.apache.poi.ss.formula.TwoDEval;
import org.apache.poi.ss.formula.eval.AreaEval;
import org.apache.poi.ss.formula.eval.AreaEvalBase;
import org.apache.poi.ss.formula.eval.ValueEval;

public final class TableEval
extends AreaEvalBase {
    private List<List<Object>> rows;

    public TableEval(int firstRow, int firstColumn, int lastRow, int lastColumn) {
        super(firstRow, firstColumn, lastRow, lastColumn);
        this.rows = new ArrayList<List<Object>>(lastRow + 1);
    }

    @Override
    public AreaEval offset(int relFirstRowIx, int relLastRowIx, int relFirstColIx, int relLastColIx) {
        TableEval table = new TableEval(0, 0, relLastRowIx, relLastColIx);
        ArrayList<List<Object>> r = new ArrayList<List<Object>>(this.rows.subList(relFirstRowIx, relLastRowIx));
        for (int i = 0; i < r.size(); ++i) {
            r.set(i, ((List)r.get(i)).subList(relFirstColIx, relLastColIx + 1));
        }
        table.rows = r;
        return table;
    }

    @Override
    public TwoDEval getRow(int rowIndex) {
        TableEval table = new TableEval(0, 0, 0, this.getLastColumn());
        table.rows = this.rows.subList(rowIndex, rowIndex + 1);
        return table;
    }

    @Override
    public TwoDEval getColumn(int columnIndex) {
        TableEval table = new TableEval(0, 0, this.getLastRow(), 0);
        table.rows = new ArrayList<List<Object>>(this.rows);
        for (int i = 0; i < table.rows.size(); ++i) {
            List<Object> row = table.rows.get(i);
            table.rows.set(i, Arrays.asList(row.get(columnIndex)));
        }
        return table;
    }

    @Override
    public ValueEval getRelativeValue(int relativeRowIndex, int relativeColumnIndex) {
        return ExecutionGraphBuilderUtils.valueToValueEval(this.rows.get(relativeRowIndex).get(relativeColumnIndex));
    }

    @Override
    public ValueEval getRelativeValue(int sheetIndex, int relativeRowIndex, int relativeColumnIndex) {
        return this.getRelativeValue(relativeRowIndex, relativeColumnIndex);
    }

    public void setValues(List<List<Object>> rows) {
        this.rows = rows;
    }
}

