/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.ss.formula.eval.AreaEval;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.StringValueEval;
import org.apache.poi.ss.formula.eval.ValueEval;

public class Area2DValues {
    private List<DisplayRow> values = new ArrayList<DisplayRow>();
    private int width;
    private int height;

    public Area2DValues(AreaEval area) {
        this.width = area.getWidth();
        this.height = area.getHeight();
        for (int i = 0; i < this.height; ++i) {
            this.values.add(new DisplayRow(area, i));
        }
    }

    public List<DisplayRow> getValues() {
        return this.values;
    }

    public List<String> getRangeCellAddresses() {
        LinkedList<String> result = new LinkedList<String>();
        for (DisplayRow value : this.values) {
            result.addAll(value.getCellNames());
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Area").append(this.width).append("x").append(this.height).append(";");
        for (int i = 0; i < this.values.size(); ++i) {
            result.append(this.values.get(i).toString());
        }
        return result.toString();
    }

    public static class DisplayRow {
        private List<ValueEval> values = new LinkedList<ValueEval>();
        private int localOffset;
        private AreaEval areaEval;

        public DisplayRow(AreaEval area, int localOffset) {
            this.areaEval = area;
            this.localOffset = localOffset;
            for (int i = 0; i < area.getWidth(); ++i) {
                this.values.add(area.getRelativeValue(localOffset, i));
            }
        }

        public List<ValueEval> getValues() {
            return this.values;
        }

        private String getCellLabel(int row, int column) {
            return CellReference.convertNumToColString(this.areaEval.getFirstColumn() + column) + (this.areaEval.getFirstRow() + row + 1);
        }

        public List<String> getCellNames() {
            ArrayList<String> result = new ArrayList<String>(this.values.size());
            for (int i = 0; i < this.values.size(); ++i) {
                String label = this.getCellLabel(this.localOffset, i);
                result.add(label);
            }
            return result;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("[");
            for (int i = 0; i < this.values.size(); ++i) {
                StringValueEval value;
                String prefix = this.getCellLabel(this.localOffset, i);
                result.append(prefix).append(":");
                if (this.values.get(i) instanceof NumberEval) {
                    value = (NumberEval)this.values.get(i);
                    result.append(((NumberEval)value).getStringValue());
                } else if (this.values.get(i) instanceof StringValueEval) {
                    value = (StringValueEval)this.values.get(i);
                    result.append(value.getStringValue());
                }
                if (i + 1 >= this.values.size()) continue;
                result.append(",");
            }
            result.append("];");
            return result.toString();
        }
    }
}

