/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import java.util.ArrayList;
import org.apache.poi.common.fork.ExecutionGraphBuilderUtils;
import org.apache.poi.ss.formula.eval.BlankEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.MissingArgEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.RefEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.Function;

public final class Choose
implements Function {
    @Override
    public ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        if (args.length < 2) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            ValueEval[] values = Choose.getNumberEvalArray(args);
            for (int i = 0; args.length > 0 && values.length > 0 && i < args.length; ++i) {
                ExecutionGraphBuilderUtils.handleRefEval(args[i], values[i]);
            }
            int ix = Choose.evaluateFirstArg(args[0], srcRowIndex, srcColumnIndex);
            if (ix < 1 || ix >= args.length) {
                return ErrorEval.VALUE_INVALID;
            }
            ValueEval result = OperandResolver.getSingleValue(args[ix], srcRowIndex, srcColumnIndex);
            if (result == MissingArgEval.instance) {
                return BlankEval.instance;
            }
            return result;
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    public static int evaluateFirstArg(ValueEval arg0, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
        ValueEval ev = OperandResolver.getSingleValue(arg0, srcRowIndex, srcColumnIndex);
        return OperandResolver.coerceValueToInt(ev);
    }

    public static ValueEval[] getNumberEvalArray(ValueEval[] args) {
        ArrayList<ValueEval> retlist = new ArrayList<ValueEval>(args.length);
        for (ValueEval arg : args) {
            if (arg instanceof RefEval) {
                RefEval ref = (RefEval)arg;
                for (int i = ref.getFirstSheetIndex(); i <= ref.getLastSheetIndex(); ++i) {
                    retlist.add(ref.getInnerValueEval(i));
                }
                continue;
            }
            retlist.add(arg);
        }
        return retlist.toArray(new ValueEval[retlist.size()]);
    }
}

