/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.util.Map;
import org.apache.poi.common.fork.EmptyExecutionGraph;
import org.apache.poi.common.fork.ExecutionGraphBuilderUtils;
import org.apache.poi.common.fork.IExecutionGraphBuilder;
import org.apache.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import org.apache.poi.ss.formula.EvaluationCell;
import org.apache.poi.ss.formula.WorkbookEvaluator;
import org.apache.poi.ss.formula.WorkbookEvaluatorProvider;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFEvaluationCell;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public abstract class BaseXSSFFormulaEvaluator
implements FormulaEvaluator,
WorkbookEvaluatorProvider {
    private WorkbookEvaluator _bookEvaluator;
    private IExecutionGraphBuilder _graphBuilder = EmptyExecutionGraph.DoNothingExecutionGraphBuilder.get();

    protected BaseXSSFFormulaEvaluator(WorkbookEvaluator bookEvaluator) {
        this._bookEvaluator = bookEvaluator;
    }

    public void clearAllCachedResultValues() {
        this._bookEvaluator.clearAllCachedResultValues();
    }

    public void notifySetFormula(Cell cell) {
        this._bookEvaluator.notifyUpdateCell((EvaluationCell)new XSSFEvaluationCell((XSSFCell)cell));
    }

    public void notifyDeleteCell(Cell cell) {
        this._bookEvaluator.notifyDeleteCell((EvaluationCell)new XSSFEvaluationCell((XSSFCell)cell));
    }

    public void notifyUpdateCell(Cell cell) {
        this._bookEvaluator.notifyUpdateCell((EvaluationCell)new XSSFEvaluationCell((XSSFCell)cell));
    }

    public CellValue evaluate(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 4: {
                return CellValue.valueOf((boolean)cell.getBooleanCellValue());
            }
            case 5: {
                return CellValue.getError((int)cell.getErrorCellValue());
            }
            case 2: {
                return this.evaluateFormulaCellValue(cell);
            }
            case 0: {
                return new CellValue(cell.getNumericCellValue());
            }
            case 1: {
                return new CellValue(cell.getRichStringCellValue().getString());
            }
            case 3: {
                return null;
            }
        }
        throw new IllegalStateException("Bad cell type (" + cell.getCellType() + ")");
    }

    public int evaluateFormulaCell(Cell cell) {
        if (cell == null || cell.getCellType() != 2) {
            return -1;
        }
        CellValue cv = this.evaluateFormulaCellValue(cell);
        BaseXSSFFormulaEvaluator.setCellValue(cell, cv);
        return cv.getCellType();
    }

    protected void doEvaluateInCell(Cell cell) {
        if (cell == null) {
            return;
        }
        if (cell.getCellType() == 2) {
            CellValue cv = this.evaluateFormulaCellValue(cell);
            BaseXSSFFormulaEvaluator.setCellType(cell, cv);
            BaseXSSFFormulaEvaluator.setCellValue(cell, cv);
        }
    }

    private static void setCellType(Cell cell, CellValue cv) {
        int cellType = cv.getCellType();
        switch (cellType) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                cell.setCellType(cellType);
                return;
            }
        }
        throw new IllegalStateException("Unexpected cell value type (" + cellType + ")");
    }

    private static void setCellValue(Cell cell, CellValue cv) {
        int cellType = cv.getCellType();
        switch (cellType) {
            case 4: {
                cell.setCellValue(cv.getBooleanValue());
                break;
            }
            case 5: {
                cell.setCellErrorValue(cv.getErrorValue());
                break;
            }
            case 0: {
                cell.setCellValue(cv.getNumberValue());
                break;
            }
            case 1: {
                cell.setCellValue((RichTextString)new XSSFRichTextString(cv.getStringValue()));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected cell value type (" + cellType + ")");
            }
        }
    }

    protected abstract EvaluationCell toEvaluationCell(Cell var1);

    private CellValue evaluateFormulaCellValue(Cell cell) {
        EvaluationCell evalCell = this.toEvaluationCell(cell);
        ValueEval eval = this._bookEvaluator.evaluate(evalCell);
        return ExecutionGraphBuilderUtils.coerceValueEvalToCellValue((ValueEval)eval);
    }

    public void setupReferencedWorkbooks(Map<String, FormulaEvaluator> evaluators) {
        CollaboratingWorkbooksEnvironment.setupFormulaEvaluator(evaluators);
    }

    public WorkbookEvaluator _getWorkbookEvaluator() {
        return this._bookEvaluator;
    }

    public void setIgnoreMissingWorkbooks(boolean ignore) {
        this._bookEvaluator.setIgnoreMissingWorkbooks(ignore);
    }

    public void setDebugEvaluationOutputForNextEval(boolean value) {
        this._bookEvaluator.setDebugEvaluationOutputForNextEval(value);
    }

    public void setExecutionGraphBuilder(IExecutionGraphBuilder graphBuilder) {
        this._graphBuilder = graphBuilder;
        if (this._bookEvaluator != null) {
            this._bookEvaluator.setExecutionGraphBuilder(this._graphBuilder);
        }
    }
}

