/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client;

import com.databend.client.DatabendSession;
import com.databend.client.PaginationOptions;
import com.databend.client.StageAttachment;
import java.time.Duration;
import java.util.Map;

public class ClientSettings {
    public static final Duration DEFAULT_QUERY_TIMEOUT = Duration.ofSeconds(60L);
    public static final Integer DEFAULT_CONNECTION_TIMEOUT = 15;
    public static final int DEFAULT_RETRY_ATTEMPTS = 5;
    private final String host;
    private final DatabendSession session;
    private final Duration queryTimeoutNanos;
    private final Integer connectionTimeout;
    private final PaginationOptions paginationOptions;
    private final StageAttachment stageAttachment;
    private final Map<String, String> additionalHeaders;
    private final int retryAttempts;

    public ClientSettings(String host) {
        this(host, DatabendSession.createDefault(), DEFAULT_QUERY_TIMEOUT, DEFAULT_CONNECTION_TIMEOUT, PaginationOptions.defaultPaginationOptions(), null, null, 5);
    }

    public ClientSettings(String host, String database) {
        DatabendSession session = new DatabendSession.Builder().setDatabase(database).build();
        this.host = host;
        this.session = session;
        this.queryTimeoutNanos = DEFAULT_QUERY_TIMEOUT;
        this.connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
        this.paginationOptions = PaginationOptions.defaultPaginationOptions();
        this.additionalHeaders = null;
        this.stageAttachment = null;
        this.retryAttempts = 5;
    }

    public ClientSettings(String host, DatabendSession session, Duration queryTimeoutNanos, Integer connectionTimeout, PaginationOptions paginationOptions, Map<String, String> additionalHeaders, StageAttachment stageAttachment, int retryAttempts) {
        this.host = host;
        this.session = session;
        this.queryTimeoutNanos = queryTimeoutNanos;
        this.connectionTimeout = connectionTimeout;
        this.paginationOptions = paginationOptions;
        this.additionalHeaders = additionalHeaders;
        this.stageAttachment = stageAttachment;
        this.retryAttempts = retryAttempts;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DatabendSession getSession() {
        return this.session;
    }

    public String getHost() {
        return this.host;
    }

    public Duration getQueryTimeoutNanos() {
        return this.queryTimeoutNanos;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public PaginationOptions getPaginationOptions() {
        return this.paginationOptions;
    }

    public Map<String, String> getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public StageAttachment getStageAttachment() {
        return this.stageAttachment;
    }

    public int getRetryAttempts() {
        if (this.retryAttempts <= 0) {
            return 5;
        }
        return this.retryAttempts;
    }

    public static class Builder {
        private DatabendSession session;
        private String host;
        private Duration queryTimeoutNanos;
        private Integer connectionTimeout;
        private PaginationOptions paginationOptions;
        private StageAttachment stageAttachment;
        private Map<String, String> additionalHeaders;
        private int retryAttempts;

        public Builder setSession(DatabendSession session) {
            this.session = session;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setConnectionTimeout(Integer timeout2) {
            this.connectionTimeout = timeout2;
            return this;
        }

        public Builder setQueryTimeoutNanos(Duration queryTimeoutNanos) {
            this.queryTimeoutNanos = queryTimeoutNanos;
            return this;
        }

        public Builder setPaginationOptions(PaginationOptions paginationOptions) {
            this.paginationOptions = paginationOptions;
            return this;
        }

        public Builder setAdditionalHeaders(Map<String, String> additionalHeaders) {
            this.additionalHeaders = additionalHeaders;
            return this;
        }

        public Builder setRetryAttempts(int retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        public Builder setStageAttachment(StageAttachment stageAttachment) {
            this.stageAttachment = stageAttachment;
            return this;
        }

        public ClientSettings build() {
            return new ClientSettings(this.host, this.session, this.queryTimeoutNanos, this.connectionTimeout, this.paginationOptions, this.additionalHeaders, this.stageAttachment, this.retryAttempts);
        }
    }
}

