/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc;

import com.databend.jdbc.ConnectionProperty;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Stream;

abstract class AbstractConnectionProperty<T>
implements ConnectionProperty<T> {
    protected static final Predicate<Properties> NOT_REQUIRED = properties -> false;
    protected static final Predicate<Properties> ALLOWED = properties -> true;
    protected static final Converter<String> STRING_CONVERTER = value -> value;
    protected static final Converter<String> NON_EMPTY_STRING_CONVERTER = value -> {
        Preconditions.checkArgument(!value.isEmpty(), "value is empty");
        return value;
    };
    protected static final Converter<File> FILE_CONVERTER = File::new;
    protected static final Converter<Boolean> BOOLEAN_CONVERTER = value -> {
        switch (value.toLowerCase(Locale.ENGLISH)) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        throw new IllegalArgumentException("value must be 'true' or 'false'");
    };
    protected static final Converter<Integer> INTEGER_CONVERTER = Integer::parseInt;
    private final String key;
    private final Optional<String> defaultValue;
    private final Predicate<Properties> isRequired;
    private final Predicate<Properties> isAllowed;
    private final Converter<T> converter;
    private final String[] choices;

    protected AbstractConnectionProperty(String key, Optional<String> defaultValue, Predicate<Properties> isRequired, Predicate<Properties> isAllowed, Converter<T> converter, String[] choices, String[] aliases) {
        this.key = Objects.requireNonNull(key, "key is null");
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue is null");
        this.isRequired = Objects.requireNonNull(isRequired, "isRequired is null");
        this.isAllowed = Objects.requireNonNull(isAllowed, "isAllowed is null");
        this.converter = Objects.requireNonNull(converter, "converter is null");
        this.choices = choices == null || choices.length == 0 ? this.inferChoices(converter) : choices;
    }

    protected AbstractConnectionProperty(String key, Optional<String> defaultValue, Predicate<Properties> isRequired, Predicate<Properties> isAllowed, Converter<T> converter) {
        this.key = Objects.requireNonNull(key, "key is null");
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue is null");
        this.isRequired = Objects.requireNonNull(isRequired, "isRequired is null");
        this.isAllowed = Objects.requireNonNull(isAllowed, "isAllowed is null");
        this.converter = Objects.requireNonNull(converter, "converter is null");
        this.choices = this.inferChoices(converter);
    }

    protected AbstractConnectionProperty(String key, Predicate<Properties> required, Predicate<Properties> allowed, Converter<T> converter) {
        this(key, Optional.empty(), required, allowed, converter);
    }

    protected AbstractConnectionProperty(String key, Predicate<Properties> required, Predicate<Properties> allowed, Converter<T> converter, String[] aliases) {
        this(key, Optional.empty(), required, allowed, converter, null, aliases);
    }

    protected static <T> Predicate<T> checkedPredicate(CheckedPredicate<T> predicate) {
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (SQLException e) {
                return false;
            }
        };
    }

    private String[] inferChoices(Converter<T> converter) {
        String[] choices = null;
        Class type = new TypeToken<T>(this.getClass()){}.getRawType();
        choices = type == Boolean.class ? new String[]{"true", "false"} : (Enum.class.isAssignableFrom(type) ? (String[])Stream.of(type.getEnumConstants()).map(Object::toString).toArray(String[]::new) : null);
        return choices;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Optional<String> getDefault() {
        return this.defaultValue;
    }

    @Override
    public boolean isRequired(Properties properties) {
        return this.isRequired.test(properties);
    }

    @Override
    public boolean isAllowed(Properties properties) {
        return this.isAllowed.test(properties);
    }

    @Override
    public Optional<T> getValue(Properties properties) throws SQLException {
        String value = properties.getProperty(this.key);
        if (value == null) {
            if (this.isRequired(properties)) {
                throw new SQLException(String.format("Connection property '%s' is required", this.key));
            }
            return Optional.empty();
        }
        try {
            return Optional.of(this.converter.convert(value));
        }
        catch (RuntimeException e) {
            if (value.isEmpty()) {
                throw new SQLException(String.format("Connection property '%s' value is empty", this.key), e);
            }
            throw new SQLException(String.format("Connection property '%s' value is invalid: %s", this.key, value), e);
        }
    }

    @Override
    public DriverPropertyInfo getDriverPropertyInfo(Properties mergedProperties) {
        String currentValue = mergedProperties.getProperty(this.key);
        DriverPropertyInfo result = new DriverPropertyInfo(this.key, currentValue);
        result.required = this.isRequired.test(mergedProperties);
        result.choices = this.choices != null ? (String[])this.choices.clone() : null;
        return result;
    }

    @Override
    public void validate(Properties properties) throws SQLException {
        if (properties.containsKey(this.key) && !this.isAllowed(properties)) {
            throw new SQLException(String.format("Connection property '%s' is not allowed", this.key));
        }
        this.getValue(properties);
    }

    static interface Converter<T> {
        public T convert(String var1);
    }

    protected static interface CheckedPredicate<T> {
        public boolean test(T var1) throws SQLException;
    }
}

