/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc;

import com.databend.jdbc.DatabendDriver;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DriverInfo {
    static final String DRIVER_NAME;
    static final String DRIVER_VERSION;
    static final int DRIVER_VERSION_MAJOR;
    static final int DRIVER_VERSION_MINOR;

    private DriverInfo() {
    }

    static {
        try {
            Properties properties = new Properties();
            URL url = Resources.getResource(DriverInfo.class, "driver.properties");
            try (InputStream in = url.openStream();){
                properties.load(in);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            DRIVER_NAME = properties.getProperty("driverName");
            DRIVER_VERSION = properties.getProperty("driverVersion");
            Verify.verify(!Strings.isNullOrEmpty(DRIVER_NAME), "driverName is null or empty", new Object[0]);
            Verify.verify(!Strings.isNullOrEmpty(DRIVER_VERSION), "driverVersion is null or empty", new Object[0]);
            Matcher matcher = Pattern.compile("^(\\d+)(\\.(\\d+))?($|[.-])").matcher(DRIVER_VERSION);
            Verify.verify(matcher.find(), "driverVersion is invalid: %s", (Object)DRIVER_VERSION);
            DRIVER_VERSION_MAJOR = Integer.parseInt(matcher.group(1));
            DRIVER_VERSION_MINOR = Integer.parseInt(MoreObjects.firstNonNull(matcher.group(3), "0"));
        }
        catch (RuntimeException e) {
            Logger.getLogger(DatabendDriver.class.getPackage().getName()).log(Level.SEVERE, "Failed to load driver info", e);
            throw e;
        }
    }
}

