/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc.parser;

import de.siegmar.fastcsv.writer.CsvWriter;
import de.siegmar.fastcsv.writer.LineDelimiter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BatchInsertUtils {
    private static final Logger logger = Logger.getLogger(BatchInsertUtils.class.getPackage().getName());
    private final String sql;
    private String databaseTableName;
    private TreeMap<Integer, String> placeHolderEntries;

    private BatchInsertUtils(String sql) {
        this.sql = sql;
        this.placeHolderEntries = new TreeMap();
        this.databaseTableName = this.getDatabaseTableName();
    }

    public static Optional<BatchInsertUtils> tryParseInsertSql(String sql) {
        return Optional.of(new BatchInsertUtils(sql));
    }

    public String getSql() {
        return this.sql;
    }

    public String getDatabaseTableName() {
        Pattern pattern = Pattern.compile("^INSERT INTO\\s+((?:[\\w-]+\\.)?([\\w-]+))(?:\\s*\\((?:[^()]|\\([^()]*\\))*\\))?", 2);
        Matcher matcher = pattern.matcher(this.sql);
        if (matcher.find()) {
            this.databaseTableName = matcher.group(1);
        }
        return this.databaseTableName;
    }

    public void setPlaceHolderValue(int index, String value) throws IllegalArgumentException {
        int i = index - 1;
        this.placeHolderEntries.put(i, value);
    }

    public String[] getValues() {
        if (this.placeHolderEntries.isEmpty()) {
            return null;
        }
        String[] values = new String[this.placeHolderEntries.lastKey() + 1];
        for (Map.Entry<Integer, String> elem : this.placeHolderEntries.entrySet()) {
            values[elem.getKey().intValue()] = elem.getValue();
        }
        return values;
    }

    public File saveBatchToCSV(List<String[]> values) {
        String id = UUID.randomUUID().toString();
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File tempFile = new File(tempDir, "databend_batch_insert_" + id + ".csv");
        return this.saveBatchToCSV(values, tempFile);
    }

    private String convertToCSV(String[] data) {
        return Stream.of(data).collect(Collectors.joining(","));
    }

    public File saveBatchToCSV(List<String[]> values, File file) {
        File file2;
        int rowSize = values.get(0).length;
        FileWriter pw = new FileWriter(file);
        try {
            CsvWriter w = CsvWriter.builder().quoteCharacter('\"').lineDelimiter(LineDelimiter.LF).build(pw);
            for (String[] row : values) {
                w.writeRow(row);
            }
            logger.log(Level.FINE, "save batch insert to csv file: " + file.getAbsolutePath() + "rows: " + values.size() + " columns: " + rowSize);
            file2 = file;
        }
        catch (Throwable throwable) {
            try {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        pw.close();
        return file2;
    }

    public void clean() {
        this.placeHolderEntries.clear();
    }
}

