/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.shaded.common.base.MoreObjects;

public class PaginationOptions {
    private static final int DEFAULT_WAIT_TIME_SEC = 10;
    private static final int DEFAULT_MAX_ROWS_IN_BUFFER = 5000000;
    private static final int DEFAULT_MAX_ROWS_PER_PAGE = 10000;
    private final int waitTimeSecs;
    private final int maxRowsInBuffer;
    private final int maxRowsPerPage;

    @JsonCreator
    public PaginationOptions(@JsonProperty(value="wait_time_secs") int waitTimeSecs, @JsonProperty(value="max_rows_in_buffer") int maxRowsInBuffer, @JsonProperty(value="max_rows_per_page") int maxRowsPerPage) {
        this.waitTimeSecs = waitTimeSecs;
        this.maxRowsInBuffer = maxRowsInBuffer;
        this.maxRowsPerPage = maxRowsPerPage;
    }

    public static PaginationOptions defaultPaginationOptions() {
        return new PaginationOptions(10, 5000000, 10000);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static int getDefaultWaitTimeSec() {
        return 10;
    }

    public static int getDefaultMaxRowsInBuffer() {
        return 5000000;
    }

    public static int getDefaultMaxRowsPerPage() {
        return 10000;
    }

    @JsonProperty(value="wait_time_secs")
    public int getWaitTimeSecs() {
        return this.waitTimeSecs;
    }

    @JsonProperty(value="max_rows_in_buffer")
    public int getMaxRowsInBuffer() {
        return this.maxRowsInBuffer;
    }

    @JsonProperty(value="max_rows_per_page")
    public int getMaxRowsPerPage() {
        return this.maxRowsPerPage;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("waitTimeSecs", this.waitTimeSecs).add("maxRowsInBuffer", this.maxRowsInBuffer).add("maxRowsPerPage", this.maxRowsPerPage).toString();
    }

    public static class Builder {
        private int waitTimeSecs;
        private int maxRowsInBuffer;
        private int maxRowsPerPage;

        public Builder setWaitTimeSecs(int waitTimeSecs) {
            this.waitTimeSecs = waitTimeSecs;
            return this;
        }

        public Builder setMaxRowsInBuffer(int maxRowsInBuffer) {
            this.maxRowsInBuffer = maxRowsInBuffer;
            return this;
        }

        public Builder setMaxRowsPerPage(int maxRowsPerPage) {
            this.maxRowsPerPage = maxRowsPerPage;
            return this;
        }

        public PaginationOptions build() {
            return new PaginationOptions(this.waitTimeSecs, this.maxRowsInBuffer, this.maxRowsPerPage);
        }
    }
}

