/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc;

import com.databend.client.data.DatabendRawType;
import com.google.shaded.common.base.Preconditions;
import com.google.shaded.common.base.Strings;
import com.google.shaded.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class DatabendColumnInfo {
    private static final int VARBINARY_MAX = 0x40000000;
    private static final int TIME_ZONE_MAX = 40;
    private static final int TIME_MAX = "HH:mm:ss.SSS".length();
    private static final int TIME_WITH_TIME_ZONE_MAX = TIME_MAX + 40;
    private static final int TIMESTAMP_MAX = "yyyy-MM-dd HH:mm:ss.SSS".length();
    private static final int TIMESTAMP_WITH_TIME_ZONE_MAX = TIMESTAMP_MAX + 40;
    private static final int DATE_MAX = "yyyy-MM-dd".length();
    private final int columnType;
    private final String columnName;
    private final List<Integer> columnParameterTypes;
    private final DatabendRawType type;
    private final Nullable nullable;
    private final boolean currency;
    private final boolean signed;
    private final int precision;
    private final int scale;
    private final int columnDisplaySize;
    private final String columnLabel;
    private final String tableName;
    private final String schemaName;
    private final String catalogName;

    public DatabendColumnInfo(int columnType, List<Integer> columnParameterTypes, DatabendRawType type, Nullable nullable, boolean currency, boolean signed, int precision, int scale, int columnDisplaySize, String columnLabel, String columnName, String tableName, String schemaName, String catalogName) {
        this.columnType = columnType;
        this.columnParameterTypes = columnParameterTypes;
        this.type = type;
        this.nullable = nullable;
        this.currency = currency;
        this.signed = signed;
        this.precision = precision;
        this.scale = scale;
        this.columnDisplaySize = columnDisplaySize;
        this.columnLabel = columnLabel;
        this.columnName = columnName;
        this.tableName = tableName;
        this.schemaName = schemaName;
        this.catalogName = catalogName;
    }

    public static DatabendColumnInfo of(String name, DatabendRawType type) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "Provided name is null or empty");
        return DatabendColumnInfo.newBuilder(name, type).build();
    }

    public static void setTypeInfo(Builder builder, DatabendRawType type) {
        builder.setColumnType(DatabendColumnInfo.getType(type));
        boolean isNullable = type.isNullable();
        builder.setNullable(isNullable ? Nullable.NULLABLE : Nullable.NO_NULLS);
        switch (type.getType()) {
            case "boolean": {
                builder.setColumnDisplaySize(5);
                break;
            }
            case "uint8": {
                builder.setSigned(false);
                builder.setPrecision(3);
                builder.setColumnDisplaySize(4);
                builder.setScale(0);
                break;
            }
            case "int8": {
                builder.setSigned(true);
                builder.setPrecision(4);
                builder.setColumnDisplaySize(5);
                builder.setScale(0);
                break;
            }
            case "uint16": {
                builder.setSigned(false);
                builder.setPrecision(5);
                builder.setColumnDisplaySize(6);
                builder.setScale(0);
                break;
            }
            case "int16": {
                builder.setSigned(true);
                builder.setPrecision(5);
                builder.setColumnDisplaySize(6);
                builder.setScale(0);
                break;
            }
            case "uint32": {
                builder.setSigned(false);
                builder.setPrecision(10);
                builder.setColumnDisplaySize(11);
                builder.setScale(0);
                break;
            }
            case "int32": {
                builder.setSigned(true);
                builder.setPrecision(10);
                builder.setColumnDisplaySize(11);
                builder.setScale(0);
                break;
            }
            case "uint64": {
                builder.setSigned(false);
                builder.setPrecision(19);
                builder.setColumnDisplaySize(20);
                builder.setScale(0);
                break;
            }
            case "int64": {
                builder.setSigned(true);
                builder.setPrecision(19);
                builder.setColumnDisplaySize(20);
                builder.setScale(0);
                break;
            }
            case "float32": {
                builder.setSigned(true);
                builder.setPrecision(9);
                builder.setColumnDisplaySize(16);
                builder.setScale(0);
                break;
            }
            case "float64": {
                builder.setSigned(true);
                builder.setPrecision(17);
                builder.setColumnDisplaySize(24);
                builder.setScale(0);
                break;
            }
            case "string": {
                builder.setSigned(false);
                builder.setScale(0);
                builder.setPrecision(0x40000000);
                builder.setColumnDisplaySize(0x40000000);
                break;
            }
            case "date": {
                builder.setSigned(false);
                builder.setScale(0);
                builder.setPrecision(DATE_MAX);
                builder.setColumnDisplaySize(DATE_MAX);
                break;
            }
            case "datetime": {
                builder.setSigned(false);
                builder.setScale(0);
                builder.setPrecision(TIMESTAMP_MAX);
                builder.setColumnDisplaySize(TIMESTAMP_MAX);
                break;
            }
            case "datetime64": {
                builder.setSigned(false);
                builder.setScale(0);
                builder.setPrecision(TIMESTAMP_MAX);
                builder.setColumnDisplaySize(TIMESTAMP_MAX);
            }
        }
    }

    public static Builder newBuilder(String name, DatabendRawType type) {
        return new Builder().setColumnName(name).setColumnType(DatabendColumnInfo.getType(type));
    }

    private static int getType(DatabendRawType type) {
        if (type == null) {
            return 0;
        }
        switch (type.getType().toLowerCase(Locale.US)) {
            case "boolean": {
                return 16;
            }
            case "uint8": {
                return -6;
            }
            case "int8": {
                return -6;
            }
            case "uint16": {
                return 5;
            }
            case "int16": {
                return 5;
            }
            case "uint32": {
                return 4;
            }
            case "int32": {
                return 4;
            }
            case "uint64": {
                return -5;
            }
            case "int64": {
                return -5;
            }
            case "float32": {
                return 7;
            }
            case "float64": {
                return 8;
            }
            case "string": {
                return 12;
            }
            case "date": {
                return 91;
            }
            case "datetime": {
                return 93;
            }
            case "datetime64": {
                return 93;
            }
            case "timestamp": {
                return 93;
            }
            case "array": {
                return 2003;
            }
        }
        return 2000;
    }

    public int getColumnType() {
        return this.columnType;
    }

    public List<Integer> getColumnParameterTypes() {
        return this.columnParameterTypes;
    }

    public DatabendRawType getType() {
        return this.type;
    }

    public Nullable getNullable() {
        return this.nullable;
    }

    public String getColumnTypeName() {
        return this.type.toString();
    }

    public boolean isCurrency() {
        return this.currency;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public int getColumnDisplaySize() {
        return this.columnDisplaySize;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public static enum Nullable {
        NO_NULLS,
        NULLABLE,
        UNKNOWN;

    }

    public static final class Builder {
        private int columnType;
        private List<Integer> columnParameterTypes;
        private DatabendRawType type;
        private Nullable nullable;
        private boolean currency;
        private boolean signed;
        private int precision;
        private int scale;
        private int columnDisplaySize;
        private String columnLabel;
        private String columnName;
        private String tableName;
        private String schemaName;
        private String catalogName;

        Builder() {
        }

        private Builder(DatabendColumnInfo databendColumnInfo) {
            this.columnName = databendColumnInfo.columnName;
            this.columnType = databendColumnInfo.columnType;
            this.columnLabel = databendColumnInfo.columnLabel;
            this.type = databendColumnInfo.type;
            this.columnDisplaySize = databendColumnInfo.columnDisplaySize;
            this.tableName = databendColumnInfo.tableName;
            this.schemaName = databendColumnInfo.schemaName;
            this.catalogName = databendColumnInfo.catalogName;
            this.scale = databendColumnInfo.scale;
            this.columnParameterTypes = databendColumnInfo.columnParameterTypes;
            this.signed = databendColumnInfo.signed;
            this.currency = databendColumnInfo.currency;
            this.nullable = databendColumnInfo.nullable;
        }

        public Builder setColumnType(int columnType) {
            this.columnType = columnType;
            return this;
        }

        public void setColumnParameterTypes(List<Integer> columnParameterTypes) {
            this.columnParameterTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnParameterTypes, "columnParameterTypes is null"));
        }

        public Builder setColumnTypeSignature(DatabendRawType columnTypeSignature) {
            this.type = columnTypeSignature;
            return this;
        }

        public Builder setNullable(Nullable nullable) {
            this.nullable = nullable;
            return this;
        }

        public Builder setCurrency(boolean currency) {
            this.currency = currency;
            return this;
        }

        public Builder setSigned(boolean signed) {
            this.signed = signed;
            return this;
        }

        public Builder setPrecision(int precision) {
            this.precision = precision;
            return this;
        }

        public Builder setScale(int scale) {
            this.scale = scale;
            return this;
        }

        public Builder setColumnDisplaySize(int columnDisplaySize) {
            this.columnDisplaySize = columnDisplaySize;
            return this;
        }

        public Builder setColumnLabel(String columnLabel) {
            this.columnLabel = columnLabel;
            return this;
        }

        public Builder setColumnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setSchemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder setCatalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public DatabendColumnInfo build() {
            return new DatabendColumnInfo(this.columnType, this.columnParameterTypes, this.type, this.nullable, this.currency, this.signed, this.precision, this.scale, this.columnDisplaySize, this.columnLabel, this.columnName, this.tableName, this.schemaName, this.catalogName);
        }
    }
}

