/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client.data;

import com.databend.client.data.ColumnTypeHandler;

class BooleanHandler
implements ColumnTypeHandler {
    private boolean isNullable;
    private static final String TRUE_NUM = "1";
    private static final String TRUE_STRING = "true";

    public BooleanHandler() {
        this.isNullable = false;
    }

    public BooleanHandler(boolean isNullable) {
        this.isNullable = isNullable;
    }

    @Override
    public Object parseValue(Object value) {
        if (this.isNullable) {
            return this.parseNullableValue(value);
        }
        return this.parseNonNullValue(value);
    }

    private Boolean parseNullableValue(Object value) {
        if (value == null || value.equals("NULL")) {
            return null;
        }
        if (value instanceof String) {
            return TRUE_NUM.equals(value) || TRUE_STRING.equals(value);
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        return null;
    }

    private boolean parseNonNullValue(Object value) {
        if (value == null || value.equals("NULL")) {
            throw new IllegalArgumentException("Boolean type is not nullable");
        }
        if (value instanceof String) {
            return TRUE_NUM.equals(value) || TRUE_STRING.equals(value);
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        return false;
    }

    @Override
    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }
}

