/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client.data;

import com.databend.client.data.ColumnTypeHandler;

class Float32Handler
implements ColumnTypeHandler {
    private boolean isNullable;

    public Float32Handler() {
        this.isNullable = false;
    }

    public Float32Handler(boolean isNullable) {
        this.isNullable = isNullable;
    }

    @Override
    public Object parseValue(Object value) {
        if (this.isNullable) {
            return this.parseNullableValue(value);
        }
        return Float.valueOf(this.parseNonNullValue(value));
    }

    private Float parseNullableValue(Object value) {
        if (value == null || value.equals("NULL")) {
            return null;
        }
        if (value instanceof String) {
            return Float.valueOf(Float.parseFloat((String)value));
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        return null;
    }

    private float parseNonNullValue(Object value) {
        if (value == null || value.equals("NULL")) {
            throw new IllegalArgumentException("Float32 type is not nullable");
        }
        if (value instanceof String) {
            return Float.parseFloat((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        return 0.0f;
    }

    @Override
    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }
}

