/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc;

import com.databend.client.OkHttpUtils;
import com.databend.jdbc.ConnectionProperties;
import com.google.shaded.common.base.MoreObjects;
import com.google.shaded.common.base.Splitter;
import com.google.shaded.common.base.Strings;
import com.google.shaded.common.collect.ImmutableMap;
import com.google.shaded.common.collect.Maps;
import com.google.shaded.common.net.HostAndPort;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public final class DatabendDriverUri {
    private static final String JDBC_URL_PREFIX = "jdbc:";
    private static final String JDBC_URL_START = "jdbc:databend://";
    private static final Splitter QUERY_SPLITTER = Splitter.on('&').omitEmptyStrings();
    private static final Splitter ARG_SPLITTER = Splitter.on('=').limit(2);
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final int DEFAULT_HTTP_PORT = 8000;
    private final HostAndPort address;
    private final Properties properties;
    private final URI uri;
    private final boolean useSecureConnection;
    private final boolean strNullAsNull;
    private final String warehouse;
    private final String sslmode;
    private final String tenant;
    private final boolean copyPurge;
    private final String nullDisplay;
    private final String binaryFormat;
    private final String database;
    private final boolean presignedUrlDisabled;
    private final Integer connectionTimeout;
    private final Integer queryTimeout;
    private final Integer socketTimeout;
    private final Integer waitTimeSecs;
    private final Integer maxRowsInBuffer;
    private final Integer maxRowsPerPage;

    private DatabendDriverUri(String url, Properties driverProperties) throws SQLException {
        Map.Entry<URI, Map<String, String>> uriAndProperties = DatabendDriverUri.parse(url);
        this.properties = DatabendDriverUri.mergeProperties(uriAndProperties.getKey(), uriAndProperties.getValue(), driverProperties);
        this.useSecureConnection = ConnectionProperties.SSL.getValue(this.properties).orElse(false);
        this.strNullAsNull = ConnectionProperties.STRNULL_AS_NULL.getValue(this.properties).orElse(true);
        this.warehouse = ConnectionProperties.WAREHOUSE.getValue(this.properties).orElse("");
        this.sslmode = ConnectionProperties.SSL_MODE.getValue(this.properties).orElse("disable");
        this.tenant = ConnectionProperties.TENANT.getValue(this.properties).orElse("");
        this.uri = DatabendDriverUri.parseFinalURI(uriAndProperties.getKey(), this.useSecureConnection, this.sslmode);
        this.address = HostAndPort.fromParts(this.uri.getHost(), this.uri.getPort());
        this.database = ConnectionProperties.DATABASE.getValue(this.properties).orElse("default");
        this.presignedUrlDisabled = ConnectionProperties.PRESIGNED_URL_DISABLED.getRequiredValue(this.properties);
        this.copyPurge = ConnectionProperties.COPY_PURGE.getValue(this.properties).orElse(true);
        this.nullDisplay = ConnectionProperties.NULL_DISPLAY.getValue(this.properties).orElse("\\N");
        this.binaryFormat = ConnectionProperties.BINARY_FORMAT.getValue(this.properties).orElse("");
        this.waitTimeSecs = ConnectionProperties.WAIT_TIME_SECS.getRequiredValue(this.properties);
        this.connectionTimeout = ConnectionProperties.CONNECTION_TIMEOUT.getRequiredValue(this.properties);
        this.queryTimeout = ConnectionProperties.QUERY_TIMEOUT.getRequiredValue(this.properties);
        this.socketTimeout = ConnectionProperties.SOCKET_TIMEOUT.getRequiredValue(this.properties);
        this.maxRowsInBuffer = ConnectionProperties.MAX_ROWS_IN_BUFFER.getRequiredValue(this.properties);
        this.maxRowsPerPage = ConnectionProperties.MAX_ROWS_PER_PAGE.getRequiredValue(this.properties);
    }

    public static DatabendDriverUri create(String url, Properties properties) throws SQLException {
        return new DatabendDriverUri(url, MoreObjects.firstNonNull(properties, new Properties()));
    }

    private static void initDatabase(URI uri, Map<String, String> uriProperties) throws SQLException {
        String path = uri.getPath();
        if (Strings.isNullOrEmpty(path) || "/".equals(path)) {
            return;
        }
        if (!path.startsWith("/")) {
            throw new SQLException(String.format("Invalid database name '%s'", path));
        }
        String db = path.substring(1);
        uriProperties.put(ConnectionProperties.DATABASE.getKey(), db);
    }

    private static URI parseFinalURI(URI uri, boolean isSSLSecured, String sslmode) throws SQLException {
        Objects.requireNonNull(uri, "uri is null");
        String authority = uri.getAuthority();
        String scheme = isSSLSecured || sslmode.equals("enable") ? "https" : "http";
        int finalPort = -1;
        try {
            HostAndPort hostAndPort = HostAndPort.fromString(authority);
            if (hostAndPort.hasPort()) {
                finalPort = hostAndPort.getPort();
                return new URI(scheme, uri.getUserInfo(), uri.getHost(), finalPort, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
        }
        catch (Exception hostAndPort) {
            // empty catch block
        }
        if (finalPort == -1) {
            finalPort = isSSLSecured ? 443 : 8000;
        }
        try {
            return new URI(scheme, uri.getUserInfo(), uri.getHost(), finalPort, uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new SQLException("Invalid URI: " + uri, e);
        }
    }

    private static String tryParseUriUserPassword(String url, Map<String, String> properties) {
        int atPos = url.lastIndexOf(64);
        if (atPos > 0) {
            String userPass = url.substring(0, atPos);
            int colonPos = userPass.indexOf(58);
            if (colonPos > 0) {
                String user = userPass.substring(0, colonPos);
                String pass = userPass.substring(colonPos + 1);
                properties.put(ConnectionProperties.USER.getKey(), user);
                properties.put(ConnectionProperties.PASSWORD.getKey(), pass);
            } else {
                properties.put(ConnectionProperties.USER.getKey(), userPass);
            }
            url = url.substring(atPos + 1);
        }
        return url;
    }

    private static void setProperties(Properties properties, Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            properties.setProperty(entry.getKey().toLowerCase(Locale.US), entry.getValue());
        }
    }

    private static Properties mergeProperties(URI uri, Map<String, String> uriProperties, Properties driverProperties) throws SQLException {
        Map<String, String> defaults = ConnectionProperties.getDefaults();
        Map<String, String> urlProperties = DatabendDriverUri.parseParameters(uri.getQuery());
        ImmutableMap<String, String> suppliedProperties = Maps.fromProperties(driverProperties);
        Properties result = new Properties();
        DatabendDriverUri.setProperties(result, defaults);
        DatabendDriverUri.setProperties(result, uriProperties);
        DatabendDriverUri.setProperties(result, urlProperties);
        DatabendDriverUri.setProperties(result, suppliedProperties);
        return result;
    }

    private static Map.Entry<URI, Map<String, String>> parse(String url) throws SQLException {
        if (url == null) {
            throw new SQLException("URL is null");
        }
        int pos = url.indexOf(JDBC_URL_START);
        if (pos != 0) {
            throw new SQLException("Invalid JDBC URL: " + url + " URL does not start with " + JDBC_URL_START);
        }
        LinkedHashMap<String, String> uriProperties = new LinkedHashMap<String, String>();
        String raw = url.substring(pos + JDBC_URL_START.length());
        String host = null;
        int port = -1;
        if ((raw = DatabendDriverUri.tryParseUriUserPassword(raw, uriProperties)).startsWith("https://")) {
            uriProperties.put(ConnectionProperties.SSL.getKey(), "true");
            uriProperties.put(ConnectionProperties.SSL_MODE.getKey(), "enable");
        } else if (raw.startsWith("http://")) {
            uriProperties.put(ConnectionProperties.SSL.getKey(), "false");
            uriProperties.put(ConnectionProperties.SSL_MODE.getKey(), "disable");
        } else {
            raw = "http://" + raw;
            uriProperties.put(ConnectionProperties.SSL.getKey(), "false");
            uriProperties.put(ConnectionProperties.SSL_MODE.getKey(), "disable");
        }
        try {
            URI uri = new URI(raw);
            String authority = uri.getAuthority();
            String[] hostAndPort = authority.split(":");
            if (hostAndPort.length == 2) {
                host = hostAndPort[0];
                port = Integer.parseInt(hostAndPort[1]);
            } else if (hostAndPort.length == 1) {
                host = hostAndPort[0];
            } else {
                throw new SQLException("Invalid host and port, url: " + url);
            }
            if (host == null || host.isEmpty()) {
                throw new SQLException("Invalid host " + host);
            }
            DatabendDriverUri.initDatabase(uri, uriProperties);
            return new AbstractMap.SimpleImmutableEntry<URI, Map<String, String>>(uri, uriProperties);
        }
        catch (URISyntaxException e) {
            throw new SQLException("Invalid URI: " + raw, e);
        }
    }

    public static boolean acceptsURL(String url) {
        return url.startsWith(JDBC_URL_START);
    }

    private static Map<String, String> parseParameters(String query) throws SQLException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (query != null) {
            Iterable<String> queryArgs = QUERY_SPLITTER.split(query);
            for (String queryArg : queryArgs) {
                List<String> parts = ARG_SPLITTER.splitToList(queryArg);
                if (parts.size() != 2) {
                    throw new SQLException(String.format("Connection argument is not valid connection property: '%s'", queryArg));
                }
                if (result.put(parts.get(0), parts.get(1)) == null) continue;
                throw new SQLException(String.format("Connection property '%s' is in URL multiple times", parts.get(0)));
            }
        }
        return result;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getDatabase() {
        return this.database;
    }

    public Boolean presignedUrlDisabled() {
        return this.presignedUrlDisabled;
    }

    public Boolean copyPurge() {
        return this.copyPurge;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public boolean getStrNullAsNull() {
        return this.strNullAsNull;
    }

    public String getSslmode() {
        return this.sslmode;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String nullDisplay() {
        return this.nullDisplay;
    }

    public String binaryFormat() {
        return this.binaryFormat;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public Integer getWaitTimeSecs() {
        return this.waitTimeSecs;
    }

    public Integer getMaxRowsInBuffer() {
        return this.maxRowsInBuffer;
    }

    public Integer getMaxRowsPerPage() {
        return this.maxRowsPerPage;
    }

    public HostAndPort getAddress() {
        return this.address;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setupClient(OkHttpClient.Builder builder) throws SQLException {
        try {
            String password = ConnectionProperties.PASSWORD.getValue(this.properties).orElse("");
            if (!password.isEmpty()) {
                builder.addInterceptor(OkHttpUtils.basicAuthInterceptor(ConnectionProperties.USER.getValue(this.properties).orElse(""), password));
            }
            if (this.useSecureConnection || this.sslmode.equals("enable")) {
                OkHttpUtils.setupInsecureSsl(builder);
            }
            if (ConnectionProperties.ACCESS_TOKEN.getValue(this.properties).isPresent()) {
                builder.addInterceptor(OkHttpUtils.tokenAuth(ConnectionProperties.ACCESS_TOKEN.getValue(this.properties).get()));
            }
            if (ConnectionProperties.CONNECTION_TIMEOUT.getValue(this.properties).isPresent()) {
                builder.connectTimeout(ConnectionProperties.CONNECTION_TIMEOUT.getValue(this.properties).get().intValue(), TimeUnit.SECONDS);
            }
            if (ConnectionProperties.SOCKET_TIMEOUT.getValue(this.properties).isPresent()) {
                builder.readTimeout(ConnectionProperties.SOCKET_TIMEOUT.getValue(this.properties).get().intValue(), TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            throw new SQLException("Failed to setup client", e);
        }
    }
}

