/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc;

import com.databend.client.OkHttpUtils;
import com.databend.jdbc.ConnectionProperties;
import com.databend.jdbc.DatabendConnection;
import com.databend.jdbc.DatabendDriverUri;
import com.databend.jdbc.DriverInfo;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;

public class NonRegisteringDatabendDriver
implements Driver,
Closeable {
    private final OkHttpClient httpClient = NonRegisteringDatabendDriver.newHttpClient();

    private static Properties urlProperties(String url, Properties info) {
        try {
            return DatabendDriverUri.create(url, info).getProperties();
        }
        catch (SQLException e) {
            return info;
        }
    }

    private static OkHttpClient newHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().addInterceptor(OkHttpUtils.userAgentInterceptor(DriverInfo.DRIVER_NAME + "/" + DriverInfo.DRIVER_VERSION));
        return builder.build();
    }

    @Override
    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException("URL is null");
        }
        return DatabendDriverUri.acceptsURL(url);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        DatabendDriverUri uri = DatabendDriverUri.create(url, info);
        OkHttpClient.Builder builder = this.httpClient.newBuilder();
        uri.setupClient(builder);
        DatabendConnection connection = new DatabendConnection(uri, builder.build());
        try {
            connection.PingDatabendClientV1();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new DatabendConnection(uri, builder.build());
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Properties properties = NonRegisteringDatabendDriver.urlProperties(url, info);
        return (DriverPropertyInfo[])ConnectionProperties.allProperties().stream().filter(property -> property.isAllowed(properties)).map(property -> property.getDriverPropertyInfo(properties)).toArray(DriverPropertyInfo[]::new);
    }

    @Override
    public int getMajorVersion() {
        return DriverInfo.DRIVER_VERSION_MAJOR;
    }

    @Override
    public int getMinorVersion() {
        return DriverInfo.DRIVER_VERSION_MINOR;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

