/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client;

import com.databend.client.ClientSettings;
import com.databend.client.DatabendClient;
import com.databend.client.DatabendSession;
import com.databend.client.DiscoveryNode;
import com.databend.client.DiscoveryResponseCodec;
import com.databend.client.JsonCodec;
import com.databend.client.JsonResponse;
import com.databend.client.PaginationOptions;
import com.databend.client.QueryRequest;
import com.databend.client.QueryResults;
import com.databend.client.errors.CloudErrors;
import com.google.shaded.common.base.MoreObjects;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.annotation.concurrent.ThreadSafe;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;

@ThreadSafe
public class DatabendClientV1
implements DatabendClient {
    private final AtomicReference<Boolean> finished = new AtomicReference<Boolean>(false);
    public static final String USER_AGENT_VALUE = DatabendClientV1.class.getSimpleName() + "/" + MoreObjects.firstNonNull(DatabendClientV1.class.getPackage().getImplementationVersion(), "jvm-unknown");
    public static final MediaType MEDIA_TYPE_JSON = MediaType.parse("application/json; charset=utf-8");
    public static final JsonCodec<QueryResults> QUERY_RESULTS_CODEC = JsonCodec.jsonCodec(QueryResults.class);
    public static final JsonCodec<DiscoveryResponseCodec.DiscoveryResponse> DISCOVERY_RESULT_CODEC = JsonCodec.jsonCodec(DiscoveryResponseCodec.DiscoveryResponse.class);
    public static final String succeededState = "succeeded";
    public static final String failedState = "failed";
    public static final String runningState = "running";
    public static final String QUERY_PATH = "/v1/query";
    public static final String DISCOVERY_PATH = "/v1/discovery_nodes";
    private static final long MAX_MATERIALIZED_JSON_RESPONSE_SIZE = 131072L;
    private final OkHttpClient httpClient;
    private final String query;
    private final String host;
    private final int maxRetryAttempts;
    private final PaginationOptions paginationOptions;
    private final Integer requestTimeoutSecs;
    private final Map<String, String> additonalHeaders;
    private final AtomicReference<DatabendSession> databendSession;
    private final AtomicReference<QueryResults> currentResults = new AtomicReference<Object>(null);
    private static final Logger logger = Logger.getLogger(DatabendClientV1.class.getPackage().getName());
    private Consumer<DatabendSession> on_session_state_update;

    public DatabendClientV1(OkHttpClient httpClient, String sql, ClientSettings settings2, Consumer<DatabendSession> on_session_state_update) {
        Objects.requireNonNull(httpClient, "httpClient is null");
        Objects.requireNonNull(sql, "sql is null");
        Objects.requireNonNull(settings2, "settings is null");
        Objects.requireNonNull(settings2.getHost(), "settings.host is null");
        this.httpClient = httpClient;
        this.query = sql;
        this.on_session_state_update = on_session_state_update;
        this.host = settings2.getHost();
        this.paginationOptions = settings2.getPaginationOptions();
        this.requestTimeoutSecs = settings2.getQueryTimeoutSecs();
        this.additonalHeaders = settings2.getAdditionalHeaders();
        this.maxRetryAttempts = settings2.getRetryAttempts();
        this.databendSession = new AtomicReference<DatabendSession>(settings2.getSession());
        Request request = this.buildQueryRequest(this.query, settings2);
        boolean completed = this.execute(request);
        if (!completed) {
            throw new RuntimeException("Query failed to complete");
        }
    }

    public static List<DiscoveryNode> discoverNodes(OkHttpClient httpClient, ClientSettings settings2) {
        Objects.requireNonNull(httpClient, "httpClient is null");
        Objects.requireNonNull(settings2, "settings is null");
        Objects.requireNonNull(settings2.getHost(), "settings.host is null");
        Request request = DatabendClientV1.buildDiscoveryRequest(settings2);
        DiscoveryResponseCodec.DiscoveryResponse response = DatabendClientV1.getDiscoveryResponse(httpClient, request, OptionalLong.empty(), settings2.getQueryTimeoutSecs());
        return response.getNodes();
    }

    public static Request.Builder prepareRequest(HttpUrl url, Map<String, String> additionalHeaders) {
        Request.Builder builder = new Request.Builder().url(url).header("User-Agent", USER_AGENT_VALUE).header("Accept", "application/json").header("Content-Type", "application/json");
        if (additionalHeaders != null) {
            additionalHeaders.forEach(builder::addHeader);
        }
        return builder;
    }

    private Request buildQueryRequest(String query, ClientSettings settings2) {
        HttpUrl url = HttpUrl.get(settings2.getHost());
        if (url == null) {
            throw new IllegalArgumentException("Invalid host: " + settings2.getHost());
        }
        QueryRequest req = QueryRequest.builder().setSession(settings2.getSession()).setStageAttachment(settings2.getStageAttachment()).setPaginationOptions(settings2.getPaginationOptions()).setSql(query).build();
        String reqString = req.toString();
        if (reqString == null || reqString.isEmpty()) {
            throw new IllegalArgumentException("Invalid request: " + req);
        }
        url = url.newBuilder().encodedPath(QUERY_PATH).build();
        Request.Builder builder = DatabendClientV1.prepareRequest(url, this.additonalHeaders);
        return builder.post(RequestBody.create(MEDIA_TYPE_JSON, reqString)).build();
    }

    private static Request buildDiscoveryRequest(ClientSettings settings2) {
        HttpUrl url = HttpUrl.get(settings2.getHost());
        if (url == null) {
            throw new IllegalArgumentException("Invalid host: " + settings2.getHost());
        }
        String discoveryPath = DISCOVERY_PATH;
        if (settings2.getAdditionalHeaders().get("~mock.unsupported.discovery") != null && settings2.getAdditionalHeaders().get("~mock.unsupported.discovery").equals("true")) {
            discoveryPath = "/v1/discovery_nodes_unsupported";
        }
        url = url.newBuilder().encodedPath(discoveryPath).build();
        Request.Builder builder = DatabendClientV1.prepareRequest(url, settings2.getAdditionalHeaders());
        return builder.get().build();
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    private static DiscoveryResponseCodec.DiscoveryResponse getDiscoveryResponse(OkHttpClient httpClient, Request request, OptionalLong materializedJsonSizeLimit, int requestTimeoutSecs) {
        JsonResponse<DiscoveryResponseCodec.DiscoveryResponse> response;
        Objects.requireNonNull(request, "request is null");
        long start = System.nanoTime();
        int attempts = 0;
        RuntimeException lastException = null;
        while (true) {
            CloudErrors errors;
            if (attempts > 0) {
                Duration sinceStart = Duration.ofNanos(System.nanoTime() - start);
                if (sinceStart.compareTo(Duration.ofSeconds(requestTimeoutSecs)) > 0) {
                    throw new RuntimeException(String.format("Error fetching discovery nodes (attempts: %s, duration: %s)", attempts, sinceStart.getSeconds()), lastException);
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(attempts * 100);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Interrupted while fetching discovery nodes", e);
                }
            }
            ++attempts;
            try {
                response = JsonResponse.execute(DISCOVERY_RESULT_CODEC, httpClient, request, materializedJsonSizeLimit);
            }
            catch (RuntimeException e) {
                lastException = e;
                if (e.getCause() instanceof ConnectException) continue;
                throw new RuntimeException("Failed to fetch discovery nodes: " + e.getMessage(), e);
            }
            if (response.getStatusCode() == 200 && response.hasValue()) {
                DiscoveryResponseCodec.DiscoveryResponse discoveryResponse = response.getValue();
                if (discoveryResponse.getError() == null) {
                    return discoveryResponse;
                }
                if (discoveryResponse.getError().notFound()) {
                    throw new UnsupportedOperationException("Discovery request feature not supported: " + discoveryResponse.getError());
                }
                throw new RuntimeException("Discovery request failed: " + discoveryResponse.getError());
            }
            if (response.getStatusCode() == 404) {
                throw new UnsupportedOperationException("Discovery request feature not supported");
            }
            if (!(response.getResponseBody().isPresent() && (errors = CloudErrors.tryParse(response.getResponseBody().get())) != null && errors.tryGetErrorKind().canRetry() || response.getStatusCode() == 520)) break;
        }
        throw new RuntimeException("Discovery request failed with status code: " + response.getStatusCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeInternal(Request request, OptionalLong materializedJsonSizeLimit) {
        JsonResponse<QueryResults> response;
        block14: {
            CloudErrors errors;
            Objects.requireNonNull(request, "request is null");
            long start = System.nanoTime();
            long attempts = 0L;
            Throwable cause = null;
            do {
                if (attempts > 0L) {
                    Duration sinceStart = Duration.ofNanos(System.nanoTime() - start);
                    if (sinceStart.compareTo(Duration.ofSeconds(this.requestTimeoutSecs.intValue())) > 0) {
                        throw new RuntimeException(String.format("Error fetching next (attempts: %s, duration: %s)", attempts, sinceStart.getSeconds()), cause);
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(attempts * 100L);
                    }
                    catch (InterruptedException e) {
                        try {
                            this.close();
                        }
                        finally {
                            Thread.currentThread().interrupt();
                        }
                        throw new RuntimeException("StatementClient thread was interrupted");
                    }
                }
                ++attempts;
                try {
                    response = JsonResponse.execute(QUERY_RESULTS_CODEC, this.httpClient, request, materializedJsonSizeLimit);
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof ConnectException) {
                        throw e;
                    }
                    throw new RuntimeException("Query failed: " + e.getMessage(), e);
                }
                if (response.getStatusCode() == 200 && response.hasValue() && response.getValue().getError() == null) {
                    this.processResponse(response.getHeaders(), response.getValue());
                    return true;
                }
                if (!response.getResponseBody().isPresent() || (errors = CloudErrors.tryParse(response.getResponseBody().get())) == null) break block14;
            } while (errors.tryGetErrorKind().canRetry());
            throw new RuntimeException(String.valueOf(response.getValue().getError()));
        }
        if (response.getStatusCode() != 520) {
            throw new RuntimeException("Query failed: " + response.getValue().getError());
        }
        return false;
    }

    private String requestBodyToString(Request request) {
        try {
            Request copy = request.newBuilder().build();
            Buffer buffer = new Buffer();
            if (copy.body() != null) {
                copy.body().writeTo(buffer);
            }
            return buffer.readUtf8();
        }
        catch (IOException e) {
            return "did not work";
        }
    }

    @Override
    public boolean execute(Request request) {
        return this.executeInternal(request, OptionalLong.empty());
    }

    private void processResponse(Headers headers2, QueryResults results) {
        DatabendSession session = results.getSession();
        if (session != null) {
            this.databendSession.set(session);
            if (this.on_session_state_update != null) {
                this.on_session_state_update.accept(session);
            }
        }
        if (results.getQueryId() != null && this.additonalHeaders.get("X-DATABEND-QUERY-ID") == null) {
            this.additonalHeaders.put("X-DATABEND-QUERY-ID", results.getQueryId());
        }
        if (headers2 != null && headers2.get("X-DATABEND-ROUTE-HINT") != null) {
            this.additonalHeaders.put("X-DATABEND-ROUTE-HINT", headers2.get("X-DATABEND-ROUTE-HINT"));
        }
        this.currentResults.set(results);
    }

    @Override
    public boolean advance() {
        Objects.requireNonNull(this.host, "host is null");
        Objects.requireNonNull(this.currentResults.get(), "currentResults is null");
        if (this.finished.get().booleanValue()) {
            return false;
        }
        if (!this.currentResults.get().hasMoreData()) {
            this.closeQuery();
            return false;
        }
        String nextUriPath = this.currentResults.get().getNextUri().toString();
        HttpUrl url = HttpUrl.get(this.host);
        url = url.newBuilder().encodedPath(nextUriPath).build();
        Request.Builder builder = DatabendClientV1.prepareRequest(url, this.additonalHeaders);
        Request request = builder.get().build();
        return this.executeInternal(request, OptionalLong.of(131072L));
    }

    @Override
    public boolean hasNext() {
        return this.finished.get() == false;
    }

    @Override
    public Map<String, String> getAdditionalHeaders() {
        return this.additonalHeaders;
    }

    @Override
    public QueryResults getResults() {
        return this.currentResults.get();
    }

    @Override
    public DatabendSession getSession() {
        return this.databendSession.get();
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void close() {
        this.closeQuery();
    }

    private void closeQuery() {
        if (!this.finished.compareAndSet(false, true)) {
            return;
        }
        QueryResults q = this.currentResults.get();
        if (q == null) {
            return;
        }
        URI uri = q.getFinalUri();
        if (uri == null) {
            return;
        }
        String path = uri.toString();
        HttpUrl url = HttpUrl.get(this.host);
        url = url.newBuilder().encodedPath(path).build();
        Request r = DatabendClientV1.prepareRequest(url, this.additonalHeaders).get().build();
        try {
            this.httpClient.newCall(r).execute().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

