/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client.data;

import com.databend.client.data.DatabendRawType;
import com.google.shaded.common.base.MoreObjects;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum DatabendDataType {
    BOOLEAN(16, "boolean", false, 1, false, "Boolean", "BOOL"),
    INT_8(-6, "int8", true, 3, false, "Int8", "TINYINT"),
    UNSIGNED_INT_8(-6, "uint8", false, 3, false, "UInt8", "TINYINT UNSIGNED"),
    INT_16(5, "int16", true, 5, false, "Int16", "SMALLINT"),
    UNSIGNED_INT_16(5, "uint16", false, 5, false, "UInt16", "SMALLINT UNSIGNED"),
    INT_32(4, "int32", true, 10, false, "Int32", "INTEGER"),
    UNSIGNED_INT_32(4, "uint32", false, 10, false, "UInt32", "INTEGER UNSIGNED"),
    INT_64(-5, "int64", true, 19, false, "Int64", "BIGINT"),
    UNSIGNED_INT_64(-5, "uint64", false, 20, false, "UInt64", "BIGINT UNSIGNED"),
    DOUBLE(8, "float64", true, 22, false, "Float64", "DOUBLE"),
    FLOAT(6, "float32", true, 12, false, "Float32", "FLOAT"),
    DECIMAL(3, "decimal", true, 65, false, "Decimal"),
    STRING(12, "string", false, Integer.MAX_VALUE, false, "String", "VARCHAR"),
    DATE(91, "date", false, 10, true, "Date"),
    TIMESTAMP(93, "timestamp", false, 26, true, "DateTime", "TIMESTAMP"),
    ARRAY(2003, "array", false, 0, false, "Array"),
    MAP(1111, "map", false, 0, false, "Map"),
    BITMAP(1111, "map", false, 0, false, "Bitmap"),
    TUPLE(1111, "tuple", false, 0, false, "Tuple"),
    VARIANT(12, "variant", false, 0, false, "Variant", "Json"),
    BINARY(-2, "binary", false, 0, false, "Binary"),
    GEOMETRY(1111, "geometry", false, 0, false, "Geometry"),
    NULL(0, "null", false, 0, false, "NULL");

    private static final Map<String, DatabendDataType> typeNameOrAliasToType;
    private final int sqlType;
    private final String displayName;
    private final boolean signed;
    private final int length;
    private final boolean time;
    private final String[] aliases;

    public static DatabendDataType getByTypeName(String typeName) {
        if ("boolean".equalsIgnoreCase(typeName)) {
            return BOOLEAN;
        }
        if ("int8".equalsIgnoreCase(typeName)) {
            return INT_8;
        }
        if ("uint8".equalsIgnoreCase(typeName)) {
            return UNSIGNED_INT_8;
        }
        if ("int16".equalsIgnoreCase(typeName)) {
            return INT_16;
        }
        if ("uint16".equalsIgnoreCase(typeName)) {
            return UNSIGNED_INT_16;
        }
        if ("int32".equalsIgnoreCase(typeName) || "int".equalsIgnoreCase(typeName)) {
            return INT_32;
        }
        if ("uint32".equalsIgnoreCase(typeName)) {
            return UNSIGNED_INT_32;
        }
        if ("int64".equalsIgnoreCase(typeName)) {
            return INT_64;
        }
        if ("uint64".equalsIgnoreCase(typeName)) {
            return UNSIGNED_INT_64;
        }
        if ("float32".equalsIgnoreCase(typeName)) {
            return FLOAT;
        }
        if ("float64".equalsIgnoreCase(typeName)) {
            return DOUBLE;
        }
        if ("date".equalsIgnoreCase(typeName)) {
            return DATE;
        }
        if ("timestamp".equalsIgnoreCase(typeName)) {
            return TIMESTAMP;
        }
        if ("variant".equalsIgnoreCase(typeName)) {
            return VARIANT;
        }
        if ("bitmap".equalsIgnoreCase(typeName)) {
            return BITMAP;
        }
        if (DatabendRawType.startsWithIgnoreCase(typeName, "decimal")) {
            return DECIMAL;
        }
        if (DatabendRawType.startsWithIgnoreCase(typeName, "string")) {
            return STRING;
        }
        if (DatabendRawType.startsWithIgnoreCase(typeName, "array")) {
            return ARRAY;
        }
        if (DatabendRawType.startsWithIgnoreCase(typeName, "map")) {
            return MAP;
        }
        if (DatabendRawType.startsWithIgnoreCase(typeName, "tuple")) {
            return TUPLE;
        }
        if (DatabendRawType.startsWithIgnoreCase(typeName, "binary")) {
            return BINARY;
        }
        if (DatabendRawType.startsWithIgnoreCase(typeName, "geometry")) {
            return GEOMETRY;
        }
        return NULL;
    }

    private DatabendDataType(int sqlType, String displayName, boolean signed, int length, boolean isTime, String ... aliases) {
        this.sqlType = sqlType;
        this.displayName = displayName;
        this.signed = signed;
        this.length = length;
        this.aliases = aliases;
        this.time = isTime;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isTime() {
        return this.time;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public static DatabendDataType ofType(String type) {
        String formattedType = type.trim().toUpperCase();
        return Optional.ofNullable(typeNameOrAliasToType.get(formattedType)).orElse(NULL);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sqlType", this.sqlType).add("displayName", this.displayName).add("signed", this.signed).add("length", this.length).add("time", this.time).add("aliases", Arrays.asList(this.aliases)).toString();
    }

    static {
        typeNameOrAliasToType = new HashMap<String, DatabendDataType>();
        for (DatabendDataType dataType : DatabendDataType.values()) {
            Arrays.stream(dataType.aliases).forEach(alias -> typeNameOrAliasToType.put(alias.toUpperCase(), dataType));
        }
    }
}

