/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client.data;

import com.databend.client.data.ColumnTypeHandler;
import java.math.BigDecimal;

class DecimalHandler
implements ColumnTypeHandler {
    private boolean isNullable;

    public DecimalHandler() {
        this.isNullable = false;
    }

    public DecimalHandler(boolean isNullable) {
        this.isNullable = isNullable;
    }

    @Override
    public Object parseValue(Object value) {
        if (this.isNullable) {
            return this.parseNullableValue(value);
        }
        return this.parseNonNullValue(value);
    }

    private BigDecimal parseNullableValue(Object value) {
        if (value == null || value.equals("NULL")) {
            return null;
        }
        if (value instanceof Integer) {
            return BigDecimal.valueOf(((Integer)value).intValue());
        }
        if (value instanceof String) {
            return new BigDecimal((String)value);
        }
        if (value instanceof Number) {
            return new BigDecimal((String)value);
        }
        return null;
    }

    private BigDecimal parseNonNullValue(Object value) {
        if (value == null || value.equals("NULL")) {
            throw new IllegalArgumentException("decimal type is not nullable");
        }
        if (value instanceof Integer) {
            return BigDecimal.valueOf(((Integer)value).intValue());
        }
        if (value instanceof String) {
            return new BigDecimal((String)value);
        }
        if (value instanceof Number) {
            return new BigDecimal((String)value);
        }
        return BigDecimal.ZERO;
    }

    @Override
    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }
}

