/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client.data;

import com.databend.client.data.ColumnTypeHandler;

public class GeometryHandler
implements ColumnTypeHandler {
    private boolean isNullable;

    public GeometryHandler(boolean isNullable) {
        this.isNullable = isNullable;
    }

    @Override
    public Object parseValue(Object value) {
        String wkbOrWkt;
        if (value == null) {
            if (this.isNullable) {
                return null;
            }
            throw new IllegalArgumentException("Geometry type is not nullable");
        }
        if (value instanceof String && ((wkbOrWkt = (String)value).startsWith("00") || wkbOrWkt.startsWith("01"))) {
            return GeometryHandler.hexStringToByteArray(wkbOrWkt);
        }
        return value;
    }

    @Override
    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }
}

