/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client.data;

import com.databend.client.data.ColumnTypeHandler;

class Int8Handler
implements ColumnTypeHandler {
    private boolean isNullable;

    public Int8Handler() {
        this.isNullable = false;
    }

    public Int8Handler(boolean isNullable) {
        this.isNullable = isNullable;
    }

    @Override
    public Object parseValue(Object value) {
        if (this.isNullable) {
            return this.parseNullableValue(value);
        }
        return this.parseNonNullValue(value);
    }

    private Byte parseNullableValue(Object value) {
        if (value == null || value.equals("NULL")) {
            return null;
        }
        if (value instanceof String) {
            return Byte.parseByte((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        return null;
    }

    private byte parseNonNullValue(Object value) {
        if (value == null || value.equals("NULL")) {
            throw new IllegalArgumentException("Int8 type is not nullable");
        }
        if (value instanceof String) {
            return Byte.parseByte((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        return 0;
    }

    @Override
    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }
}

