/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client.data;

import com.databend.client.data.ColumnTypeHandler;

class UInt16Handler
implements ColumnTypeHandler {
    private boolean isNullable;

    public UInt16Handler() {
        this.isNullable = false;
    }

    public UInt16Handler(boolean isNullable) {
        this.isNullable = isNullable;
    }

    @Override
    public Object parseValue(Object value) {
        if (this.isNullable) {
            return this.parseNullableValue(value);
        }
        return this.parseNonNullValue(value);
    }

    private Integer parseNullableValue(Object value) {
        if (value == null || value.equals("NULL")) {
            return null;
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return null;
    }

    private int parseNonNullValue(Object value) {
        if (value == null || value.equals("NULL")) {
            throw new IllegalArgumentException("UInt16 type is not nullable");
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return 0;
    }

    @Override
    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }
}

