/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc;

import com.databend.client.ClientSettings;
import com.databend.client.DatabendClient;
import com.databend.client.DatabendClientV1;
import com.databend.client.DatabendSession;
import com.databend.client.PaginationOptions;
import com.databend.client.QueryRequest;
import com.databend.client.StageAttachment;
import com.databend.jdbc.DatabendDatabaseMetaData;
import com.databend.jdbc.DatabendDriverUri;
import com.databend.jdbc.DatabendNodes;
import com.databend.jdbc.DatabendPreparedStatement;
import com.databend.jdbc.DatabendStatement;
import com.databend.jdbc.FileTransferAPI;
import com.databend.jdbc.PresignContext;
import com.databend.jdbc.annotation.NotImplemented;
import com.databend.jdbc.cloud.DatabendCopyParams;
import com.databend.jdbc.cloud.DatabendPresignClientV1;
import com.databend.jdbc.exception.DatabendFailedToPingException;
import com.google.shaded.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URI;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.zip.GZIPOutputStream;
import okhttp3.Headers;
import okhttp3.OkHttpClient;

public class DatabendConnection
implements Connection,
FileTransferAPI,
Consumer<DatabendSession> {
    private static final Logger logger = Logger.getLogger(DatabendConnection.class.getPackage().getName());
    private static FileHandler FILE_HANDLER;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean autoCommit = new AtomicBoolean(true);
    private final URI httpUri;
    private final AtomicReference<String> schema = new AtomicReference();
    private final OkHttpClient httpClient;
    private final Set<DatabendStatement> statements = Collections.newSetFromMap(new ConcurrentHashMap());
    private final DatabendDriverUri driverUri;
    private boolean autoDiscovery;
    private AtomicReference<DatabendSession> session = new AtomicReference();
    private String routeHint = "";
    private static final char SPECIAL_CHAR = '#';

    private void initializeFileHandler() {
        if (this.debug().booleanValue()) {
            File file = new File("databend-jdbc-debug.log");
            if (!file.canWrite()) {
                logger.warning("No write access to file: " + file.getAbsolutePath());
                return;
            }
            try {
                System.setProperty("java.util.logging.FileHandler.limit", "5242880000");
                System.setProperty("java.util.logging.FileHandler.count", "200");
                System.setProperty("java.util.logging.FileHandler.append", "true");
                FILE_HANDLER = new FileHandler(file.getAbsolutePath(), Integer.parseInt(System.getProperty("java.util.logging.FileHandler.limit")), Integer.parseInt(System.getProperty("java.util.logging.FileHandler.count")), true);
                FILE_HANDLER.setLevel(Level.ALL);
                FILE_HANDLER.setFormatter(new SimpleFormatter());
                logger.addHandler(FILE_HANDLER);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create FileHandler", e);
            }
        }
    }

    DatabendConnection(DatabendDriverUri uri, OkHttpClient httpClient) throws SQLException {
        Objects.requireNonNull(uri, "uri is null");
        this.httpUri = uri.getUri();
        this.httpClient = httpClient;
        this.driverUri = uri;
        this.setSchema(uri.getDatabase());
        this.routeHint = DatabendConnection.randRouteHint();
        this.autoDiscovery = uri.autoDiscovery();
        DatabendSession session = new DatabendSession.Builder().setDatabase(this.getSchema()).build();
        this.setSession(session);
        this.initializeFileHandler();
    }

    public static String randRouteHint() {
        String charset = "abcdef0123456789";
        Random rand = new Random();
        StringBuilder sb = new StringBuilder(16);
        for (int i = 0; i < 16; ++i) {
            sb.append(charset.charAt(rand.nextInt(charset.length())));
        }
        return sb.toString();
    }

    public static String uriRouteHint(String URI2) {
        String encodedUri = Base64.getEncoder().encodeToString(URI2.getBytes());
        return encodedUri + '#';
    }

    public static URI parseRouteHint(String routeHint) {
        if (routeHint == null || routeHint.isEmpty()) {
            return null;
        }
        try {
            if (routeHint.charAt(routeHint.length() - 1) != '#') {
                return null;
            }
            String encodedUri = routeHint.substring(0, routeHint.length() - 1);
            byte[] decodedBytes = Base64.getDecoder().decode(encodedUri);
            String decodedUri = new String(decodedBytes);
            return URI.create(decodedUri);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Failed to parse route hint: " + routeHint, e);
            return null;
        }
    }

    private static void checkResultSet(int resultSetType, int resultSetConcurrency) throws SQLFeatureNotSupportedException {
        if (resultSetType != 1003) {
            throw new SQLFeatureNotSupportedException("Result set type must be TYPE_FORWARD_ONLY");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Result set concurrency must be CONCUR_READ_ONLY");
        }
    }

    private static void checkHoldability(int resultSetHoldability) throws SQLFeatureNotSupportedException {
        if (resultSetHoldability != 1) {
            throw new SQLFeatureNotSupportedException("Result set holdability must be HOLD_CURSORS_OVER_COMMIT");
        }
    }

    public static String getCopyIntoSql(String database, DatabendCopyParams params) {
        StringBuilder sb = new StringBuilder();
        sb.append("COPY INTO ");
        if (database != null) {
            sb.append(database).append(".");
        }
        sb.append(params.getDatabaseTableName()).append(" ");
        sb.append("FROM ");
        sb.append(params.getDatabendStage().toString());
        sb.append(" ");
        sb.append(params.toString());
        return sb.toString();
    }

    public DatabendSession getSession() {
        return this.session.get();
    }

    public boolean inActiveTransaction() {
        if (this.session.get() == null) {
            return false;
        }
        return this.session.get().inActiveTransaction();
    }

    public void setSession(DatabendSession session) {
        if (session == null) {
            return;
        }
        this.session.set(session);
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.doCreateStatement();
    }

    private DatabendStatement doCreateStatement() throws SQLException {
        this.checkOpen();
        DatabendStatement statement = new DatabendStatement(this, this::unregisterStatement);
        this.registerStatement(statement);
        return statement;
    }

    private void registerStatement(DatabendStatement statement) {
        Preconditions.checkState(this.statements.add(statement), "Statement is already registered");
    }

    private void unregisterStatement(DatabendStatement statement) {
        Preconditions.checkState(this.statements.remove(statement), "Statement is not registered");
    }

    @Override
    public PreparedStatement prepareStatement(String s) throws SQLException {
        return this.prepareStatement(s, 0, 0);
    }

    @Override
    public CallableStatement prepareCall(String s) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareCall");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkOpen();
        return sql;
    }

    private void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
    }

    @Override
    public void commit() throws SQLException {
        this.checkOpen();
        try {
            this.startQuery("commit");
        }
        catch (SQLException e) {
            throw new SQLException("Failed to commit", e);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this.autoCommit.get();
    }

    @Override
    public void setAutoCommit(boolean b) throws SQLException {
        this.session.get().setAutoCommit(b);
        this.autoCommit.set(b);
    }

    @Override
    public void rollback() throws SQLException {
        this.checkOpen();
        try {
            this.startQuery("rollback");
        }
        catch (SQLException e) {
            throw new SQLException("Failed to rollback", e);
        }
    }

    @Override
    public void close() throws SQLException {
        for (Statement statement : this.statements) {
            statement.close();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed.get();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new DatabendDatabaseMetaData(this);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setReadOnly(boolean b) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public void setCatalog(String s) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public void setTransactionIsolation(int i) throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        DatabendConnection.checkResultSet(resultSetType, resultSetConcurrency);
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String s, int i, int i1) throws SQLException {
        DatabendPreparedStatement statement = new DatabendPreparedStatement(this, this::unregisterStatement, "test", s);
        this.registerStatement(statement);
        return statement;
    }

    @Override
    public CallableStatement prepareCall(String s, int i, int i1) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareCall");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException("getTypeMap");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("setTypeMap");
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    public int getMaxFailoverRetries() {
        return this.driverUri.getMaxFailoverRetry();
    }

    @Override
    @NotImplemented
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("setSavepoint");
    }

    @Override
    public Savepoint setSavepoint(String s) throws SQLException {
        throw new SQLFeatureNotSupportedException("setSavepoint");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("rollback");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("releaseSavepoint");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String s, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(s);
    }

    @Override
    public PreparedStatement prepareStatement(String s, int[] ints) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareStatement");
    }

    @Override
    public PreparedStatement prepareStatement(String s, String[] strings) throws SQLException {
        throw new SQLFeatureNotSupportedException("prepareStatement");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createClob");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createBlob");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("createNClob");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("createSQLXML");
    }

    @Override
    public boolean isValid(int i) throws SQLException {
        return !this.isClosed();
    }

    @Override
    public void setClientInfo(String s, String s1) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String s) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public Array createArrayOf(String s, Object[] objects) throws SQLException {
        throw new SQLFeatureNotSupportedException("createArrayOf");
    }

    @Override
    public Struct createStruct(String s, Object[] objects) throws SQLException {
        throw new SQLFeatureNotSupportedException("createStruct");
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkOpen();
        return this.schema.get();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkOpen();
        this.schema.set(schema);
        this.startQuery("use " + schema);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int i) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        if (this.isWrapperFor(aClass)) {
            return (T)this;
        }
        throw new SQLException("No wrapper for " + aClass);
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        return aClass.isInstance(this);
    }

    public boolean presignedUrlDisabled() {
        return this.driverUri.presignedUrlDisabled();
    }

    public boolean copyPurge() {
        return this.driverUri.copyPurge();
    }

    public boolean isAutoDiscovery() {
        return this.autoDiscovery;
    }

    public String warehouse() {
        return this.driverUri.getWarehouse();
    }

    public Boolean strNullAsNull() {
        return this.driverUri.getStrNullAsNull();
    }

    public Boolean useVerify() {
        return this.driverUri.getUseVerify();
    }

    public Boolean debug() {
        return this.driverUri.getDebug();
    }

    public String tenant() {
        return this.driverUri.getTenant();
    }

    public String nullDisplay() {
        return this.driverUri.nullDisplay();
    }

    public String binaryFormat() {
        return this.driverUri.binaryFormat();
    }

    public PaginationOptions getPaginationOptions() {
        PaginationOptions.Builder builder = PaginationOptions.builder();
        builder.setWaitTimeSecs(this.driverUri.getWaitTimeSecs());
        builder.setMaxRowsInBuffer(this.driverUri.getMaxRowsInBuffer());
        builder.setMaxRowsPerPage(this.driverUri.getMaxRowsPerPage());
        return builder.build();
    }

    public URI getURI() {
        return this.httpUri;
    }

    private String buildUrlWithQueryRequest(ClientSettings settings2, String querySql) {
        QueryRequest req = QueryRequest.builder().setSession(settings2.getSession()).setStageAttachment(settings2.getStageAttachment()).setPaginationOptions(settings2.getPaginationOptions()).setSql(querySql).build();
        String reqString = req.toString();
        if (reqString == null || reqString.isEmpty()) {
            throw new IllegalArgumentException("Invalid request: " + req);
        }
        return reqString;
    }

    public void PingDatabendClientV1() throws SQLException {
        try (Statement statement = this.createStatement();){
            statement.execute("select 1");
            ResultSet r = statement.getResultSet();
            while (r.next()) {
            }
        }
        catch (SQLException e) {
            throw new DatabendFailedToPingException(String.format("failed to ping databend server: %s", e.getMessage()));
        }
    }

    @Override
    public void accept(DatabendSession session) {
        this.setSession(session);
    }

    DatabendClient startQueryWithFailover(String sql, StageAttachment attach) throws SQLException {
        Throwable e = null;
        int times = this.getMaxFailoverRetries() + 1;
        for (int i = 1; i <= times; ++i) {
            if (e != null && !(e.getCause() instanceof ConnectException)) {
                throw new SQLException("Error start query: SQL: " + sql + " " + e.getMessage() + " cause: " + e.getCause(), e);
            }
            try {
                URI uri;
                String query_id = UUID.randomUUID().toString();
                String candidateHost = this.driverUri.getUri(query_id).toString();
                if (!this.inActiveTransaction()) {
                    this.routeHint = DatabendConnection.uriRouteHint(candidateHost);
                }
                if (this.routeHint != null && !this.routeHint.isEmpty() && (uri = DatabendConnection.parseRouteHint(this.routeHint)) != null) {
                    candidateHost = uri.toString();
                }
                ClientSettings.Builder sb = this.makeClientSettings(query_id, candidateHost);
                if (attach != null) {
                    sb.setStageAttachment(attach);
                }
                ClientSettings s = sb.build();
                logger.log(Level.FINE, "retry " + i + " times to execute query: " + sql + " on " + s.getHost());
                if (this.autoDiscovery) {
                    this.tryAutoDiscovery(this.httpClient, s);
                }
                return new DatabendClientV1(this.httpClient, sql, s, this);
            }
            catch (RuntimeException e1) {
                e = e1;
                continue;
            }
            catch (Exception e1) {
                throw new SQLException("Error executing query: SQL: " + sql + " " + e1.getMessage() + " cause: " + e1.getCause(), e1);
            }
        }
        throw new SQLException("Failover Retry Error executing query after " + this.getMaxFailoverRetries() + " failover retry: SQL: " + sql + " " + e.getMessage() + " cause: " + e.getCause(), e);
    }

    void tryAutoDiscovery(OkHttpClient client, ClientSettings settings2) {
        if (this.autoDiscovery) {
            DatabendNodes nodes;
            if (this.driverUri.enableMock()) {
                settings2.getAdditionalHeaders().put("~mock.unsupported.discovery", "true");
            }
            if ((nodes = this.driverUri.getNodes()) != null && nodes.needDiscovery()) {
                try {
                    nodes.discoverUris(client, settings2);
                }
                catch (UnsupportedOperationException e) {
                    logger.log(Level.WARNING, "Current Query Node do not support auto discovery, close the functionality: " + e.getMessage());
                    this.autoDiscovery = false;
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "Error auto discovery:  cause: " + e.getCause() + " message: " + e.getMessage());
                }
            }
        }
    }

    DatabendClient startQuery(String sql) throws SQLException {
        return this.startQueryWithFailover(sql, null);
    }

    DatabendClient startQuery(String sql, StageAttachment attach) throws SQLException {
        return this.startQueryWithFailover(sql, attach);
    }

    private ClientSettings.Builder makeClientSettings(String queryID, String host) {
        PaginationOptions options = this.getPaginationOptions();
        Map<String, String> additionalHeaders = this.setAdditionalHeaders();
        additionalHeaders.put("X-DATABEND-QUERY-ID", queryID);
        return new ClientSettings.Builder().setSession(this.session.get()).setHost(host).setQueryTimeoutSecs(this.driverUri.getQueryTimeout()).setConnectionTimeout(this.driverUri.getConnectionTimeout()).setSocketTimeout(this.driverUri.getSocketTimeout()).setPaginationOptions(options).setAdditionalHeaders(additionalHeaders);
    }

    private Map<String, String> setAdditionalHeaders() {
        HashMap<String, String> additionalHeaders = new HashMap<String, String>();
        if (!this.driverUri.getWarehouse().isEmpty()) {
            additionalHeaders.put("X-DATABEND-WAREHOUSE", this.driverUri.getWarehouse());
        }
        if (!this.driverUri.getTenant().isEmpty()) {
            additionalHeaders.put("X-DATABEND-TENANT", this.driverUri.getTenant());
        }
        if (!this.routeHint.isEmpty()) {
            additionalHeaders.put("X-DATABEND-ROUTE-HINT", this.routeHint);
        }
        return additionalHeaders;
    }

    @Override
    public void uploadStream(String stageName, String destPrefix, InputStream inputStream2, String destFileName, long fileSize, boolean compressData) throws SQLException {
        String s = stageName == null ? "~" : stageName.replaceAll("/$", "");
        String p = destPrefix.replaceAll("^/", "").replaceAll("/$", "");
        String dest = p + "/" + destFileName;
        try {
            InputStream dataStream = inputStream2;
            if (compressData) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = inputStream2.read(buffer)) != -1) {
                        gzipOutputStream.write(buffer, 0, len);
                    }
                }
                dataStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                fileSize = byteArrayOutputStream.size();
            }
            if (this.driverUri.presignedUrlDisabled().booleanValue()) {
                DatabendPresignClientV1 cli = new DatabendPresignClientV1(this.httpClient, this.httpUri.toString());
                cli.presignUpload(null, dataStream, s, p + "/", destFileName, fileSize, true);
            } else {
                long presignStartTime = System.nanoTime();
                PresignContext ctx = PresignContext.getPresignContext(this, PresignContext.PresignMethod.UPLOAD, s, dest);
                long presignEndTime = System.nanoTime();
                if (this.debug().booleanValue()) {
                    logger.info("presign cost time: " + (double)(presignEndTime - presignStartTime) / 1000000.0 + "ms");
                }
                Headers h = ctx.getHeaders();
                String presignUrl = ctx.getUrl();
                DatabendPresignClientV1 cli = new DatabendPresignClientV1(new OkHttpClient(), this.httpUri.toString());
                long uploadStartTime = System.nanoTime();
                cli.presignUpload(null, dataStream, h, presignUrl, fileSize, true);
                long uploadEndTime = System.nanoTime();
                if (this.debug().booleanValue()) {
                    logger.info("upload cost time: " + (double)(uploadEndTime - uploadStartTime) / 1000000.0 + "ms");
                }
            }
        }
        catch (RuntimeException e) {
            System.out.println(e.getMessage());
            throw new SQLException(e);
        }
        catch (IOException e) {
            logger.warning("failed to upload input stream, file size is:" + (double)fileSize / 1024.0 + e.getMessage());
            throw new SQLException(e);
        }
    }

    @Override
    public InputStream downloadStream(String stageName, String sourceFileName, boolean decompress) throws SQLException {
        String s = stageName.replaceAll("/$", "");
        DatabendPresignClientV1 cli = new DatabendPresignClientV1(this.httpClient, this.httpUri.toString());
        try {
            PresignContext ctx = PresignContext.getPresignContext(this, PresignContext.PresignMethod.DOWNLOAD, s, sourceFileName);
            Headers h = ctx.getHeaders();
            String presignUrl = ctx.getUrl();
            return cli.presignDownloadStream(h, presignUrl);
        }
        catch (RuntimeException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void copyIntoTable(String database, String tableName, DatabendCopyParams params) throws SQLException {
        DatabendCopyParams p = params == null ? DatabendCopyParams.builder().build() : params;
        Objects.requireNonNull(p.getDatabaseTableName(), "tableName is null");
        Objects.requireNonNull(p.getDatabendStage(), "stage is null");
        String sql = DatabendConnection.getCopyIntoSql(database, p);
        System.out.println(sql);
        Statement statement = this.createStatement();
        statement.execute(sql);
        ResultSet rs = statement.getResultSet();
        while (rs.next()) {
        }
    }
}

