/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc;

import com.databend.client.DatabendClient;
import com.databend.client.DatabendSession;
import com.databend.client.QueryResults;
import com.databend.client.StageAttachment;
import com.databend.jdbc.AbstractDatabendResultSet;
import com.databend.jdbc.DatabendConnection;
import com.databend.jdbc.DatabendResultSet;
import com.databend.jdbc.annotation.NotImplemented;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class DatabendStatement
implements Statement {
    private final AtomicReference<DatabendConnection> connection;
    private final Consumer<DatabendStatement> onClose;
    private int currentUpdateCount = -1;
    private final AtomicReference<DatabendResultSet> currentResult = new AtomicReference();
    private final AtomicReference<DatabendClient> executingClient = new AtomicReference();
    private final AtomicLong maxRows = new AtomicLong();
    private final AtomicBoolean closeOnCompletion = new AtomicBoolean();

    DatabendStatement(DatabendConnection connection, Consumer<DatabendStatement> onClose) {
        this.connection = new AtomicReference<DatabendConnection>(Objects.requireNonNull(connection, "connection is null"));
        this.onClose = Objects.requireNonNull(onClose, "onClose is null");
    }

    @Override
    public ResultSet executeQuery(String s) throws SQLException {
        this.execute(s);
        return this.currentResult.get();
    }

    @Override
    public int executeUpdate(String s) throws SQLException {
        return 0;
    }

    @Override
    public void close() throws SQLException {
        DatabendConnection connection = this.connection.getAndSet(null);
        if (connection == null) {
            return;
        }
        this.onClose.accept(this);
        DatabendClient client = this.executingClient.get();
        if (client != null) {
            client.close();
        }
        this.closeResultSet();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int i) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        long result = this.maxRows.get();
        if (result > Integer.MAX_VALUE) {
            throw new SQLException("Max rows exceeds limit of 2147483647");
        }
        return Math.toIntExact(result);
    }

    @Override
    public void setMaxRows(int i) throws SQLException {
        if (i < 0) {
            throw new SQLException("Max rows must be greater than or equal to zero");
        }
        this.maxRows.set(i);
    }

    @Override
    public void setEscapeProcessing(boolean b) throws SQLException {
        this.checkOpen();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 3000;
    }

    @Override
    public void setQueryTimeout(int i) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
        this.checkOpen();
        DatabendClient client = this.executingClient.get();
        if (client != null) {
            client.close();
        }
        this.closeResultSet();
    }

    private void closeResultSet() throws SQLException {
        ResultSet resultSet = this.currentResult.getAndSet(null);
        if (resultSet != null) {
            resultSet.close();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String s) throws SQLException {
        this.checkOpen();
    }

    @Override
    public boolean execute(String s) throws SQLException {
        boolean result = this.internalExecute(s, null);
        if (!result) {
            this.currentUpdateCount = -1;
        }
        return result;
    }

    private void clearCurrentResults() {
        this.currentResult.set(null);
    }

    private void updateClientSession(QueryResults q) {
        if (q == null) {
            return;
        }
        DatabendSession session = q.getSession();
        if (session == null) {
            return;
        }
        DatabendConnection connection = this.connection.get();
        connection.setSession(session);
    }

    final boolean internalExecute(String sql, StageAttachment attachment) throws SQLException {
        this.clearCurrentResults();
        this.checkOpen();
        DatabendClient client = null;
        DatabendResultSet resultSet = null;
        try {
            QueryResults results22;
            List<List<Object>> data;
            client = attachment == null ? this.connection().startQuery(sql) : this.connection().startQuery(sql, attachment);
            if (!client.hasNext() && client.getResults() != null && client.getResults().getError() != null) {
                throw AbstractDatabendResultSet.resultsException(client.getResults(), sql);
            }
            this.currentUpdateCount = this.isQueryStatement(sql) ? -1 : client.getResults().getStats().getScanProgress().getRows().intValue();
            this.executingClient.set(client);
            while (client.hasNext() && ((data = (results22 = client.getResults()).getData()) == null || data.isEmpty())) {
                client.advance();
            }
            resultSet = DatabendResultSet.create(this, client, this.maxRows.get());
            this.currentResult.set(resultSet);
            boolean results22 = true;
            return results22;
        }
        catch (RuntimeException e) {
            throw new SQLException("Error executing query: SQL: " + sql + " " + e.getMessage() + " cause: " + e.getCause(), e);
        }
        finally {
            this.executingClient.set(null);
            if (this.currentResult.get() == null) {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (client != null) {
                    client.close();
                }
            }
        }
    }

    final boolean isQueryStatement(String sql) {
        return sql.toLowerCase().startsWith("select") || sql.toLowerCase().startsWith("show");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        return this.currentResult.get();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.currentUpdateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return 1000;
    }

    @Override
    public void setFetchDirection(int i) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int i) throws SQLException {
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public void addBatch(String s) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batches not supported");
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batches not supported");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Batches not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection();
    }

    @Override
    public boolean getMoreResults(int i) throws SQLException {
        this.checkOpen();
        if (i == 1) {
            this.closeResultSet();
            return false;
        }
        if (i != 2 && i != 1) {
            throw new SQLException("Invalid value for getMoreResults: " + i);
        }
        throw new SQLFeatureNotSupportedException("Multiple results not supported");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException("getGeneratedKeys");
    }

    @Override
    public int executeUpdate(String s, int i) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String s, int[] ints) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String s, String[] strings) throws SQLException {
        return 0;
    }

    @Override
    public boolean execute(String s, int i) throws SQLException {
        return this.execute(s);
    }

    @Override
    public boolean execute(String s, int[] ints) throws SQLException {
        return this.execute(s);
    }

    @Override
    public boolean execute(String s, String[] strings) throws SQLException {
        return this.execute(s);
    }

    @Override
    @NotImplemented
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection.get() == null;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public void setPoolable(boolean b) throws SQLException {
        this.checkOpen();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkOpen();
        this.closeOnCompletion.set(true);
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkOpen();
        return this.closeOnCompletion.get();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException("No wrapper for " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        return aClass.isInstance(this);
    }

    protected final void checkOpen() throws SQLException {
        this.connection();
    }

    protected final DatabendConnection connection() throws SQLException {
        DatabendConnection connection = this.connection.get();
        if (connection == null) {
            throw new SQLException("Statement is closed");
        }
        if (connection.isClosed()) {
            throw new SQLException("Connection is closed");
        }
        return connection;
    }

    protected final Optional<DatabendConnection> optionalConnection() {
        return Optional.ofNullable(this.connection.get());
    }
}

