/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc;

import com.databend.client.data.DatabendDataType;
import com.databend.jdbc.DatabendColumnInfo;

public class JdbcTypeMapping {
    public int toSqlType(DatabendColumnInfo column) {
        DatabendDataType dataType = column.getType().getDataType();
        int sqlType = 1111;
        switch (dataType) {
            case BOOLEAN: {
                sqlType = 16;
                break;
            }
            case INT_8: {
                sqlType = -6;
                break;
            }
            case INT_16: {
                sqlType = 5;
                break;
            }
            case INT_32: {
                sqlType = 4;
                break;
            }
            case INT_64: {
                sqlType = -5;
                break;
            }
            case FLOAT: {
                sqlType = 6;
                break;
            }
            case DOUBLE: {
                sqlType = 8;
                break;
            }
            case DECIMAL: {
                sqlType = 3;
                break;
            }
            case STRING: {
                sqlType = 12;
                break;
            }
            case DATE: {
                sqlType = 91;
                break;
            }
            case TIMESTAMP: {
                sqlType = 93;
                break;
            }
            case ARRAY: {
                sqlType = 2003;
                break;
            }
            case VARIANT: {
                sqlType = 12;
                break;
            }
            case TUPLE: {
                sqlType = 2002;
                break;
            }
            case NULL: {
                sqlType = 0;
                break;
            }
        }
        return sqlType;
    }

    protected DatabendDataType getDataType(int sqlType) {
        DatabendDataType dataType;
        switch (sqlType) {
            case 16: {
                dataType = DatabendDataType.UNSIGNED_INT_8;
                break;
            }
            case -6: {
                dataType = DatabendDataType.INT_8;
                break;
            }
            case 5: {
                dataType = DatabendDataType.INT_16;
                break;
            }
            case 4: {
                dataType = DatabendDataType.INT_32;
                break;
            }
            case -5: {
                dataType = DatabendDataType.INT_64;
                break;
            }
            case 6: {
                dataType = DatabendDataType.FLOAT;
                break;
            }
            case 8: {
                dataType = DatabendDataType.DOUBLE;
                break;
            }
            case 3: {
                dataType = DatabendDataType.DECIMAL;
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -7: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 1111: 
            case 2000: 
            case 2004: 
            case 2005: 
            case 2009: 
            case 2011: {
                dataType = DatabendDataType.STRING;
                break;
            }
            case 91: {
                dataType = DatabendDataType.DATE;
                break;
            }
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                dataType = DatabendDataType.TIMESTAMP;
                break;
            }
            case 2003: {
                dataType = DatabendDataType.ARRAY;
                break;
            }
            case 2002: {
                dataType = DatabendDataType.TUPLE;
                break;
            }
            default: {
                dataType = DatabendDataType.NULL;
            }
        }
        return dataType;
    }
}

