/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc.cloud;

import com.databend.jdbc.cloud.DatabendPresignClient;
import com.databend.jdbc.cloud.InputStreamRequestBody;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.Okio;

public class DatabendPresignClientV1
implements DatabendPresignClient {
    private static final int MaxRetryAttempts = 20;
    private static final Duration RetryTimeout = Duration.ofMinutes(5L);
    private final OkHttpClient client;
    private final String uri;
    private static final Logger logger = Logger.getLogger(DatabendPresignClientV1.class.getPackage().getName());

    public DatabendPresignClientV1(OkHttpClient client, String uri) {
        Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINEST);
        OkHttpClient.Builder builder = client.newBuilder();
        this.client = builder.connectTimeout(120L, TimeUnit.SECONDS).build();
        this.uri = uri;
    }

    private void uploadFromStream(InputStream inputStream2, String stageName, String relativePath, String name, long fileSize) throws IOException {
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("upload", name, new InputStreamRequestBody(null, inputStream2, fileSize)).build();
        Headers headers2 = new Headers.Builder().add("stage_name", stageName).add("relative_path", relativePath).build();
        HttpUrl url = HttpUrl.get(this.uri);
        url = new HttpUrl.Builder().scheme(url.scheme()).host(url.host()).port(url.port()).encodedPath("/v1/upload_to_stage").build();
        Request request = new Request.Builder().url(url).headers(headers2).put(requestBody).build();
        try {
            this.executeInternal(request, true);
        }
        catch (IOException e) {
            throw new IOException("uploadFromStreamAPI failed", e);
        }
    }

    private void uploadFromStream(InputStream inputStream2, Headers headers2, String presignedUrl, long fileSize) throws IOException {
        Objects.requireNonNull(inputStream2, "inputStream is null");
        Request r = this.putRequest(headers2, presignedUrl, inputStream2, fileSize);
        try {
            this.executeInternal(r, true);
        }
        catch (IOException e) {
            throw new IOException(String.format(" uploadFromStream failed, file size is %s,  presignUrl is %s kb, error is %s", (double)fileSize / 1024.0, presignedUrl, e.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseBody executeInternal(Request request, boolean shouldClose) throws IOException {
        Objects.requireNonNull(request, "request is null");
        long start = System.nanoTime();
        long attempts = 0L;
        RuntimeException cause = null;
        while (true) {
            if (attempts > 0L) {
                logger.info("try to presign upload again: " + attempts);
                Duration sinceStart = Duration.ofNanos(System.nanoTime() - start);
                if (sinceStart.getSeconds() >= 900L) {
                    logger.warning("Presign upload failed, error is:" + cause.toString());
                    throw new RuntimeException(String.format("Error execute presign (attempts: %s, duration: %s)", attempts, sinceStart), cause);
                }
                if (attempts >= 20L) {
                    logger.warning("Presign upload failed, error is: " + cause.toString());
                    throw new RuntimeException(String.format("Error execute presign (attempts: %s, duration: %s)", attempts, sinceStart), cause);
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(attempts * 100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("StatementClient thread was interrupted");
                }
            }
            ++attempts;
            Response response = null;
            try {
                response = this.client.newCall(request).execute();
                if (response.isSuccessful()) {
                    ResponseBody e = response.body();
                    return e;
                }
                if (response.code() == 401) {
                    throw new RuntimeException("Error exeucte presign, Unauthorized user: " + response.code() + " " + response.message());
                }
                if (response.code() >= 503) {
                    cause = new RuntimeException("Error execute presign, service unavailable: " + response.code() + " " + response.message());
                    continue;
                }
                if (response.code() < 400) continue;
                cause = new RuntimeException("Error execute presign, configuration error: " + response.code() + " " + response.message());
                continue;
            }
            catch (SocketTimeoutException e) {
                logger.warning("Error execute presign, socket timeout: " + e.getMessage());
                cause = new RuntimeException("Error execute presign, request is " + request.toString() + "socket timeout: " + e.getMessage());
                continue;
            }
            catch (RuntimeException e) {
                cause = e;
                continue;
            }
            finally {
                if (!shouldClose) continue;
                try {
                    if (response == null) continue;
                    response.close();
                }
                catch (Exception e) {}
                continue;
            }
            break;
        }
    }

    @Override
    public void presignUpload(File srcFile, InputStream inputStream2, Headers headers2, String presignedUrl, long fileSize, boolean uploadFromStream) throws IOException {
        InputStream it = null;
        it = !uploadFromStream ? Files.newInputStream(srcFile.toPath(), new OpenOption[0]) : inputStream2;
        this.uploadFromStream(it, headers2, presignedUrl, fileSize);
    }

    @Override
    public void presignUpload(File srcFile, InputStream inputStream2, String stageName, String relativePath, String name, long fileSize, boolean uploadFromStream) throws IOException {
        if (!uploadFromStream) {
            try (InputStream it = Files.newInputStream(srcFile.toPath(), new OpenOption[0]);){
                this.uploadFromStream(it, stageName, relativePath, name, fileSize);
            }
        } else {
            this.uploadFromStream(inputStream2, stageName, relativePath, name, fileSize);
        }
    }

    @Override
    public void presignDownload(String destFileName, Headers headers2, String presignedUrl) {
        Request r = this.getRequest(headers2, presignedUrl);
        try (ResponseBody body = this.executeInternal(r, false);){
            BufferedSink sink2 = Okio.buffer(Okio.sink(new File(destFileName)));
            sink2.writeAll(body.source());
            sink2.close();
        }
        catch (IOException e) {
            throw new RuntimeException("presignDownload failed", e);
        }
    }

    @Override
    public InputStream presignDownloadStream(Headers headers2, String presignedUrl) {
        Request r = this.getRequest(headers2, presignedUrl);
        try {
            ResponseBody responseBody = this.executeInternal(r, false);
            return responseBody.byteStream();
        }
        catch (IOException e) {
            throw new RuntimeException("presignDownloadStream failed", e);
        }
    }

    private Request getRequest(Headers headers2, String url) {
        return new Request.Builder().headers(headers2).url(url).get().build();
    }

    private Request putRequest(Headers headers2, String url, InputStream inputStream2, long fileSize) throws IOException {
        InputStreamRequestBody input = new InputStreamRequestBody(null, inputStream2, fileSize);
        return new Request.Builder().headers(headers2).url(url).put(input).build();
    }
}

