/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc.log;

import com.databend.jdbc.log.DatabendLogger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JDKLogger
implements DatabendLogger {
    private final Logger logger;

    public JDKLogger(String name) {
        this.logger = Logger.getLogger(name);
    }

    @Override
    public void trace(String message) {
        this.logger.log(Level.FINEST, message);
    }

    @Override
    public void trace(String message, Object ... arguments) {
        this.logger.log(Level.FINEST, this.addMissingArgumentsIndexes(message), arguments);
    }

    @Override
    public void trace(String message, Throwable t) {
        this.logger.log(Level.FINEST, message, t);
    }

    @Override
    public void debug(String message) {
        this.logger.log(Level.FINE, message);
    }

    @Override
    public void debug(String message, Object ... arguments) {
        this.logger.log(Level.FINE, this.addMissingArgumentsIndexes(message), arguments);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.logger.log(Level.FINE, message, t);
    }

    @Override
    public void info(String message) {
        this.logger.log(Level.INFO, message);
    }

    @Override
    public void info(String message, Object ... arguments) {
        this.logger.log(Level.INFO, this.addMissingArgumentsIndexes(message), arguments);
    }

    @Override
    public void info(String message, Throwable t) {
        this.logger.log(Level.INFO, message, t);
    }

    @Override
    public void warn(String message) {
        this.logger.log(Level.WARNING, message);
    }

    @Override
    public void warn(String message, Object ... arguments) {
        this.logger.log(Level.WARNING, this.addMissingArgumentsIndexes(message), arguments);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.logger.log(Level.WARNING, message, t);
    }

    @Override
    public void error(String message) {
        this.logger.log(Level.SEVERE, message);
    }

    @Override
    public void error(String message, Object ... arguments) {
        this.logger.log(Level.SEVERE, this.addMissingArgumentsIndexes(message), arguments);
    }

    @Override
    public void error(String message, Throwable t) {
        this.logger.log(Level.SEVERE, message, t);
    }

    private String addMissingArgumentsIndexes(String message) {
        StringBuilder result = new StringBuilder();
        int argumentIndex = 0;
        for (int i = 0; i < message.length(); ++i) {
            if (message.charAt(i) == '{' && i < message.length() - 1 && message.charAt(i + 1) == '}') {
                result.append(String.format("{%d}", argumentIndex++));
                ++i;
                continue;
            }
            result.append(message.charAt(i));
        }
        return result.toString();
    }
}

