/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc;

import com.databend.jdbc.log.DatabendLogger;
import com.databend.jdbc.log.JDKLogger;
import com.databend.jdbc.log.SLF4JLogger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import lombok.Generated;

public final class LoggerUtil {
    @Generated
    private static final DatabendLogger log = LoggerUtil.getLogger(LoggerUtil.class.getName());
    private static Boolean slf4jAvailable;

    public static DatabendLogger getLogger(String name) {
        if (slf4jAvailable == null) {
            slf4jAvailable = LoggerUtil.isSlf4jJAvailable();
        }
        if (slf4jAvailable.booleanValue()) {
            return new SLF4JLogger(name);
        }
        return new JDKLogger(name);
    }

    public static InputStream logInputStream(InputStream is) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            ByteArrayInputStream streamToLog = new ByteArrayInputStream(baos.toByteArray());
            String text = new BufferedReader(new InputStreamReader((InputStream)streamToLog, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            log.info("======================================");
            log.info(text);
            log.info("======================================");
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (Exception ex) {
            log.warn("Could not log the stream", ex);
            return new ByteArrayInputStream(baos.toByteArray());
        }
    }

    private static boolean isSlf4jJAvailable() {
        try {
            Class.forName("org.slf4j.Logger");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    @Generated
    private LoggerUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

