/*
 * DATABRICKS CONFIDENTIAL & PROPRIETARY
 * __________________
 *
 * Copyright 2021-present Databricks, Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains the property of Databricks, Inc.
 * and its suppliers, if any.  The intellectual and technical concepts contained herein are
 * proprietary to Databricks, Inc. and its suppliers and may be covered by U.S. and foreign Patents,
 * patents in process, and are protected by trade secret and/or copyright law. Dissemination, use,
 * or reproduction of this information is strictly forbidden unless prior written permission is
 * obtained from Databricks, Inc.
 *
 * If you view or obtain a copy of this information and believe Databricks, Inc. may not have
 * intended it to be made available, please promptly report it to Databricks Legal Department
 * @ legal@databricks.com.
 */

package com.databricks.connect

import java.util.concurrent.Executor

import com.databricks.sdk.core.DatabricksConfig
import io.grpc._

private[connect] class DatabricksCallCredentials(config: DatabricksConfig) extends CallCredentials {
  override def applyRequestMetadata(
      requestInfo: CallCredentials.RequestInfo,
      executor: Executor,
      metadataApplier: CallCredentials.MetadataApplier): Unit = {
    executor.execute(() => {
      try {
        val metadata = new Metadata()
        val auth_headers = config.authenticate()

        auth_headers.forEach { (key, value) =>
          metadata.put(Metadata.Key.of(key, Metadata.ASCII_STRING_MARSHALLER), value)
        }

        metadataApplier.apply(metadata)
      } catch {
        case e: Throwable =>
          metadataApplier.fail(Status.UNAUTHENTICATED.withCause(e))
      }
    })
  }

  override def thisUsesUnstableApi(): Unit = {
    // CallCredentials API is marked as unstable in this verion of gRPC
  }
}
