/*
 * DATABRICKS CONFIDENTIAL & PROPRIETARY
 * __________________
 *
 * Copyright 2021-present Databricks, Inc.
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains the property of Databricks, Inc.
 * and its suppliers, if any.  The intellectual and technical concepts contained herein are
 * proprietary to Databricks, Inc. and its suppliers and may be covered by U.S. and foreign Patents,
 * patents in process, and are protected by trade secret and/or copyright law. Dissemination, use,
 * or reproduction of this information is strictly forbidden unless prior written permission is
 * obtained from Databricks, Inc.
 *
 * If you view or obtain a copy of this information and believe Databricks, Inc. may not have
 * intended it to be made available, please promptly report it to Databricks Legal Department
 * @ legal@databricks.com.
 */

package com.databricks.connect

import com.databricks.sdk.core.DatabricksConfig
import io.grpc.{ChannelCredentials, CompositeChannelCredentials, TlsChannelCredentials}

import org.apache.spark.sql.connect.client.SparkConnectClient

private[connect] class DatabricksSparkClientConfiguration(
    val config: DatabricksConfig,
    host: String,
    userAgent: String,
    headers: Map[String, String])
  extends SparkConnectClient.Configuration(
    host = host,
    isSslEnabled = Option(true),
    port = 443,
    metadata = headers,
    userAgent = SparkConnectClient.genUserAgent(userAgent)) {

  override def credentials: ChannelCredentials = {
    CompositeChannelCredentials.create(
      TlsChannelCredentials.create,
      new DatabricksCallCredentials(config))
  }
}
