//
// DATABRICKS CONFIDENTIAL & PROPRIETARY
// __________________
//
// Copyright 2023-present Databricks, Inc.
// All Rights Reserved.
//
// NOTICE:  All information contained herein is, and remains the property of Databricks, Inc.
// and its suppliers, if any.  The intellectual and technical concepts contained herein are
// proprietary to Databricks, Inc. and its suppliers and may be covered by U.S. and foreign Patents,
// patents in process, and are protected by trade secret and/or copyright law. Dissemination, use,
// or reproduction of this information is strictly forbidden unless prior written permission is
// obtained from Databricks, Inc.
//
// If you view or obtain a copy of this information and believe Databricks, Inc. may not have
// intended it to be made available, please promptly report it to Databricks Legal Department
// @ legal@databricks.com.
//

package com.databricks.sql

import org.apache.spark.annotation.{Py4JWhitelist, Stable}
import org.apache.spark.sql.{h3Functions, stFunctions}

// This import is patched during the build of the DB Connect client.
// Keeping this import separate to lower the chance that an import re-order breaks patching.
// scalastyle:off
import com.databricks.spark.util.DeprecatedFunctionLogging
// scalastyle:on

/**
 * Commonly used functions available for DataFrame operations. Using functions defined here
 * provides a little bit more compile-time safety to make sure the function exists.
 *
 * @groupname st_funcs ST geometry/geography fuctions
 * @groupname h3_funcs H3 geometry/geography functions
 */
@Py4JWhitelist
@Stable
// scalastyle:off
object functions extends DeprecatedFunctionLogging
  with stFunctions
  with h3Functions {
// scalastyle:on
}
