/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.apache.arrow.vector;

import com.databricks.internal.apache.arrow.memory.ArrowBuf;
import com.databricks.internal.apache.arrow.memory.BufferAllocator;
import com.databricks.internal.apache.arrow.vector.BaseFixedWidthVector;
import com.databricks.internal.apache.arrow.vector.BitVectorHelper;
import com.databricks.internal.apache.arrow.vector.NullCheckingForGet;
import com.databricks.internal.apache.arrow.vector.ValueIterableVector;
import com.databricks.internal.apache.arrow.vector.ValueVector;
import com.databricks.internal.apache.arrow.vector.complex.impl.TimeSecReaderImpl;
import com.databricks.internal.apache.arrow.vector.complex.reader.FieldReader;
import com.databricks.internal.apache.arrow.vector.holders.NullableTimeSecHolder;
import com.databricks.internal.apache.arrow.vector.holders.TimeSecHolder;
import com.databricks.internal.apache.arrow.vector.types.Types;
import com.databricks.internal.apache.arrow.vector.types.pojo.Field;
import com.databricks.internal.apache.arrow.vector.types.pojo.FieldType;
import com.databricks.internal.apache.arrow.vector.util.TransferPair;

public final class TimeSecVector
extends BaseFixedWidthVector
implements ValueIterableVector<Integer> {
    public static final byte TYPE_WIDTH = 4;

    public TimeSecVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.TIMESEC.getType()), allocator);
    }

    public TimeSecVector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public TimeSecVector(Field field, BufferAllocator allocator) {
        super(field, allocator, 4);
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new TimeSecReaderImpl(this);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.TIMESEC;
    }

    public int get(int index) throws IllegalStateException {
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.getInt((long)index * 4L);
    }

    public void get(int index, NullableTimeSecHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getInt((long)index * 4L);
    }

    @Override
    public Integer getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.valueBuffer.getInt((long)index * 4L);
    }

    private void setValue(int index, int value) {
        this.valueBuffer.setInt((long)index * 4L, value);
    }

    public void set(int index, int value) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, NullableTimeSecHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setBit(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void set(int index, TimeSecHolder holder) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, int value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableTimeSecHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, TimeSecHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void set(int index, int isSet, int value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void setSafe(int index, int isSet, int value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    public static int get(ArrowBuf buffer, int index) {
        return buffer.getInt((long)index * 4L);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return new TransferImpl(field, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((TimeSecVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        TimeSecVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new TimeSecVector(ref, TimeSecVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(Field field, BufferAllocator allocator) {
            this.to = new TimeSecVector(field, allocator);
        }

        public TransferImpl(TimeSecVector to) {
            this.to = to;
        }

        @Override
        public TimeSecVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            TimeSecVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            TimeSecVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, TimeSecVector.this);
        }
    }
}

